/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Messages;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String REPOSITORY_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    public static final int AGGREGATE_CACHE = 1;
    public static final int AGGREGATE_SHARED_CACHE = 2;
    public static final int AGGREGATE_CACHE_EXTENSIONS = 4;

    public static IAgentLocation getAgentLocation(IProvisioningAgent agent) {
        return (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) {
        return (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    public static URI getBundlePoolLocation(IProvisioningAgent agent, IProfile profile) {
        String path = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (path != null) {
            return new File(path).toURI();
        }
        IAgentLocation location = Util.getAgentLocation(agent);
        if (location == null) {
            return null;
        }
        return location.getDataArea("org.eclipse.equinox.p2.touchpoint.eclipse");
    }

    public static synchronized IFileArtifactRepository getBundlePoolRepository(IProvisioningAgent agent, IProfile profile) {
        URI location = Util.getBundlePoolLocation(agent, profile);
        if (location == null) {
            return null;
        }
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        try {
            return (IFileArtifactRepository)manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            try {
                String repositoryName = Messages.BundlePool;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                return (IFileArtifactRepository)manager.createRepository(location, repositoryName, REPOSITORY_TYPE, properties);
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalArgumentException(NLS.bind((String)Messages.bundle_pool_not_writeable, (Object)location));
            }
        }
    }

    public static IFileArtifactRepository getAggregatedBundleRepository(IProvisioningAgent agent, IProfile profile) {
        return Util.getAggregatedBundleRepository(agent, profile, 7);
    }

    public static IFileArtifactRepository getAggregatedBundleRepository(IProvisioningAgent agent, IProfile profile, int repoFilter) {
        IFileArtifactRepository bundlePool;
        String sharedCache;
        ArrayList<IFileArtifactRepository> bundleRepositories = new ArrayList<IFileArtifactRepository>();
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        if ((repoFilter & 2) != 0 && (sharedCache = profile.getProperty("org.eclipse.equinox.p2.cache.shared")) != null) {
            try {
                URI repoLocation = new File(sharedCache).toURI();
                IArtifactRepository repository = manager.loadRepository(repoLocation, null);
                if (repository != null && repository instanceof IFileArtifactRepository && !bundleRepositories.contains(repository)) {
                    bundleRepositories.add((IFileArtifactRepository)repository);
                }
            }
            catch (ProvisionException provisionException) {}
        }
        if ((repoFilter & 1) != 0 && (bundlePool = Util.getBundlePoolRepository(agent, profile)) != null) {
            bundleRepositories.add(bundlePool);
        }
        if ((repoFilter & 4) != 0) {
            List<String> repos = Util.getListProfileProperty(profile, CACHE_EXTENSIONS);
            for (String repo : repos) {
                try {
                    URI repoLocation;
                    try {
                        repoLocation = new URI(repo);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        repoLocation = URIUtil.fromString((String)repo);
                    }
                    IArtifactRepository repository = manager.loadRepository(repoLocation, null);
                    if (repository == null || !(repository instanceof IFileArtifactRepository) || bundleRepositories.contains(repository)) continue;
                    bundleRepositories.add((IFileArtifactRepository)repository);
                }
                catch (ProvisionException provisionException) {
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
                }
            }
        }
        return new AggregatedBundleRepository(agent, bundleRepositories);
    }

    private static List<String> getListProfileProperty(IProfile profile, String key) {
        ArrayList<String> listProperty = new ArrayList<String>();
        String dropinRepositories = profile.getProperty(key);
        if (dropinRepositories != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, PIPE);
            while (tokenizer.hasMoreTokens()) {
                listProperty.add(tokenizer.nextToken());
            }
        }
        return listProperty;
    }

    public static BundleInfo createBundleInfo(File bundleFile, String manifest) {
        String version;
        Map headers;
        BundleInfo bundleInfo;
        block8: {
            ManifestElement[] element;
            block7: {
                bundleInfo = new BundleInfo();
                if (bundleFile != null) {
                    bundleInfo.setLocation(bundleFile.toURI());
                }
                bundleInfo.setManifest(manifest);
                headers = ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(manifest.getBytes("UTF-8")), new HashMap());
                element = ManifestElement.parseHeader((String)"bsn", (String)((String)headers.get("Bundle-SymbolicName")));
                if (element != null && element.length != 0) break block7;
                return null;
            }
            bundleInfo.setSymbolicName(element[0].getValue());
            version = (String)headers.get("Bundle-Version");
            if (version != null) break block8;
            return null;
        }
        try {
            bundleInfo.setVersion(Version.parseVersion((String)version).toString());
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost != null) {
                bundleInfo.setFragmentHost(fragmentHost.trim());
            }
        }
        catch (BundleException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            return null;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            return null;
        }
        return bundleInfo;
    }

    public static File getArtifactFile(IProvisioningAgent agent, IArtifactKey artifactKey, IProfile profile) {
        IFileArtifactRepository aggregatedView = Util.getAggregatedBundleRepository(agent, profile);
        File bundleJar = aggregatedView.getArtifactFile(artifactKey);
        return bundleJar;
    }

    public static File getConfigurationFolder(IProfile profile) {
        String config = profile.getProperty("org.eclipse.equinox.p2.configurationFolder");
        if (config != null) {
            return new File(config);
        }
        return new File(Util.getInstallFolder(profile), "configuration");
    }

    public static URL getOSGiInstallArea() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location location = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        if (location == null) {
            return null;
        }
        if (!location.isSet()) {
            return null;
        }
        return location.getURL();
    }

    public static File getEclipseHome() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location eclipseHome = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.ECLIPSE_HOME_FILTER);
        if (eclipseHome == null || !eclipseHome.isSet()) {
            return null;
        }
        URL url = eclipseHome.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static File getInstallFolder(IProfile profile) {
        String folder = profile.getProperty("org.eclipse.equinox.p2.installFolder");
        return folder == null ? null : new File(folder);
    }

    public static File getLauncherPath(IProfile profile) {
        String launcherName;
        String name = profile.getProperty("eclipse.touchpoint.launcherName");
        if (name == null || name.length() == 0) {
            name = "eclipse";
        }
        return (launcherName = Util.getLauncherName(name, Util.getOSFromProfile(profile), Util.getInstallFolder(profile))) == null ? null : new File(Util.getInstallFolder(profile), launcherName);
    }

    private static String getLauncherName(String name, String os, File installFolder) {
        Path path;
        if (os == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName());
            if (info == null) {
                return null;
            }
            os = info.getOS();
        }
        if (os.equals("win32")) {
            path = new Path(name);
            if ("exe".equals(path.getFileExtension())) {
                return name;
            }
            return new StringBuffer(String.valueOf(name)).append(".exe").toString();
        }
        if (os.equals("macosx")) {
            File appFolder;
            path = new Path(name);
            if (path.segment(0).endsWith(".app")) {
                return name;
            }
            String appName = null;
            if (installFolder != null && (appFolder = new File(installFolder, new StringBuffer(String.valueOf(name)).append(".app").toString())).exists()) {
                try {
                    appName = appFolder.getCanonicalFile().getName();
                }
                catch (IOException iOException) {
                    appName = appFolder.getName();
                }
            }
            StringBuffer buffer = new StringBuffer();
            if (appName != null) {
                buffer.append(appName);
            } else {
                buffer.append(name.substring(0, 1).toUpperCase());
                buffer.append(name.substring(1));
                buffer.append(".app");
            }
            buffer.append("/Contents/MacOS/");
            buffer.append(name);
            return buffer.toString();
        }
        return name;
    }

    public static String getOSFromProfile(IProfile profile) {
        String environments = profile.getProperty("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            int i;
            String entry = tokenizer.nextToken();
            String key = entry.substring(0, i = entry.indexOf(61)).trim();
            if (!key.equals("osgi.os")) continue;
            return entry.substring(i + 1).trim();
        }
        return null;
    }

    public static String getManifest(Collection<ITouchpointData> data) {
        for (ITouchpointData td : data) {
            ITouchpointInstruction manifestInstruction = td.getInstruction("manifest");
            if (manifestInstruction == null) {
                return null;
            }
            String manifest = manifestInstruction.getBody();
            if (manifest == null || manifest.length() <= 0) continue;
            return manifest;
        }
        return null;
    }

    public static IStatus createError(String message) {
        return Util.createError(message, null);
    }

    public static IStatus createError(String message, Exception e) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", message, (Throwable)e);
    }

    public static File getLauncherConfigLocation(IProfile profile) {
        String launcherConfig = profile.getProperty("org.eclipse.equinox.p2.launcherConfiguration");
        return launcherConfig == null ? null : new File(launcherConfig);
    }

    public static String resolveArtifactParam(Map<String, Object> parameters) throws CoreException {
        String artifactLocation = (String)parameters.get("artifact.location");
        if (artifactLocation != null) {
            return artifactLocation;
        }
        IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
        if (artifactKey == null) {
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            throw new CoreException(Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu)));
        }
        throw new CoreException(Util.createError(NLS.bind((String)Messages.artifact_file_not_found, (Object)artifactKey)));
    }
}

