/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview;

import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.IContributionStateChangeListener;
import org.eclipse.equinox.jmx.internal.client.ui.invocationView.InvocationView;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewMessages;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanOpTable;
import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.ViewUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class MBeanInfoViewPart
extends ViewPart
implements ISelectionListener,
IContributionStateChangeListener {
    protected ContributionProxy fSelectedContribution;
    private ManagedForm fManagedForm;
    private MBeanOpTable fOpTable;
    private Font fBFont;
    private Text fPropertiesText;
    private Section fContributionSection;
    private Section fPropertiesSection;
    private Section fOperationsSection;
    private Label fC_title;
    private Label fC_desc;
    private Text fAttributesText;

    public void createPartControl(Composite parent) {
        FontData[] fd = parent.getFont().getFontData();
        this.fBFont = new Font((Device)parent.getDisplay(), fd[0].getName(), fd[0].getHeight(), 1);
        this.fManagedForm = new ManagedForm(parent);
        this.fManagedForm.getForm().setText(MBeanInfoViewMessages.MBeanInfoViewPart_8);
        Composite body = this.fManagedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(1808));
        this.createContributionTitleArea(body);
        this.createContributionPropertiesArea(body);
        this.createOperationsArea(body);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected FormToolkit getToolkit() {
        return this.fManagedForm.getToolkit();
    }

    public void dispose() {
        this.fBFont.dispose();
        this.fManagedForm.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.fManagedForm.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        String id = part.getSite().getId();
        if (id.equals("org.eclipse.equinox.jmx.client.ui.contributionsview")) {
            if (obj instanceof ContributionProxy) {
                ContributionProxy contrib = (ContributionProxy)obj;
                if (contrib == this.fSelectedContribution) {
                    return;
                }
                if (this.fSelectedContribution != null) {
                    this.fSelectedContribution.removeStateChangeListener((IContributionStateChangeListener)this);
                }
                this.fSelectedContribution = contrib;
                this.updateContributionTitle(true);
                this.updateProperties(true);
                this.updateOperations(true);
                if (this.fSelectedContribution == null) {
                    return;
                }
                this.fSelectedContribution.addStateChangeListener((IContributionStateChangeListener)this);
            } else if (obj == null) {
                this.fSelectedContribution = null;
                this.contributionRemoved(null);
            }
        }
    }

    private void createContributionTitleArea(Composite parent) {
        Composite comp = ViewUtil.createSection(MBeanInfoViewMessages.MBeanInfoViewPart_0, null, (IManagedForm)this.fManagedForm, parent, 2, false, true);
        FormToolkit toolkit = this.fManagedForm.getToolkit();
        this.fContributionSection = (Section)comp.getParent();
        toolkit.createLabel(comp, MBeanInfoViewMessages.contribution_name);
        this.fC_title = toolkit.createLabel(comp, "");
        this.fC_title.setFont(this.fBFont);
        this.fC_title.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(comp, MBeanInfoViewMessages.mbean_description);
        this.fC_desc = toolkit.createLabel(comp, "");
        this.fC_desc.setFont(this.fBFont);
        this.fC_desc.setLayoutData((Object)new GridData(768));
    }

    private void updateContributionTitle(boolean forceExpand) {
        boolean enabled = this.fSelectedContribution != null;
        this.fContributionSection.setEnabled(enabled);
        if (!this.fContributionSection.isEnabled() || forceExpand) {
            this.fContributionSection.setExpanded(enabled);
        }
        if (!enabled) {
            return;
        }
        String name = this.fSelectedContribution.getName();
        this.fC_title.setText(name);
        this.fManagedForm.getForm().setText(NLS.bind((String)MBeanInfoViewMessages.MBeanInfoViewPart_11, (Object)name));
        MBeanInfo info = this.fSelectedContribution.getMBeanInfo();
        if (info.getDescription() != null) {
            this.fC_desc.setText(info.getDescription());
        } else {
            this.fC_desc.setText("");
        }
    }

    private void createContributionPropertiesArea(Composite parent) {
        FormToolkit toolkit = this.fManagedForm.getToolkit();
        Composite comp = ViewUtil.createSection(MBeanInfoViewMessages.MBeanInfoViewPart_1, null, (IManagedForm)this.fManagedForm, parent, 1, false, true);
        this.fPropertiesSection = (Section)comp.getParent();
        this.fPropertiesText = toolkit.createText(comp, "", 2314);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.fPropertiesText.setLayoutData((Object)gd);
    }

    private void updateProperties(boolean forceExpand) {
        boolean enabled = this.fSelectedContribution != null && this.fSelectedContribution.getContributionProperties() != null && this.fSelectedContribution.getContributionProperties().iterator().hasNext();
        this.fPropertiesSection.setEnabled(enabled);
        if (!this.fPropertiesSection.isEnabled() || forceExpand) {
            this.fPropertiesSection.setExpanded(enabled);
        }
        if (!enabled) {
            return;
        }
        Iterator iter = this.fSelectedContribution.getContributionProperties().iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            sb.append(String.valueOf(iter.next().toString()) + (iter.hasNext() ? "\n" : ""));
        }
        this.fPropertiesText.setText(sb.toString());
    }

    private void createOperationsArea(Composite parent) {
        Composite comp = ViewUtil.createSection(MBeanInfoViewMessages.MBeanInfoViewPart_6, MBeanInfoViewMessages.MBeanInfoViewPart_7, (IManagedForm)this.fManagedForm, parent, 1, true, true);
        this.fOperationsSection = (Section)comp.getParent();
        this.fOpTable = new MBeanOpTable(comp, this);
        FormToolkit toolkit = this.fManagedForm.getToolkit();
        toolkit.createLabel(comp, MBeanInfoViewMessages.description);
        this.fAttributesText = toolkit.createText(comp, "", 2314);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        gd.heightHint = 30;
        this.fAttributesText.setLayoutData((Object)gd);
    }

    private void updateOperations(boolean forceExpand) {
        boolean enabled = this.fSelectedContribution != null && this.fSelectedContribution.getMBeanInfo() != null && (this.fSelectedContribution.getMBeanInfo().getOperations().length > 2 || this.fSelectedContribution.getMBeanInfo().getAttributes().length > 0);
        this.fOperationsSection.setEnabled(enabled);
        if (!this.fOperationsSection.isEnabled() || forceExpand) {
            this.fOperationsSection.setExpanded(enabled);
        }
        if (!enabled) {
            return;
        }
        MBeanInfo info = this.fSelectedContribution.getMBeanInfo();
        MBeanOperationInfo[] ops = info.getOperations();
        if (ops.length > 0) {
            this.fOpTable.setInput(this.fSelectedContribution);
        }
        StringBuffer sb = new StringBuffer();
        MBeanAttributeInfo[] attrs = info.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(attrs[i].getName());
            sb.append(':');
            sb.append(' ');
            sb.append(attrs[i].getDescription());
            ++i;
        }
    }

    public void contributionRemoved(ContributionProxy contribution) {
        this.fContributionSection.setEnabled(false);
        this.fContributionSection.setExpanded(false);
        this.fPropertiesSection.setEnabled(false);
        this.fPropertiesSection.setExpanded(false);
        this.fOperationsSection.setEnabled(false);
        this.fOperationsSection.setExpanded(false);
        InvocationView iv = (InvocationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.equinox.jmx.client.ui.invocationView");
        if (iv != null) {
            iv.clear();
        }
    }

    public void stateChanged(final ContributionProxy source) {
        this.fManagedForm.getForm().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MBeanInfoViewPart.this.fSelectedContribution = source;
                MBeanInfoViewPart.this.updateProperties(false);
            }
        });
    }
}

