/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.RangeDrawData;

public class Theme {
    Device device;
    int shellHandle;
    int fixedHandle;
    int buttonHandle;
    int arrowHandle;
    int frameHandle;
    int entryHandle;
    int checkButtonHandle;
    int radioButtonHandle;
    int notebookHandle;
    int treeHandle;
    int progressHandle;
    int toolbarHandle;
    int labelHandle;
    int separatorHandle;

    public Theme(Device device) {
        this.device = device;
        this.shellHandle = OS.gtk_window_new(0);
        this.fixedHandle = OS.gtk_fixed_new();
        this.buttonHandle = OS.gtk_button_new();
        this.arrowHandle = OS.gtk_arrow_new(1, 0);
        this.checkButtonHandle = OS.gtk_check_button_new();
        this.frameHandle = OS.gtk_check_button_new();
        this.entryHandle = OS.gtk_entry_new();
        this.radioButtonHandle = OS.gtk_radio_button_new(0);
        this.notebookHandle = OS.gtk_notebook_new();
        this.progressHandle = OS.gtk_progress_bar_new();
        this.toolbarHandle = OS.gtk_toolbar_new();
        this.treeHandle = OS.gtk_tree_view_new_with_model(0);
        this.separatorHandle = OS.gtk_vseparator_new();
        this.labelHandle = OS.gtk_label_new(null);
        OS.gtk_container_add(this.fixedHandle, this.labelHandle);
        OS.gtk_container_add(this.fixedHandle, this.frameHandle);
        OS.gtk_container_add(this.fixedHandle, this.entryHandle);
        OS.gtk_container_add(this.fixedHandle, this.separatorHandle);
        OS.gtk_container_add(this.fixedHandle, this.arrowHandle);
        OS.gtk_container_add(this.fixedHandle, this.toolbarHandle);
        OS.gtk_container_add(this.fixedHandle, this.progressHandle);
        OS.gtk_container_add(this.fixedHandle, this.checkButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.radioButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.buttonHandle);
        OS.gtk_container_add(this.fixedHandle, this.treeHandle);
        OS.gtk_container_add(this.fixedHandle, this.notebookHandle);
        OS.gtk_container_add(this.shellHandle, this.fixedHandle);
        OS.gtk_widget_realize(this.separatorHandle);
        OS.gtk_widget_realize(this.labelHandle);
        OS.gtk_widget_realize(this.frameHandle);
        OS.gtk_widget_realize(this.entryHandle);
        OS.gtk_widget_realize(this.arrowHandle);
        OS.gtk_widget_realize(this.buttonHandle);
        OS.gtk_widget_realize(this.treeHandle);
        OS.gtk_widget_realize(this.notebookHandle);
        OS.gtk_widget_realize(this.checkButtonHandle);
        OS.gtk_widget_realize(this.radioButtonHandle);
        OS.gtk_widget_realize(this.progressHandle);
        OS.gtk_widget_realize(this.toolbarHandle);
        OS.gtk_widget_realize(this.shellHandle);
    }

    static int createPixbuf(Image image) {
        int pixbuf;
        boolean hasMask;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, w, h);
        int colormap = OS.gdk_colormap_get_system();
        boolean bl = hasMask = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
        if (hasMask) {
            pixbuf = OS.gdk_pixbuf_new(0, true, 8, w[0], h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            int maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, w[0], h[0]);
            if (maskPixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(maskPixbuf, image.mask, 0, 0, 0, 0, 0, w[0], h[0]);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
            int maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
            byte[] maskLine = new byte[maskStride];
            int y = 0;
            while (y < h[0]) {
                int offset = pixels + y * stride;
                OS.memmove(line, offset, stride);
                int maskOffset = maskPixels + y * maskStride;
                OS.memmove(maskLine, maskOffset, maskStride);
                int x = 0;
                while (x < w[0]) {
                    if (maskLine[x * 3] == 0) {
                        line[x * 4 + 3] = 0;
                    }
                    ++x;
                }
                OS.memmove(offset, line, stride);
                ++y;
            }
            OS.g_object_unref(maskPixbuf);
        } else {
            ImageData data = image.getImageData();
            boolean hasAlpha = data.getTransparencyType() == 1;
            pixbuf = OS.gdk_pixbuf_new(0, hasAlpha, 8, w[0], h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            if (hasAlpha) {
                byte[] alpha = data.alphaData;
                int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                byte[] line = new byte[stride];
                int y = 0;
                while (y < h[0]) {
                    int offset = pixels + y * stride;
                    OS.memmove(line, offset, stride);
                    int x = 0;
                    while (x < w[0]) {
                        line[x * 4 + 3] = alpha[y * w[0] + x];
                        ++x;
                    }
                    OS.memmove(offset, line, stride);
                    ++y;
                }
            }
        }
        return pixbuf;
    }

    void checkTheme() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public Rectangle computeTrim(GC gc, DrawData data) {
        if (gc == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        return data.computeTrim(this, gc);
    }

    public void dispose() {
        if (this.shellHandle == 0) {
            return;
        }
        OS.gtk_widget_destroy(this.shellHandle);
        this.separatorHandle = 0;
        this.labelHandle = 0;
        this.toolbarHandle = 0;
        this.progressHandle = 0;
        this.treeHandle = 0;
        this.notebookHandle = 0;
        this.radioButtonHandle = 0;
        this.checkButtonHandle = 0;
        this.entryHandle = 0;
        this.frameHandle = 0;
        this.arrowHandle = 0;
        this.buttonHandle = 0;
        this.fixedHandle = 0;
        this.shellHandle = 0;
    }

    public void drawBackground(GC gc, Rectangle bounds, DrawData data) {
        this.checkTheme();
        if (gc == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        data.draw(this, gc, bounds);
    }

    public void drawFocus(GC gc, Rectangle bounds, DrawData data) {
        this.checkTheme();
        if (gc == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.drawFocus(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void drawImage(GC gc, Rectangle bounds, DrawData data, Image image, int flags) {
        this.checkTheme();
        if (gc == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        data.drawImage(this, image, gc, bounds);
    }

    public void drawText(GC gc, Rectangle bounds, DrawData data, String text, int flags) {
        this.checkTheme();
        if (gc == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (text == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        data.drawText(this, text, flags, gc, bounds);
    }

    public Rectangle getBounds(int part, Rectangle bounds, DrawData data) {
        this.checkTheme();
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        return data.getBounds(part, bounds);
    }

    public int getSelection(Point offset, Rectangle bounds, RangeDrawData data) {
        this.checkTheme();
        if (offset == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        return data.getSelection(offset, bounds);
    }

    public int hitBackground(Point position, Rectangle bounds, DrawData data) {
        this.checkTheme();
        if (position == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        return data.hit(this, position, bounds);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public Rectangle measureText(GC gc, Rectangle bounds, DrawData data, String text, int flags) {
        this.checkTheme();
        if (gc == null) {
            SWT.error(4);
        }
        if (data == null) {
            SWT.error(4);
        }
        if (text == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        return data.measureText(this, text, flags, gc, bounds);
    }

    int getWidgetProperty(int handle, String name) {
        byte[] propertyName = Converter.wcsToMbcs(null, name, true);
        int[] result = new int[1];
        OS.gtk_widget_style_get(handle, propertyName, result, 0);
        return result[0];
    }

    void transferClipping(GC gc, int style) {
        GCData data = gc.getGCData();
        int clipRgn = data.clipRgn;
        int damageRgn = data.damageRgn;
        int clipping = clipRgn;
        if (damageRgn != 0) {
            if (clipping != 0) {
                clipping = OS.gdk_region_new();
                OS.gdk_region_union(clipping, clipRgn);
                OS.gdk_region_intersect(clipping, damageRgn);
            } else {
                clipping = damageRgn;
            }
        }
        int[] curGC = new int[1];
        int i = 0;
        while (i < 5) {
            OS.gtk_style_get_fg_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_bg_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_light_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_dark_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_mid_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_text_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            OS.gtk_style_get_text_aa_gc(style, i, curGC);
            if (curGC[0] != 0) {
                OS.gdk_gc_set_clip_region(curGC[0], clipping);
            }
            ++i;
        }
        OS.gtk_style_get_black_gc(style, curGC);
        if (curGC[0] != 0) {
            OS.gdk_gc_set_clip_region(curGC[0], clipping);
        }
        OS.gtk_style_get_white_gc(style, curGC);
        if (curGC[0] != 0) {
            OS.gdk_gc_set_clip_region(curGC[0], clipping);
        }
        if (clipping != clipRgn && clipping != damageRgn) {
            OS.gdk_region_destroy(clipping);
        }
    }
}

