/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int scrolledVisibleRgn;
    int siblingsVisibleRgn;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        short[] buffer = new short[1];
        OS.CountSubControls(this.handle, buffer);
        int count = buffer[0];
        Control[] children = new Control[count];
        int i = 0;
        int j = 0;
        int child = OS.HIViewGetFirstSubview(this.handle);
        while (i < count) {
            Widget widget;
            if (child != 0 && (widget = this.display.getWidget(child)) != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            child = OS.HIViewGetNextView(child);
            ++i;
        }
        if (j == count) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        if ((this.state & 2) != 0) {
            return 0;
        }
        return super.callFocusEventHandler(nextHandler, theEvent);
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x2000;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        this.display.runSkin();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void createHandle() {
        boolean scrolled;
        this.state |= 0x22;
        boolean bl = scrolled = (this.style & 0x300) != 0;
        if (!scrolled) {
            this.state |= 0x800;
        }
        if (scrolled || (this.style & 0x800) != 0) {
            this.createScrolledHandle(this.parent.handle);
        } else {
            this.createHandle(this.parent.handle);
        }
    }

    void createHandle(int parentHandle) {
        int features = 6;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(parentHandle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
    }

    void createScrolledHandle(int parentHandle) {
        int features = 2;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(parentHandle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.scrolledHandle = outControl[0];
        outControl[0] = 0;
        OS.CreateUserPaneControl(window, null, features |= 4, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        OS.HIObjectSetAccessibilityIgnored(this.scrolledHandle, true);
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            control.fillBackground(this.handle, gc.handle, new Rectangle(x, y, width, height), offsetX, offsetY);
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    void drawBackground(int control, int context) {
        if (control == this.scrolledHandle) {
            boolean drawBackground;
            Composite parent = this;
            Shell shell = this.getShell();
            if (shell != this) {
                parent = this.parent;
            }
            boolean bl = drawBackground = (this.style & 0x40000000) == 0;
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                parent.drawFocus(control, context, this.hasFocus() && this.drawFocusRing(), this.hasBorder(), drawBackground, this.inset());
            } else if (this.hasBorder()) {
                parent.drawFocus(control, context, false, this.hasBorder(), drawBackground, this.inset());
            } else {
                parent.fillBackground(control, context, null);
            }
        } else if ((this.state & 2) != 0 && (this.style & 0x40040000) == 0) {
            this.fillBackground(control, context, null);
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            if (this.horizontalBar != null) {
                this.horizontalBar.enableWidget(enabled);
            }
            if (this.verticalBar != null) {
                this.verticalBar.enableWidget(enabled);
            }
            return;
        }
        super.enableWidget(enabled);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        short[] count = new short[1];
        OS.CountSubControls(this.handle, count);
        return count[0];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (!clipChildren && control == this.handle) {
            if (this.siblingsVisibleRgn == 0) {
                this.siblingsVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.siblingsVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn(this.siblingsVisibleRgn, result);
            return result;
        }
        if (control == this.scrolledHandle) {
            if (!clipChildren) {
                return super.getVisibleRegion(control, clipChildren);
            }
            if (this.scrolledVisibleRgn == 0) {
                this.scrolledVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.scrolledVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn(this.scrolledVisibleRgn, result);
            return result;
        }
        return super.getVisibleRegion(control, clipChildren);
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            if (!this.isEnabled()) {
                return result;
            }
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                int[] theControl = new int[1];
                int window = OS.GetControlOwner(this.handle);
                OS.GetKeyboardFocus(window, theControl);
                if (this.handle != theControl[0]) {
                    short[] count = new short[1];
                    OS.CountSubControls(this.handle, count);
                    if (count[0] == 0 && OS.SetKeyboardFocus(window, this.handle, (short)this.focusPart()) == 0) {
                        return 0;
                    }
                }
            }
        }
        return result;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        if ((this.state & 2) != 0) {
            return 0;
        }
        return super.kEventControlGetFocusPart(nextHandler, theEvent, userData);
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0 && (this.state & 2) != 0 && this.scrolledHandle != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            this.redrawWidget(this.scrolledHandle, false);
        }
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                Shell shell = this.getShell();
                int bits = 540672;
                if ((shell.style & bits) == bits) {
                    return 0;
                }
            }
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                short[] button = new short[1];
                OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
                if (button[0] == 1 && this.getChildrenCount() == 0) {
                    this.setFocus();
                }
            }
        }
        return result;
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int[] theControl = new int[1];
            OS.GetKeyboardFocus(OS.GetControlOwner(this.handle), theControl);
            if (theControl[0] != this.handle) {
                if (!this.sendKeyEvent(1, theEvent)) {
                    return 0;
                }
                return -9874;
            }
        }
        if ((this.state & 2) != 0) {
            int[] keyCode = new int[1];
            OS.GetEventParameter(theEvent, 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            if (keyCode[0] == 49) {
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if (modifiers[0] == 256 && !this.sendKeyEvent(1, theEvent)) {
                    return 0;
                }
            }
        }
        return -9874;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if ((this.state & 2) != 0) {
            int[] keyboardEvent = new int[1];
            OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
            int[] keyCode = new int[1];
            OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 36: 
                case 76: {
                    return 0;
                }
            }
        }
        return result;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion(int control) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            child.resetVisibleRegion(control);
            child.invalidateChildrenVisibleRegion(control);
            ++i;
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i = 0;
            while (i < changed.length) {
                Control control = changed[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (!ancestor) {
                    this.error(32);
                }
                ++i;
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            int i2 = 0;
            while (i2 < changed.length) {
                Control child = changed[i2];
                Composite composite = child.parent;
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x1000;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x2000;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
                ++i2;
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            i2 = updateCount - 1;
            while (i2 >= 0) {
                update[i2].updateLayout(false);
                --i2;
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (changed) {
                this.state |= 0x2000;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize(int wHint, int Hint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn(this.scrolledVisibleRgn);
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn(this.siblingsVisibleRgn);
        }
        this.scrolledVisibleRgn = 0;
        this.siblingsVisibleRgn = 0;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null) {
                child.reskin(flags);
            }
            ++i;
        }
    }

    void resetVisibleRegion(int control) {
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn(this.scrolledVisibleRgn);
            this.scrolledVisibleRgn = 0;
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn(this.siblingsVisibleRgn);
            this.siblingsVisibleRgn = 0;
        }
        super.resetVisibleRegion(control);
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (this.layout != null && (result & 0x80) != 0) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return result;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    int traversalCode(int key, int theEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, theEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean changed = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.display.runSkin();
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFBFFF;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }
}

