/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlKind;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] outMetric = new int[1];
        OS.GetThemeMetric(0, outMetric);
        if (this.horizontalBar != null) {
            height += outMetric[0];
        }
        if (this.verticalBar != null) {
            width += outMetric[0];
        }
        Rect inset = this.inset();
        return new Rectangle(x -= inset.left, y -= inset.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    ScrollBar createScrollBar(int style) {
        return new ScrollBar(this, style);
    }

    ScrollBar createStandardBar(int style) {
        int barHandle = this.findStandardBar(style);
        if (barHandle == 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.handle = barHandle;
        bar.register();
        bar.hookEvents();
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void destroyScrollBar(ScrollBar bar) {
        this.setScrollBarVisible(bar, false);
        bar.destroyHandle();
    }

    int findStandardBar(int style) {
        int parentHandle = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
        short[] count = new short[1];
        OS.CountSubControls(parentHandle, count);
        if (count[0] == 0) {
            return 0;
        }
        int barHandle = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(0, outMetric);
        int[] outControl = new int[1];
        ControlKind kind = new ControlKind();
        int[] property = new int[1];
        int i = 0;
        while (i < count[0]) {
            OS.GetIndexedSubControl(parentHandle, (short)(i + 1), outControl);
            OS.GetControlKind(outControl[0], kind);
            if (kind.kind == 1935827314) {
                property[0] = 0;
                OS.GetControlProperty(outControl[0], 1937208368, 1937208368, 4, null, property);
                if (property[0] == 0) {
                    Point point = this.getControlSize(outControl[0]);
                    if ((style & 0x100) != 0) {
                        if (point.y == outMetric[0]) {
                            barHandle = outControl[0];
                        }
                    } else if (point.x == outMetric[0]) {
                        barHandle = outControl[0];
                    }
                }
            }
            ++i;
        }
        return barHandle;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.state & 2) != 0 && this.hasBorder()) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric(5, outMetric);
            return outMetric[0];
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        return new Rectangle(0, 0, rect.right - rect.left, rect.bottom - rect.top);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0 && this.scrolledHandle != 0) {
            int controlProc = this.display.controlProc;
            int[] mask = new int[]{1668183148, 4};
            int controlTarget = OS.GetControlEventTarget(this.scrolledHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask.length / 2, mask, this.scrolledHandle, null);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    Rect inset() {
        if ((this.state & 2) != 0) {
            Rect rect = new Rect();
            int[] outMetric = new int[1];
            if (this.drawFocusRing() && (this.style & 0x80000) == 0 && this.hooksKeys()) {
                OS.GetThemeMetric(7, outMetric);
                rect.left = (short)(rect.left + outMetric[0]);
                rect.top = (short)(rect.top + outMetric[0]);
                rect.right = (short)(rect.right + outMetric[0]);
                rect.bottom = (short)(rect.bottom + outMetric[0]);
            }
            if (this.hasBorder()) {
                OS.GetThemeMetric(5, outMetric);
                rect.left = (short)(rect.left + outMetric[0]);
                rect.top = (short)(rect.top + outMetric[0]);
                rect.right = (short)(rect.right + outMetric[0]);
                rect.bottom = (short)(rect.bottom + outMetric[0]);
            }
            return rect;
        }
        return EMPTY_RECT;
    }

    boolean isTrimHandle(int trimHandle) {
        if (this.horizontalBar != null && this.horizontalBar.handle == trimHandle) {
            return true;
        }
        if (this.verticalBar != null && this.verticalBar.handle == trimHandle) {
            return true;
        }
        return trimHandle == this.scrolledHandle;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        Event event;
        int position;
        int vPosition = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int hPosition = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int result = super.kEventMouseWheelMoved(nextHandler, theEvent, userData);
        boolean redraw = false;
        if (this.verticalBar != null && (position = this.verticalBar.getSelection()) != vPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.verticalBar.sendSelectionEvent(13, event, true);
            redraw = true;
        }
        if (this.horizontalBar != null && (position = this.horizontalBar.getSelection()) != hPosition) {
            event = new Event();
            event.detail = position < hPosition ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendSelectionEvent(13, event, true);
            redraw = true;
        }
        if (redraw) {
            this.redrawBackgroundImage();
        }
        return result;
    }

    void redrawBackgroundImage() {
        Control control;
        if (this.scrolledHandle == 0 && (control = this.findBackgroundControl()) != null && control.backgroundImage != null) {
            this.redrawWidget(this.handle, false);
        }
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void resetVisibleRegion(int control) {
        if (this.verticalBar != null) {
            this.verticalBar.resetVisibleRegion(control);
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.resetVisibleRegion(control);
        }
        super.resetVisibleRegion(control);
    }

    void resizeClientArea() {
        boolean isVisibleVBar;
        if (this.scrolledHandle == 0) {
            return;
        }
        if ((this.state & 2) == 0) {
            return;
        }
        int vWidth = 0;
        int hHeight = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(0, outMetric);
        boolean isVisibleHBar = this.horizontalBar != null && this.horizontalBar.getVisible();
        boolean bl = isVisibleVBar = this.verticalBar != null && this.verticalBar.getVisible();
        if (isVisibleHBar) {
            hHeight = outMetric[0];
        }
        if (isVisibleVBar) {
            vWidth = outMetric[0];
        }
        CGRect rect = new CGRect();
        OS.HIViewGetBounds(this.scrolledHandle, rect);
        int width = (int)rect.width;
        int height = (int)rect.height;
        Rect inset = this.inset();
        width = Math.max(0, width - vWidth - inset.left - inset.right);
        height = Math.max(0, height - hHeight - inset.top - inset.bottom);
        this.setBounds(this.handle, inset.left, inset.top, width, height, true, true, false);
        if (isVisibleHBar) {
            this.setBounds(this.horizontalBar.handle, inset.left, inset.top + height, width, hHeight, true, true, false);
        }
        if (isVisibleVBar) {
            this.setBounds(this.verticalBar.handle, inset.left + width, inset.top, vWidth, height, true, true, false);
        }
    }

    void reskinChildren(int flags) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(flags);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    boolean sendMouseWheel(short wheelAxis, int wheelDelta) {
        if ((this.state & 2) != 0) {
            ScrollBar bar;
            ScrollBar scrollBar = bar = wheelAxis == 0 ? this.horizontalBar : this.verticalBar;
            if (bar != null && bar.getEnabled()) {
                bar.setSelection(Math.max(0, bar.getSelection() - bar.getIncrement() * wheelDelta));
                Event event = new Event();
                event.detail = wheelDelta > 0 ? 0x1000005 : 0x1000006;
                bar.sendSelectionEvent(13, event, true);
                return true;
            }
        }
        return false;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, false);
        if ((result & 0x40) != 0 && events) {
            this.sendEvent(10);
        }
        if ((result & 0x80) != 0) {
            this.resizeClientArea();
            if (events) {
                this.sendEvent(11);
            }
        }
        return result;
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        if (this.scrolledHandle == 0) {
            return false;
        }
        if ((this.state & 2) == 0) {
            return false;
        }
        this.resizeClientArea();
        this.setVisible(bar.handle, visible);
        return true;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview(this.scrolledHandle, this.handle);
        }
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return this.handle;
    }
}

