/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.Policy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.BundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Directory;
import org.eclipse.equinox.internal.p2.discovery.compatibility.DiscoveryRegistryStrategy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.JarDiscoverySource;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.discovery.compatibility.util.TransportUtil;
import org.eclipse.osgi.util.NLS;

public class RemoteBundleDiscoveryStrategy
extends BundleDiscoveryStrategy {
    private String directoryUrl;
    private DiscoveryRegistryStrategy registryStrategy;
    private File temporaryStorage;
    private int maxDiscoveryJarDownloadAttempts = 1;

    /*
     * Exception decompiling
     */
    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[CATCHBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ExecutorService createExecutorService(int size) {
        return Executors.newFixedThreadPool(Math.min(size, 4));
    }

    private boolean isUnknownHostException(Throwable t) {
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return true;
            }
            Throwable t2 = t.getCause();
            if (t2 == t) break;
            t = t2;
        }
        return false;
    }

    private void delete(File file) {
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.temporaryStorage != null) {
            this.delete(this.temporaryStorage);
        }
    }

    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    public void setDirectoryUrl(String directoryUrl) {
        this.directoryUrl = directoryUrl;
    }

    protected AbstractCatalogSource computeDiscoverySource(IContributor contributor) {
        Directory.Entry directoryEntry = this.registryStrategy.getDirectoryEntry(contributor);
        Policy policy = new Policy(directoryEntry.isPermitCategories());
        JarDiscoverySource discoverySource = new JarDiscoverySource(contributor.getName(), this.registryStrategy.getJarFile(contributor));
        discoverySource.setPolicy(policy);
        return discoverySource;
    }

    public int getMaxDiscoveryJarDownloadAttempts() {
        return this.maxDiscoveryJarDownloadAttempts;
    }

    public void setMaxDiscoveryJarDownloadAttempts(int maxDiscoveryJarDownloadAttempts) {
        if (maxDiscoveryJarDownloadAttempts < 1 || maxDiscoveryJarDownloadAttempts > 2) {
            throw new IllegalArgumentException();
        }
        this.maxDiscoveryJarDownloadAttempts = maxDiscoveryJarDownloadAttempts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DownloadBundleJob
    implements Callable<DownloadBundleJob> {
        private final IProgressMonitor monitor;
        private final Directory.Entry entry;
        private File file;

        public DownloadBundleJob(Directory.Entry entry, IProgressMonitor monitor) {
            this.entry = entry;
            this.monitor = monitor;
        }

        @Override
        public DownloadBundleJob call() {
            String bundleUrl = this.entry.getLocation();
            int attemptCount = 0;
            while (attemptCount < RemoteBundleDiscoveryStrategy.this.maxDiscoveryJarDownloadAttempts) {
                try {
                    String lastPathElement = bundleUrl.lastIndexOf(47) == -1 ? bundleUrl : bundleUrl.substring(bundleUrl.lastIndexOf(47));
                    File target = File.createTempFile(String.valueOf(lastPathElement.replaceAll("^[a-zA-Z0-9_.]", "_")) + "_", ".jar", RemoteBundleDiscoveryStrategy.this.temporaryStorage);
                    if (this.monitor.isCanceled()) break;
                    TransportUtil.downloadResource(new URI(bundleUrl), target, (IProgressMonitor)new NullProgressMonitor(){

                        public boolean isCanceled() {
                            return super.isCanceled() || DownloadBundleJob.this.monitor.isCanceled();
                        }
                    });
                    this.file = target;
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.RemoteBundleDiscoveryStrategy_Invalid_source_specified_Error, (Object)bundleUrl), (Throwable)e));
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.RemoteBundleDiscoveryStrategy_cannot_download_bundle, (Object)bundleUrl, (Object)e.getMessage()), (Throwable)e));
                    if (RemoteBundleDiscoveryStrategy.this.isUnknownHostException(e)) {
                        break;
                    }
                }
                catch (CoreException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.RemoteBundleDiscoveryStrategy_cannot_download_bundle, (Object)bundleUrl, (Object)e.getMessage()), (Throwable)e));
                }
                ++attemptCount;
            }
            return this;
        }

        static /* synthetic */ File access$2(DownloadBundleJob downloadBundleJob) {
            return downloadBundleJob.file;
        }

        static /* synthetic */ Directory.Entry access$3(DownloadBundleJob downloadBundleJob) {
            return downloadBundleJob.entry;
        }
    }
}

