/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.server.internal.xmlrpc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.eclipse.equinox.jmx.common.NamedNotification;
import org.eclipse.equinox.jmx.common.util.RingBuffer;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;

public class XMLRPCMBeanServerAdapter
implements MBeanServerForwarder,
NotificationListener {
    private static final int NOTIFICATIONS_BUFFER_SIZE = 100;
    private static final String INTERNAL_CONTEXT_CLASSLOADER = "internal.ContextClassLoader";
    private static final String INTERNAL_MAPPING = "internal.Mapping";
    final Map notificationBroadcasters = new HashMap();
    private final RingBuffer notificationsBuffer = new RingBuffer(100);
    private final HttpServer webServer = new HttpServer();
    static XmlRpcHandlerMappingImpl mapping;
    private MBeanServer mbs;
    private boolean started;
    static /* synthetic */ Class class$0;

    public XMLRPCMBeanServerAdapter(int port, MBeanServer mbs) {
        this.mbs = mbs;
        mapping = new XmlRpcHandlerMappingImpl();
        mapping.addNameHandler("retrieveNotifications");
        SocketListener httpListener = new SocketListener();
        httpListener.setPort(port);
        this.webServer.addListener((HttpListener)httpListener);
        ServletHandler servlets = new ServletHandler();
        servlets.setAutoInitializeServlets(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.jmx.server.internal.xmlrpc.XMLRPCMBeanServerAdapter$InternalHttpServiceServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServletHolder holder = servlets.addServlet("/", clazz.getName());
        holder.setInitOrder(0);
        holder.setInitParameter("enabledForExtensions", "true");
        HttpContext httpContext = new HttpContext();
        httpContext.setAttribute(INTERNAL_CONTEXT_CLASSLOADER, (Object)Thread.currentThread().getContextClassLoader());
        httpContext.setAttribute(INTERNAL_MAPPING, (Object)mapping);
        httpContext.setClassLoader(this.getClass().getClassLoader());
        httpContext.setContextPath("/");
        httpContext.addHandler((HttpHandler)servlets);
        this.webServer.addContext(httpContext);
    }

    public void start() throws IOException {
        if (!this.started) {
            try {
                this.webServer.start();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.webServer.isStarted()) {
            try {
                this.webServer.stop();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isActive() {
        return this.webServer.isStarted();
    }

    public MBeanServer getMBeanServer() {
        return this;
    }

    public void setMBeanServer(MBeanServer mbs) {
        if (this.mbs == null) {
            this.mbs = mbs;
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbs.createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbs.createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbs.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        mapping.addObjectHandler(name, object);
        return this.mbs.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbs.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbs.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.mbs.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        return this.mbs.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbs.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbs.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.mbs.getDomains();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs.getMBeanInfo(name);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs.isInstanceOf(name, className);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName, params, signature);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.mbs.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.mbs.deserialize(className, loaderName, data);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbs.getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbs.getClassLoaderRepository();
    }

    public synchronized NamedNotification[] retrieveNotifications(Long startId) {
        int nextPos = this.notificationsBuffer.getNextPosition();
        if (nextPos == 0) {
            return new NamedNotification[0];
        }
        NamedNotification lastNotification = (NamedNotification)this.notificationsBuffer.getObject(nextPos - 1);
        long pStartId = startId;
        if (lastNotification.getNotificationId() < pStartId) {
            return new NamedNotification[0];
        }
        pStartId %= (long)this.notificationsBuffer.getSize();
        ArrayList<NamedNotification> result = new ArrayList<NamedNotification>(1);
        while (pStartId != (long)nextPos) {
            NamedNotification nn = (NamedNotification)this.notificationsBuffer.getObject((int)pStartId);
            if (pStartId == (long)this.notificationsBuffer.getSize()) {
                pStartId %= (long)this.notificationsBuffer.getSize();
            }
            result.add(nn);
            ++pStartId;
        }
        return result.toArray(new NamedNotification[result.size()]);
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        Object source = notification.getSource();
        ObjectName broadcasterName = null;
        if (source != null && (broadcasterName = (ObjectName)this.notificationBroadcasters.get(source)) != null) {
            this.notificationsBuffer.add((Object)new NamedNotification(broadcasterName, notification));
        }
    }

    public static class InternalHttpServiceServlet
    extends XmlRpcServlet {
        private static final long serialVersionUID = 6297772804215794345L;
        private ClassLoader contextLoader;

        public void init(ServletConfig config) throws ServletException {
            ServletContext context = config.getServletContext();
            this.contextLoader = (ClassLoader)context.getAttribute(XMLRPCMBeanServerAdapter.INTERNAL_CONTEXT_CLASSLOADER);
            mapping = (XmlRpcHandlerMappingImpl)context.getAttribute(XMLRPCMBeanServerAdapter.INTERNAL_MAPPING);
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                super.init(config);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public void destroy() {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                super.destroy();
            }
            finally {
                thread.setContextClassLoader(current);
            }
            this.contextLoader = null;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                super.service(req, res);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() {
            return mapping;
        }
    }

    protected class XmlRpcHandlerMappingImpl
    implements XmlRpcHandlerMapping {
        private final Map handlerMap = new Hashtable();
        private final Handler handler = new Handler();

        protected XmlRpcHandlerMappingImpl() {
        }

        public void addNameHandler(String name) {
            this.handlerMap.put(name, this.handler);
        }

        public void addObjectHandler(ObjectName name, Object obj) {
            this.handlerMap.put(name.toString(), this.handler);
            if (obj instanceof NotificationBroadcaster) {
                ((NotificationBroadcaster)obj).addNotificationListener(XMLRPCMBeanServerAdapter.this, null, null);
                XMLRPCMBeanServerAdapter.this.notificationBroadcasters.put(obj, name);
            }
        }

        public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
            XmlRpcHandler result = (XmlRpcHandler)this.handlerMap.get(this.parseRequest(handlerName)[0]);
            return result;
        }

        private String[] parseRequest(String requestName) {
            int delimIdx = requestName.indexOf(124);
            String[] result = null;
            result = delimIdx != -1 ? new String[]{requestName.substring(0, delimIdx), requestName.substring(delimIdx + 1)} : new String[]{requestName};
            return result;
        }

        private class Handler
        implements XmlRpcHandler {
            private Handler() {
            }

            public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
                String[] request = XmlRpcHandlerMappingImpl.this.parseRequest(pRequest.getMethodName());
                String methodName = null;
                if (request.length == 1) {
                    methodName = request[0];
                } else if (request.length == 2) {
                    methodName = request[1];
                } else {
                    return null;
                }
                int nParams = pRequest.getParameterCount();
                Class[] paramTypes = new Class[nParams];
                Object[] params = new Object[nParams];
                String[] signature = new String[nParams];
                int i = 0;
                while (i < nParams) {
                    Object iParam = pRequest.getParameter(i);
                    paramTypes[i] = iParam.getClass();
                    params[i] = iParam;
                    signature[i] = iParam.getClass().getName();
                    ++i;
                }
                try {
                    if (request.length == 1) {
                        Method method = XMLRPCMBeanServerAdapter.this.getClass().getMethod(methodName, paramTypes);
                        return method.invoke((Object)XMLRPCMBeanServerAdapter.this, params);
                    }
                    return XMLRPCMBeanServerAdapter.this.invoke(ObjectName.getInstance(request[0]), methodName, params, signature);
                }
                catch (Exception e) {
                    throw new XmlRpcException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

