/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.equinox.console.telnet.TelnetServer;
import org.osgi.framework.BundleContext;

public class TelnetCommand {
    private String defaultHost = null;
    private int defaultPort;
    private final CommandProcessor processor;
    private String host = null;
    private int port;
    private TelnetServer telnetServer;

    public TelnetCommand(CommandProcessor procesor, BundleContext context) {
        this.processor = procesor;
        String telnetPort = null;
        String consolePropValue = context.getProperty("osgi.console");
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(":");
            if (index > -1) {
                this.defaultHost = consolePropValue.substring(0, index);
            }
            telnetPort = consolePropValue.substring(index + 1);
        }
        if (telnetPort != null && !"".equals(telnetPort)) {
            try {
                this.defaultPort = Integer.parseInt(telnetPort);
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultPort = 2223;
            }
        } else {
            this.defaultPort = 2223;
        }
    }

    @Descriptor(value="start/stop a telnet server")
    public synchronized void telnet(String[] arguments) throws Exception {
        String command = null;
        int newPort = 0;
        String newHost = null;
        int i = 0;
        while (i < arguments.length) {
            if ("-?".equals(arguments[i]) || "-help".equals(arguments[i])) {
                this.printHelp();
                return;
            }
            if ("start".equals(arguments[i])) {
                command = "start";
            } else if ("stop".equals(arguments[i])) {
                command = "stop";
            } else if ("-port".equals(arguments[i]) && arguments.length > i + 1) {
                newPort = Integer.parseInt(arguments[++i]);
            } else if ("-host".equals(arguments[i]) && arguments.length > i + 1) {
                newHost = arguments[++i];
            } else {
                throw new Exception("Unrecognized telnet command/option " + arguments[i]);
            }
            ++i;
        }
        if (command == null) {
            throw new Exception("No telnet command specified");
        }
        if (newPort != 0) {
            this.port = newPort;
        } else if (this.port == 0) {
            this.port = this.defaultPort;
        }
        this.host = newHost != null ? newHost : this.defaultHost;
        if ("start".equals(command)) {
            if (this.telnetServer != null) {
                throw new IllegalStateException("telnet is already running on port " + this.port);
            }
            this.telnetServer = new TelnetServer(this.processor, this.host, this.port);
            this.telnetServer.setName("equinox telnet");
            this.telnetServer.start();
        } else if ("stop".equals(command)) {
            if (this.telnetServer == null) {
                throw new IllegalStateException("telnet is not running.");
            }
            this.telnetServer.stopTelnetServer();
            this.telnetServer = null;
        }
    }

    private void printHelp() {
        StringBuffer help = new StringBuffer();
        help.append("telnet - start simple telnet server");
        help.append("\n");
        help.append("Usage: telnet start | stop [-port port]");
        help.append("\n");
        help.append("\t");
        help.append("-port");
        help.append("\t");
        help.append("listen port (default=");
        help.append(this.defaultPort);
        help.append(")");
        help.append("\n");
        help.append("\t");
        help.append("-host");
        help.append("\t");
        help.append("local host address to listen on (default is none - listen on all network interfaces)");
        help.append("\n");
        help.append("\t");
        help.append("-?, -help");
        help.append("\t");
        help.append("show help");
        System.out.println(help.toString());
    }
}

