/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String URL = OS.NSURLPboardType.getString();
    static final int URL_ID = URLTransfer.registerType(URL);

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String url = (String)object;
        NSString nsString = NSString.stringWith(url);
        NSString escapedString = nsString.stringByAddingPercentEscapesUsingEncoding(4);
        transferData.data = NSURL.URLWithString(escapedString);
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSURL nsUrl = (NSURL)transferData.data;
        NSString nsString = nsUrl.absoluteString();
        return nsString.getString();
    }

    protected int[] getTypeIds() {
        return new int[]{URL_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

