/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.installer.InstallerActivator;
import org.eclipse.equinox.internal.p2.installer.Messages;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.installer.IInstallOperation;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallUpdateProductOperation
implements IInstallOperation {
    private IArtifactRepositoryManager artifactRepoMan;
    private IProvisioningAgent agent;
    private IDirector director;
    private final InstallDescription installDescription;
    private boolean isInstall = true;
    private IMetadataRepositoryManager metadataRepoMan;
    private IProfileRegistry profileRegistry;
    private IStatus result;
    static /* synthetic */ Class class$0;

    public InstallUpdateProductOperation(IProvisioningAgent agent, InstallDescription description) {
        this.agent = agent;
        this.installDescription = description;
    }

    private Collection<IInstallableUnit> computeUnitsToInstall() throws CoreException {
        ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
        IVersionedId[] roots = this.installDescription.getRoots();
        int i = 0;
        while (i < roots.length) {
            IVersionedId root = roots[i];
            IInstallableUnit iu = this.findUnit(root);
            if (iu != null) {
                units.add(iu);
            }
            ++i;
        }
        return units;
    }

    private IQueryResult<IInstallableUnit> computeUnitsToUninstall(IProfile p) {
        return p.query(QueryUtil.createIUAnyQuery(), null);
    }

    private IProfile createProfile() throws ProvisionException {
        IProfile profile = this.getProfile();
        if (profile == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.eclipse.equinox.p2.installFolder", this.installDescription.getInstallLocation().toString());
            BundleContext bundleContext = InstallerActivator.getDefault().getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            String env = new StringBuffer("osgi.os=").append(info.getOS()).append(",osgi.ws=").append(info.getWS()).append(",osgi.arch=").append(info.getOSArch()).toString();
            properties.put("org.eclipse.equinox.p2.environments", env);
            properties.put("org.eclipse.equinox.p2.name", this.installDescription.getProductName());
            properties.putAll(this.installDescription.getProfileProperties());
            IPath location = this.installDescription.getBundleLocation();
            if (location != null) {
                properties.put("org.eclipse.equinox.p2.cache", location.toOSString());
            }
            profile = this.profileRegistry.addProfile(this.getProfileId(), properties);
        }
        return profile;
    }

    IPlanner getPlanner() {
        return (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
    }

    private void doInstall(SubMonitor monitor) throws CoreException {
        IStatus s;
        this.prepareMetadataRepositories();
        this.prepareArtifactRepositories();
        IProfile p = this.createProfile();
        Collection<IInstallableUnit> toInstall = this.computeUnitsToInstall();
        monitor.worked(5);
        IProfileChangeRequest request = this.getPlanner().createChangeRequest(p);
        if (this.isInstall) {
            monitor.setTaskName(NLS.bind((String)Messages.Op_Installing, (Object)this.installDescription.getProductName()));
            request.addAll(toInstall);
            s = this.director.provision(request, null, (IProgressMonitor)monitor.newChild(90));
        } else {
            monitor.setTaskName(NLS.bind((String)Messages.Op_Updating, (Object)this.installDescription.getProductName()));
            IQueryResult<IInstallableUnit> toUninstall = this.computeUnitsToUninstall(p);
            request.removeAll((Collection)toUninstall.toUnmodifiableSet());
            request.addAll(toInstall);
            s = this.director.provision(request, null, (IProgressMonitor)monitor.newChild(90));
        }
        if (!s.isOK()) {
            throw new CoreException(s);
        }
    }

    private CoreException fail(String message) {
        return this.fail(message, null);
    }

    private CoreException fail(String message, Throwable throwable) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", message, throwable));
    }

    private IInstallableUnit findUnit(IVersionedId spec) throws CoreException {
        String id = spec.getId();
        if (id == null) {
            throw this.fail(Messages.Op_NoId);
        }
        Version version = spec.getVersion();
        VersionRange range = VersionRange.emptyRange;
        if (version != null && !version.equals(Version.emptyVersion)) {
            range = new VersionRange(version, true, version, true);
        }
        IQuery query = QueryUtil.createIUQuery((String)id, (VersionRange)range);
        Iterator matches = this.metadataRepoMan.query(query, null).iterator();
        IInstallableUnit newest = null;
        while (matches.hasNext()) {
            IInstallableUnit candidate = (IInstallableUnit)matches.next();
            if (newest != null && newest.getVersion().compareTo((Object)candidate.getVersion()) >= 0) continue;
            newest = candidate;
        }
        if (newest == null) {
            throw this.fail(new StringBuffer(String.valueOf(Messages.Op_IUNotFound)).append(id).toString());
        }
        return newest;
    }

    private IProfile getProfile() {
        return this.profileRegistry.getProfile(this.getProfileId());
    }

    private String getProfileId() {
        IPath location = this.installDescription.getInstallLocation();
        if (location != null) {
            return location.toString();
        }
        return this.installDescription.getProductName();
    }

    public IStatus getResult() {
        return this.result;
    }

    private Object getService(String name) throws CoreException {
        Object service = this.agent.getService(name);
        if (service == null) {
            throw this.fail(new StringBuffer(String.valueOf(Messages.Op_NoServiceImpl)).append(name).toString());
        }
        return service;
    }

    @Override
    public IStatus install(IProgressMonitor pm) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (String)Messages.Op_Preparing, (int)100);
        try {
            try {
                try {
                    this.preInstall();
                    this.isInstall = this.getProfile() == null;
                    this.doInstall(monitor);
                    this.result = new Status(0, "org.eclipse.equinox.p2.installer", this.isInstall ? Messages.Op_InstallComplete : Messages.Op_UpdateComplete, null);
                    monitor.setTaskName(Messages.Op_Cleanup);
                }
                finally {
                    this.postInstall();
                }
            }
            catch (CoreException e) {
                this.result = e.getStatus();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return this.result;
    }

    public boolean isFirstInstall() {
        return this.isInstall;
    }

    private void postInstall() {
    }

    private void preInstall() throws CoreException {
        this.director = (IDirector)this.getService(IDirector.SERVICE_NAME);
        this.metadataRepoMan = (IMetadataRepositoryManager)this.getService(IMetadataRepositoryManager.SERVICE_NAME);
        this.artifactRepoMan = (IArtifactRepositoryManager)this.getService(IArtifactRepositoryManager.SERVICE_NAME);
        this.profileRegistry = (IProfileRegistry)this.getService(IProfileRegistry.SERVICE_NAME);
    }

    private void prepareArtifactRepositories() throws ProvisionException {
        URI[] repos = this.installDescription.getArtifactRepositories();
        if (repos == null) {
            return;
        }
        int i = 0;
        while (i < repos.length) {
            this.artifactRepoMan.addRepository(repos[i]);
            this.artifactRepoMan.loadRepository(repos[i], null);
            ++i;
        }
    }

    private void prepareMetadataRepositories() throws ProvisionException {
        URI[] repos = this.installDescription.getMetadataRepositories();
        if (repos == null) {
            return;
        }
        int i = 0;
        while (i < repos.length) {
            this.metadataRepoMan.addRepository(repos[i]);
            this.metadataRepoMan.loadRepository(repos[i], null);
            ++i;
        }
    }
}

