/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.LocaleIDParser;
import com.ibm.icu.impl.LocaleIDs;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.locale.AsciiUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ULocale
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans", Locale.CHINESE);
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant", Locale.CHINESE);
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE;
    public static final ULocale ROOT;
    private static final SimpleCache<Locale, ULocale> CACHE;
    private volatile transient Locale locale;
    private String localeID;
    private static String[][] CANONICALIZE_MAP;
    private static String[][] variantsToKeywords;
    private static final String[][] _javaLocaleMap;
    private static ICUCache<String, String> nameCache;
    private static Locale defaultLocale;
    private static ULocale defaultULocale;
    private static volatile ULocale[] availableLocales;
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN", Locale.CHINA);
        TAIWAN = new ULocale("zh_Hant_TW", Locale.TAIWAN);
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale(EMPTY_STRING, EMPTY_STRING);
        ROOT = new ULocale(EMPTY_STRING, EMPTY_LOCALE);
        CACHE = new SimpleCache();
        String[][] stringArrayArray = new String[3][];
        stringArrayArray[0] = new String[]{"ja_JP_JP", "ja_JP", "calendar", "japanese", "ja"};
        String[] stringArray = new String[5];
        stringArray[0] = "no_NO_NY";
        stringArray[1] = "nn_NO";
        stringArray[4] = "nn";
        stringArrayArray[1] = stringArray;
        stringArrayArray[2] = new String[]{"th_TH_TH", "th_TH", "numbers", "thai", "th"};
        _javaLocaleMap = stringArrayArray;
        nameCache = new SimpleCache<String, String>();
        defaultLocale = Locale.getDefault();
        defaultULocale = new ULocale(defaultLocale);
        availableLocales = null;
        ACTUAL_LOCALE = new Type();
        VALID_LOCALE = new Type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void initCANONICALIZE_MAP() {
        Class<ULocale> clazz;
        if (CANONICALIZE_MAP == null) {
            String[][] stringArrayArray = new String[50][];
            String[] stringArray = new String[4];
            stringArray[0] = "C";
            stringArray[1] = "en_US_POSIX";
            stringArrayArray[0] = stringArray;
            String[] stringArray2 = new String[4];
            stringArray2[0] = "art_LOJBAN";
            stringArray2[1] = "jbo";
            stringArrayArray[1] = stringArray2;
            String[] stringArray3 = new String[4];
            stringArray3[0] = "az_AZ_CYRL";
            stringArray3[1] = "az_Cyrl_AZ";
            stringArrayArray[2] = stringArray3;
            String[] stringArray4 = new String[4];
            stringArray4[0] = "az_AZ_LATN";
            stringArray4[1] = "az_Latn_AZ";
            stringArrayArray[3] = stringArray4;
            stringArrayArray[4] = new String[]{"ca_ES_PREEURO", "ca_ES", "currency", "ESP"};
            String[] stringArray5 = new String[4];
            stringArray5[0] = "cel_GAULISH";
            stringArray5[1] = "cel__GAULISH";
            stringArrayArray[5] = stringArray5;
            String[] stringArray6 = new String[4];
            stringArray6[0] = "de_1901";
            stringArray6[1] = "de__1901";
            stringArrayArray[6] = stringArray6;
            String[] stringArray7 = new String[4];
            stringArray7[0] = "de_1906";
            stringArray7[1] = "de__1906";
            stringArrayArray[7] = stringArray7;
            stringArrayArray[8] = new String[]{"de__PHONEBOOK", "de", "collation", "phonebook"};
            stringArrayArray[9] = new String[]{"de_AT_PREEURO", "de_AT", "currency", "ATS"};
            stringArrayArray[10] = new String[]{"de_DE_PREEURO", "de_DE", "currency", "DEM"};
            stringArrayArray[11] = new String[]{"de_LU_PREEURO", "de_LU", "currency", "EUR"};
            stringArrayArray[12] = new String[]{"el_GR_PREEURO", "el_GR", "currency", "GRD"};
            String[] stringArray8 = new String[4];
            stringArray8[0] = "en_BOONT";
            stringArray8[1] = "en__BOONT";
            stringArrayArray[13] = stringArray8;
            String[] stringArray9 = new String[4];
            stringArray9[0] = "en_SCOUSE";
            stringArray9[1] = "en__SCOUSE";
            stringArrayArray[14] = stringArray9;
            stringArrayArray[15] = new String[]{"en_BE_PREEURO", "en_BE", "currency", "BEF"};
            stringArrayArray[16] = new String[]{"en_IE_PREEURO", "en_IE", "currency", "IEP"};
            stringArrayArray[17] = new String[]{"es__TRADITIONAL", "es", "collation", "traditional"};
            stringArrayArray[18] = new String[]{"es_ES_PREEURO", "es_ES", "currency", "ESP"};
            stringArrayArray[19] = new String[]{"eu_ES_PREEURO", "eu_ES", "currency", "ESP"};
            stringArrayArray[20] = new String[]{"fi_FI_PREEURO", "fi_FI", "currency", "FIM"};
            stringArrayArray[21] = new String[]{"fr_BE_PREEURO", "fr_BE", "currency", "BEF"};
            stringArrayArray[22] = new String[]{"fr_FR_PREEURO", "fr_FR", "currency", "FRF"};
            stringArrayArray[23] = new String[]{"fr_LU_PREEURO", "fr_LU", "currency", "LUF"};
            stringArrayArray[24] = new String[]{"ga_IE_PREEURO", "ga_IE", "currency", "IEP"};
            stringArrayArray[25] = new String[]{"gl_ES_PREEURO", "gl_ES", "currency", "ESP"};
            stringArrayArray[26] = new String[]{"hi__DIRECT", "hi", "collation", "direct"};
            stringArrayArray[27] = new String[]{"it_IT_PREEURO", "it_IT", "currency", "ITL"};
            stringArrayArray[28] = new String[]{"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"};
            stringArrayArray[29] = new String[]{"nl_BE_PREEURO", "nl_BE", "currency", "BEF"};
            stringArrayArray[30] = new String[]{"nl_NL_PREEURO", "nl_NL", "currency", "NLG"};
            stringArrayArray[31] = new String[]{"pt_PT_PREEURO", "pt_PT", "currency", "PTE"};
            String[] stringArray10 = new String[4];
            stringArray10[0] = "sl_ROZAJ";
            stringArray10[1] = "sl__ROZAJ";
            stringArrayArray[32] = stringArray10;
            String[] stringArray11 = new String[4];
            stringArray11[0] = "sr_SP_CYRL";
            stringArray11[1] = "sr_Cyrl_RS";
            stringArrayArray[33] = stringArray11;
            String[] stringArray12 = new String[4];
            stringArray12[0] = "sr_SP_LATN";
            stringArray12[1] = "sr_Latn_RS";
            stringArrayArray[34] = stringArray12;
            String[] stringArray13 = new String[4];
            stringArray13[0] = "sr_YU_CYRILLIC";
            stringArray13[1] = "sr_Cyrl_RS";
            stringArrayArray[35] = stringArray13;
            stringArrayArray[36] = new String[]{"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"};
            String[] stringArray14 = new String[4];
            stringArray14[0] = "uz_UZ_CYRILLIC";
            stringArray14[1] = "uz_Cyrl_UZ";
            stringArrayArray[37] = stringArray14;
            String[] stringArray15 = new String[4];
            stringArray15[0] = "uz_UZ_CYRL";
            stringArray15[1] = "uz_Cyrl_UZ";
            stringArrayArray[38] = stringArray15;
            String[] stringArray16 = new String[4];
            stringArray16[0] = "uz_UZ_LATN";
            stringArray16[1] = "uz_Latn_UZ";
            stringArrayArray[39] = stringArray16;
            String[] stringArray17 = new String[4];
            stringArray17[0] = "zh_CHS";
            stringArray17[1] = "zh_Hans";
            stringArrayArray[40] = stringArray17;
            String[] stringArray18 = new String[4];
            stringArray18[0] = "zh_CHT";
            stringArray18[1] = "zh_Hant";
            stringArrayArray[41] = stringArray18;
            String[] stringArray19 = new String[4];
            stringArray19[0] = "zh_GAN";
            stringArray19[1] = "zh__GAN";
            stringArrayArray[42] = stringArray19;
            String[] stringArray20 = new String[4];
            stringArray20[0] = "zh_GUOYU";
            stringArray20[1] = "zh";
            stringArrayArray[43] = stringArray20;
            String[] stringArray21 = new String[4];
            stringArray21[0] = "zh_HAKKA";
            stringArray21[1] = "zh__HAKKA";
            stringArrayArray[44] = stringArray21;
            String[] stringArray22 = new String[4];
            stringArray22[0] = "zh_MIN";
            stringArray22[1] = "zh__MIN";
            stringArrayArray[45] = stringArray22;
            String[] stringArray23 = new String[4];
            stringArray23[0] = "zh_MIN_NAN";
            stringArray23[1] = "zh__MINNAN";
            stringArrayArray[46] = stringArray23;
            String[] stringArray24 = new String[4];
            stringArray24[0] = "zh_WUU";
            stringArray24[1] = "zh__WUU";
            stringArrayArray[47] = stringArray24;
            String[] stringArray25 = new String[4];
            stringArray25[0] = "zh_XIANG";
            stringArray25[1] = "zh__XIANG";
            stringArrayArray[48] = stringArray25;
            String[] stringArray26 = new String[4];
            stringArray26[0] = "zh_YUE";
            stringArray26[1] = "zh__YUE";
            stringArrayArray[49] = stringArray26;
            String[][] tempCANONICALIZE_MAP = stringArrayArray;
            clazz = ULocale.class;
            // MONITORENTER : com.ibm.icu.util.ULocale.class
            if (CANONICALIZE_MAP == null) {
                CANONICALIZE_MAP = tempCANONICALIZE_MAP;
            }
            // MONITOREXIT : clazz
        }
        if (variantsToKeywords != null) return;
        String[][] tempVariantsToKeywords = new String[][]{{"EURO", "currency", "EUR"}, {"PINYIN", "collation", "pinyin"}, {"STROKE", "collation", "stroke"}};
        clazz = ULocale.class;
        // MONITORENTER : com.ibm.icu.util.ULocale.class
        if (variantsToKeywords == null) {
            variantsToKeywords = tempVariantsToKeywords;
        }
        // MONITOREXIT : clazz
        return;
    }

    private ULocale(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    private ULocale(Locale loc) {
        this.localeID = ULocale.getName(ULocale.forLocale(loc).toString());
        this.locale = loc;
    }

    public static ULocale forLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        ULocale result = CACHE.get(loc);
        if (result == null) {
            if (defaultULocale != null && loc == ULocale.defaultULocale.locale) {
                result = defaultULocale;
            } else {
                String locStr = loc.toString();
                if (locStr.length() == 0) {
                    result = ROOT;
                } else {
                    int i = 0;
                    while (i < _javaLocaleMap.length) {
                        if (_javaLocaleMap[i][0].equals(locStr)) {
                            LocaleIDParser p = new LocaleIDParser(_javaLocaleMap[i][1]);
                            p.setKeywordValue(_javaLocaleMap[i][2], _javaLocaleMap[i][3]);
                            locStr = p.getName();
                            break;
                        }
                        ++i;
                    }
                    result = new ULocale(locStr, loc);
                }
            }
            CACHE.put(loc, result);
        }
        return result;
    }

    public ULocale(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    public ULocale(String a, String b) {
        this(a, b, null);
    }

    public ULocale(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, EMPTY_STRING));
    }

    public static ULocale createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), null);
    }

    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuilder buf = new StringBuilder();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            LocaleIDParser p = new LocaleIDParser(this.localeID);
            String base = p.getBaseName();
            int i = 0;
            while (i < _javaLocaleMap.length) {
                if (base.equals(_javaLocaleMap[i][1]) || base.equals(_javaLocaleMap[i][4])) {
                    if (_javaLocaleMap[i][2] != null) {
                        String val = p.getKeywordValue(_javaLocaleMap[i][2]);
                        if (val != null && val.equals(_javaLocaleMap[i][3])) {
                            p = new LocaleIDParser(_javaLocaleMap[i][0]);
                            break;
                        }
                    } else {
                        p = new LocaleIDParser(_javaLocaleMap[i][0]);
                        break;
                    }
                }
                ++i;
            }
            String[] names = p.getLanguageScriptCountryVariant();
            this.locale = new Locale(names[0], names[2], names[3]);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            Locale currentDefault = Locale.getDefault();
            if (!defaultLocale.equals(currentDefault)) {
                defaultLocale = currentDefault;
                defaultULocale = new ULocale(defaultLocale);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale newLocale) {
        Locale.setDefault(newLocale.toLocale());
        defaultULocale = newLocale;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            return this.localeID.equals((String)obj);
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ULocale[] getAvailableLocales() {
        if (availableLocales != null) return (ULocale[])availableLocales.clone();
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            if (availableLocales != null) return (ULocale[])availableLocales.clone();
            Locale[] locales = Locale.getAvailableLocales();
            availableLocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                ULocale.availableLocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (ULocale[])availableLocales.clone();
        }
    }

    public static String[] getISOCountries() {
        return LocaleIDs.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return LocaleIDs.getISOLanguages();
    }

    public String getLanguage() {
        return ULocale.getLanguage(this.localeID);
    }

    public static String getLanguage(String localeID) {
        return new LocaleIDParser(localeID).getLanguage();
    }

    public String getScript() {
        return ULocale.getScript(this.localeID);
    }

    public static String getScript(String localeID) {
        return new LocaleIDParser(localeID).getScript();
    }

    public String getCountry() {
        return ULocale.getCountry(this.localeID);
    }

    public static String getCountry(String localeID) {
        return new LocaleIDParser(localeID).getCountry();
    }

    public String getVariant() {
        return ULocale.getVariant(this.localeID);
    }

    public static String getVariant(String localeID) {
        return new LocaleIDParser(localeID).getVariant();
    }

    public static String getFallback(String localeID) {
        return ULocale.getFallbackString(ULocale.getName(localeID));
    }

    public ULocale getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), null);
    }

    /*
     * Unable to fully structure code
     */
    private static String getFallbackString(String fallback) {
        block2: {
            extStart = fallback.indexOf(64);
            if (extStart == -1) {
                extStart = fallback.length();
            }
            if ((last = fallback.lastIndexOf(95, extStart)) != -1) ** GOTO lbl9
            last = 0;
            break block2;
            while (fallback.charAt(last - 1) == '_') {
                --last;
lbl9:
                // 2 sources

                if (last > 0) continue;
            }
        }
        return String.valueOf(fallback.substring(0, last)) + fallback.substring(extStart);
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        if (localeID.indexOf(64) == -1) {
            return localeID;
        }
        return new LocaleIDParser(localeID).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    public static String getName(String localeID) {
        String name = nameCache.get(localeID);
        if (name == null) {
            name = new LocaleIDParser(localeID).getName();
            nameCache.put(localeID, name);
        }
        return name;
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator<String> getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator<String> getKeywords(String localeID) {
        return new LocaleIDParser(localeID).getKeywords();
    }

    public String getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    public static String getKeywordValue(String localeID, String keywordName) {
        return new LocaleIDParser(localeID).getKeywordValue(keywordName);
    }

    public static String canonicalize(String localeID) {
        String[] vals;
        LocaleIDParser parser = new LocaleIDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        ULocale.initCANONICALIZE_MAP();
        int i = 0;
        while (i < variantsToKeywords.length) {
            vals = variantsToKeywords[i];
            int idx = baseName.lastIndexOf("_" + vals[0]);
            if (idx > -1) {
                foundVariant = true;
                if ((baseName = baseName.substring(0, idx)).endsWith("_")) {
                    baseName = baseName.substring(0, --idx);
                }
                parser.setBaseName(baseName);
                parser.defaultKeywordValue(vals[1], vals[2]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < CANONICALIZE_MAP.length) {
            if (CANONICALIZE_MAP[i][0].equals(baseName)) {
                foundVariant = true;
                vals = CANONICALIZE_MAP[i];
                parser.setBaseName(vals[1]);
                if (vals[2] == null) break;
                parser.defaultKeywordValue(vals[2], vals[3]);
                break;
            }
            ++i;
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    public ULocale setKeywordValue(String keyword, String value) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, keyword, value), null);
    }

    public static String setKeywordValue(String localeID, String keyword, String value) {
        LocaleIDParser parser = new LocaleIDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String localeID) {
        return LocaleIDs.getISO3Language(ULocale.getLanguage(localeID));
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String localeID) {
        return LocaleIDs.getISO3Country(ULocale.getCountry(localeID));
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(), false);
    }

    public String getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this, displayLocale, false);
    }

    public static String getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), new ULocale(displayLocaleID), false);
    }

    public static String getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), displayLocale, false);
    }

    public String getDisplayLanguageWithDialect() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(), true);
    }

    public String getDisplayLanguageWithDialect(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this, displayLocale, true);
    }

    public static String getDisplayLanguageWithDialect(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), new ULocale(displayLocaleID), true);
    }

    public static String getDisplayLanguageWithDialect(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), displayLocale, true);
    }

    private static String getDisplayLanguageInternal(ULocale locale, ULocale displayLocale, boolean useDialect) {
        return locale.toLocale().getDisplayLanguage(displayLocale.toLocale());
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this, ULocale.getDefault());
    }

    public String getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this, displayLocale);
    }

    public static String getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    public static String getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(new ULocale(localeID), displayLocale);
    }

    private static String getDisplayScriptInternal(ULocale locale, ULocale displayLocale) {
        return locale.getScript();
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this, ULocale.getDefault());
    }

    public String getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this, displayLocale);
    }

    public static String getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    public static String getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(new ULocale(localeID), displayLocale);
    }

    private static String getDisplayCountryInternal(ULocale locale, ULocale displayLocale) {
        return locale.toLocale().getDisplayCountry(displayLocale.toLocale());
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this, ULocale.getDefault());
    }

    public String getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this, displayLocale);
    }

    public static String getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    public static String getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(new ULocale(localeID), displayLocale);
    }

    private static String getDisplayVariantInternal(ULocale locale, ULocale displayLocale) {
        return locale.toLocale().getDisplayVariant(displayLocale.toLocale());
    }

    public static String getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault());
    }

    public static String getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, new ULocale(displayLocaleID));
    }

    public static String getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale);
    }

    private static String getDisplayKeywordInternal(String keyword, ULocale displayLocale) {
        return keyword;
    }

    public String getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this, keyword, ULocale.getDefault());
    }

    public String getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this, keyword, displayLocale);
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(localeID), keyword, new ULocale(displayLocaleID));
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(localeID), keyword, displayLocale);
    }

    private static String getDisplayKeywordValueInternal(ULocale locale, String keyword, ULocale displayLocale) {
        keyword = AsciiUtil.toLowerString(keyword.trim());
        String value = locale.getKeywordValue(keyword);
        return value;
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this, ULocale.getDefault());
    }

    public String getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this, displayLocale);
    }

    public static String getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    public static String getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(new ULocale(localeID), displayLocale);
    }

    private static String getDisplayNameInternal(ULocale locale, ULocale displayLocale) {
        return locale.toLocale().getDisplayName(displayLocale.toLocale());
    }

    public String getDisplayNameWithDialect() {
        return ULocale.getDisplayNameWithDialectInternal(this, ULocale.getDefault());
    }

    public String getDisplayNameWithDialect(ULocale displayLocale) {
        return ULocale.getDisplayNameWithDialectInternal(this, displayLocale);
    }

    public static String getDisplayNameWithDialect(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    public static String getDisplayNameWithDialect(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(localeID), displayLocale);
    }

    private static String getDisplayNameWithDialectInternal(ULocale locale, ULocale displayLocale) {
        return locale.toLocale().getDisplayName(displayLocale.toLocale());
    }

    public String getCharacterOrientation() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public String getLineOrientation() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static ULocale acceptLanguage(String acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (acceptLanguageList == null) {
            throw new NullPointerException();
        }
        ULocale[] acceptList = null;
        try {
            acceptList = ULocale.parseAcceptLanguage(acceptLanguageList, true);
        }
        catch (ParseException parseException) {
            acceptList = null;
        }
        if (acceptList == null) {
            return null;
        }
        return ULocale.acceptLanguage(acceptList, availableLocales, fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (fallback != null) {
            fallback[0] = true;
        }
        int i = 0;
        while (i < acceptLanguageList.length) {
            ULocale aLocale = acceptLanguageList[i];
            boolean[] setFallback = fallback;
            do {
                int j = 0;
                while (j < availableLocales.length) {
                    if (availableLocales[j].equals(aLocale)) {
                        if (setFallback != null) {
                            setFallback[0] = false;
                        }
                        return availableLocales[j];
                    }
                    ++j;
                }
                Locale loc = aLocale.toLocale();
                Locale parent = LocaleUtility.fallback(loc);
                aLocale = parent != null ? new ULocale(parent) : null;
                setFallback = null;
            } while (aLocale != null);
            ++i;
        }
        return null;
    }

    public static ULocale acceptLanguage(String acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    static ULocale[] parseAcceptLanguage(String acceptLanguage, boolean isLenient) throws ParseException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ULocaleAcceptLanguageQ
        implements Comparable<ULocaleAcceptLanguageQ> {
            private double q;
            private double serial;

            public ULocaleAcceptLanguageQ(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            @Override
            public int compareTo(ULocaleAcceptLanguageQ other) {
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        StringBuilder languageRangeBuf = new StringBuilder();
        StringBuilder qvalBuf = new StringBuilder();
        int state = 0;
        acceptLanguage = String.valueOf(acceptLanguage) + ",";
        boolean subTag = false;
        boolean q1 = false;
        int n = 0;
        while (n < acceptLanguage.length()) {
            boolean gotLanguageQ = false;
            char c = acceptLanguage.charAt(n);
            switch (state) {
                case 0: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        state = 1;
                        subTag = false;
                        break;
                    }
                    if (c == '*') {
                        languageRangeBuf.append(c);
                        state = 2;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 1: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '-') {
                        subTag = true;
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '_') {
                        if (isLenient) {
                            subTag = true;
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        if (subTag) {
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 4: {
                    if (c == 'q') {
                        state = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 5: {
                    if (c == '=') {
                        state = 6;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 6: {
                    if (c == '0') {
                        q1 = false;
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '1') {
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '.') {
                        if (isLenient) {
                            qvalBuf.append(c);
                            state = 8;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 7: {
                    if (c == '.') {
                        qvalBuf.append(c);
                        state = 8;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    if ('0' <= c || c <= '9') {
                        if (q1 && c != '0' && !isLenient) {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        state = 9;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 9: {
                    if ('0' <= c && c <= '9') {
                        if (q1 && c != '0') {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 10: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                }
            }
            if (state == -1) {
                throw new ParseException("Invalid Accept-Language", n);
            }
            if (gotLanguageQ) {
                double q = 1.0;
                if (qvalBuf.length() != 0) {
                    try {
                        q = Double.parseDouble(qvalBuf.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        q = 1.0;
                    }
                    if (q > 1.0) {
                        q = 1.0;
                    }
                }
                if (languageRangeBuf.charAt(0) != '*') {
                    int serial = map.size();
                    ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
                    map.put(entry, new ULocale(ULocale.canonicalize(languageRangeBuf.toString())));
                }
                languageRangeBuf.setLength(0);
                qvalBuf.setLength(0);
                state = 0;
            }
            ++n;
        }
        if (state != 0) {
            throw new ParseException("Invalid AcceptlLanguage", n);
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return acceptList;
    }

    public static ULocale addLikelySubtags(ULocale loc) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static ULocale minimizeSubtags(ULocale loc) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public String getExtension(char key) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public Set<Character> getExtensionKeys() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public String getUnicodeLocaleType(String key) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public Set<String> getUnicodeLocaleKeys() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public String toLanguageTag() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static ULocale forLanguageTag(String languageTag) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static final class Builder {
        public Builder() {
            throw new UnsupportedOperationException("Constructor not supported by com.ibm.icu.base");
        }

        public Builder(boolean isLenientVariant) {
            throw new UnsupportedOperationException("Constructor not supported by com.ibm.icu.base");
        }

        public boolean isLenientVariant() {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setLocale(ULocale locale) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setLanguageTag(String languageTag) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setLanguage(String language) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setScript(String script) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setRegion(String region) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setVariant(String variant) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setExtension(char key, String value) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder setUnicodeLocaleKeyword(String key, String type) {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder clear() {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public Builder clearExtensions() {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }

        public ULocale build() {
            throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
        }
    }

    public static final class Type {
        private Type() {
        }
    }
}

