/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.supportability;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.Scanner;
import org.eclipse.equinox.console.common.SimpleByteBuffer;
import org.eclipse.equinox.console.supportability.HistoryHolder;

public class ConsoleInputScanner
extends Scanner {
    private boolean isCR = false;
    private boolean replace = false;
    private final HistoryHolder history = new HistoryHolder();
    private final SimpleByteBuffer buffer = new SimpleByteBuffer();
    private static final byte[] INVERSE_ON = new byte[]{27, 91, 55, 109};
    private static final byte[] INVERSE_OFF = new byte[]{27, 91, 50, 55, 109};

    public ConsoleInputScanner(ConsoleInputStream toShell, OutputStream toTelnet) {
        super(toShell, toTelnet);
    }

    public void scan(int b) throws IOException {
        b &= 0xFF;
        if (this.isCR) {
            this.isCR = false;
            if (b == 10) {
                return;
            }
        }
        if (this.isEsc) {
            this.scanEsc(b);
        } else if (b == this.BACKSPACE) {
            this.backSpace();
        } else if (b == 13) {
            this.isCR = true;
            this.processData();
        } else if (b == 10) {
            this.processData();
        } else if (b == 27) {
            this.startEsc();
        } else if (b == this.DEL) {
            this.delete();
        } else if (b >= 32 && b < 127) {
            this.newChar(b);
        }
    }

    private void delete() throws IOException {
        this.clearLine();
        this.buffer.delete();
        this.echoBuff();
        this.flush();
    }

    private void backSpace() throws IOException {
        this.clearLine();
        this.buffer.backSpace();
        this.echoBuff();
        this.flush();
    }

    protected void clearLine() throws IOException {
        int size = this.buffer.getSize();
        int pos = this.buffer.getPos();
        int i = size - pos;
        while (i < size) {
            this.echo(8);
            ++i;
        }
        i = 0;
        while (i < size) {
            this.echo(32);
            ++i;
        }
        i = 0;
        while (i < size) {
            this.echo(8);
            ++i;
        }
    }

    protected void echoBuff() throws IOException {
        byte[] data;
        byte[] byArray = data = this.buffer.copyCurrentData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.echo(b);
            ++n2;
        }
        int pos = this.buffer.getPos();
        int i = data.length;
        while (i > pos) {
            this.echo(8);
            --i;
        }
    }

    protected void newChar(int b) throws IOException {
        if (this.buffer.getPos() < this.buffer.getSize()) {
            if (this.replace) {
                this.buffer.replace(b);
            } else {
                this.buffer.insert(b);
            }
            this.clearLine();
            this.echoBuff();
            this.flush();
        } else if (this.replace) {
            this.buffer.replace(b);
        } else {
            this.buffer.insert(b);
        }
    }

    private void processData() throws IOException {
        this.buffer.add(13);
        this.buffer.add(10);
        this.echo(13);
        this.echo(10);
        this.flush();
        byte[] curr = this.buffer.getCurrentData();
        this.history.add(curr);
        this.toShell.add(curr);
    }

    public void resetHistory() {
        this.history.reset();
    }

    protected void scanEsc(int b) throws IOException {
        this.esc = String.valueOf(this.esc) + (char)b;
        KEYS key = this.checkEscape(this.esc);
        if (key == KEYS.UNFINISHED) {
            return;
        }
        if (key == KEYS.UNKNOWN) {
            this.isEsc = false;
            this.scan(b);
            return;
        }
        this.isEsc = false;
        switch (key) {
            case UP: {
                this.processUpArrow();
                break;
            }
            case DOWN: {
                this.processDownArrow();
                break;
            }
            case RIGHT: {
                this.processRightArrow();
                break;
            }
            case LEFT: {
                this.processLeftArrow();
                break;
            }
            case HOME: {
                this.processHome();
                break;
            }
            case END: {
                this.processEnd();
                break;
            }
            case PGUP: {
                this.processPgUp();
                break;
            }
            case PGDN: {
                this.processPgDn();
                break;
            }
            case INS: {
                this.processIns();
                break;
            }
            case DEL: {
                this.delete();
                break;
            }
        }
    }

    private void echo(byte[] data) throws IOException {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.echo(b);
            ++n2;
        }
    }

    private void processIns() throws IOException {
        this.replace = !this.replace;
        int b = this.buffer.getCurrentChar();
        this.echo(INVERSE_ON);
        this.echo(this.replace ? 82 : 73);
        this.flush();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {}
        this.echo(INVERSE_OFF);
        this.echo(8);
        this.echo(b == -1 ? 32 : b);
        this.echo(8);
        this.flush();
    }

    private void processPgDn() throws IOException {
        byte[] last = this.history.last();
        if (last != null) {
            this.clearLine();
            this.buffer.set(last);
            this.echoBuff();
            this.flush();
        }
    }

    private void processPgUp() throws IOException {
        byte[] first = this.history.first();
        if (first != null) {
            this.clearLine();
            this.buffer.set(first);
            this.echoBuff();
            this.flush();
        }
    }

    private void processHome() throws IOException {
        int pos = this.buffer.resetPos();
        if (pos > 0) {
            int i = 0;
            while (i < pos) {
                this.echo(8);
                ++i;
            }
            this.flush();
        }
    }

    private void processEnd() throws IOException {
        int b;
        while ((b = this.buffer.goRight()) != -1) {
            this.echo(b);
        }
        this.flush();
    }

    private void processLeftArrow() throws IOException {
        if (this.buffer.goLeft()) {
            this.echo(8);
            this.flush();
        }
    }

    private void processRightArrow() throws IOException {
        int b = this.buffer.goRight();
        if (b != -1) {
            this.echo(b);
            this.flush();
        }
    }

    private void processDownArrow() throws IOException {
        byte[] next = this.history.next();
        if (next != null) {
            this.clearLine();
            this.buffer.set(next);
            this.echoBuff();
            this.flush();
        }
    }

    private void processUpArrow() throws IOException {
        this.clearLine();
        byte[] prev = this.history.prev();
        this.buffer.set(prev);
        this.echoBuff();
        this.flush();
    }
}

