/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.transforms.TransformedBundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;

public class TransformedBundleEntry
extends BundleEntry {
    long timestamp;
    private InputStream stream;
    private BundleEntry original;
    private TransformedBundleFile bundleFile;

    public TransformedBundleEntry(TransformedBundleFile bundleFile, BundleEntry original, InputStream wrappedStream) {
        this.stream = wrappedStream;
        this.bundleFile = bundleFile;
        this.original = original;
        this.timestamp = System.currentTimeMillis();
    }

    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public URL getLocalURL() {
        return this.getFileURL();
    }

    public String getName() {
        return this.original.getName();
    }

    public long getSize() {
        ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int i = 0;
        try {
            while ((i = this.stream.read(buffer)) > -1) {
                tempBuffer.write(buffer, 0, i);
            }
            if (this.stream.markSupported()) {
                try {
                    this.stream.reset();
                }
                catch (IOException e) {
                    this.stream = new ByteArrayInputStream(tempBuffer.toByteArray());
                }
            } else {
                this.stream = new ByteArrayInputStream(tempBuffer.toByteArray());
            }
        }
        catch (IOException e) {
            this.bundleFile.getGeneration().getBundleInfo().getStorage().getLogServices().log("org.eclipse.osgi", 4, "Problem calculating size of stream for file.  Stream may now be corrupted : " + this.getName(), (Throwable)e);
        }
        return tempBuffer.size();
    }

    public long getTime() {
        return this.timestamp;
    }
}

