/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.DefaultSiteParser;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class UpdateSite {
    private static final String VERSION_SEPARATOR = "_";
    private static final String JAR_EXTENSION = ".jar";
    private static final String FEATURE_DIR = "features/";
    private static final String PLUGIN_DIR = "plugins/";
    private static final String FEATURE_TEMP_FILE = "feature";
    private static final String SITE_FILE = "site.xml";
    private static final String PROTOCOL_FILE = "file";
    private static final int RETRY_COUNT = 2;
    private static final String DOT_XML = ".xml";
    private static final String SITE = "site";
    private String checksum;
    private URI location;
    private URI rootLocation;
    private SiteModel site;
    private static Map<String, SoftReference<UpdateSite>> siteCache = new HashMap<String, SoftReference<UpdateSite>>();
    private static Map<String, SoftReference<UpdateSite>> categoryCache = new HashMap<String, SoftReference<UpdateSite>>();
    private Map<String, Feature> featureCache = new HashMap<String, Feature>();
    private Map<String, BundleDescription> bundleCache = new HashMap<String, BundleDescription>();
    private Transport transport;

    private static URI getSiteURI(URI baseLocation) {
        String segment = URIUtil.lastSegment((URI)baseLocation);
        if (UpdateSite.constainsUpdateSiteFileName(segment)) {
            return baseLocation;
        }
        return URIUtil.append((URI)baseLocation, (String)SITE_FILE);
    }

    private static boolean constainsUpdateSiteFileName(String segment) {
        return segment != null && segment.endsWith(DOT_XML) && segment.contains(SITE);
    }

    public static synchronized UpdateSite loadCategoryFile(URI location, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        if (location == null) {
            return null;
        }
        UpdateSite result = null;
        if (!PROTOCOL_FILE.equals(location.getScheme()) && categoryCache.containsKey(location.toString())) {
            result = categoryCache.get(location.toString()).get();
            if (result != null) {
                return result;
            }
            categoryCache.remove(location.toString());
        }
        InputStream input = null;
        File siteFile = UpdateSite.loadActualSiteFile(location, location, transport, monitor);
        try {
            CategoryParser siteParser = new CategoryParser(location);
            CRC32 checksum = new CRC32();
            input = new CheckedInputStream(new BufferedInputStream(new FileInputStream(siteFile)), checksum);
            SiteModel siteModel = siteParser.parse(input);
            String checksumString = Long.toString(checksum.getValue());
            result = new UpdateSite(siteModel, location, transport, checksumString);
            if (!PROTOCOL_FILE.equals(location.getScheme())) {
                categoryCache.put(location.toString(), new SoftReference<UpdateSite>(result));
            }
            UpdateSite updateSite = result;
            return updateSite;
        }
        catch (SAXException e) {
            String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (!PROTOCOL_FILE.equals(location.getScheme())) {
                siteFile.delete();
            }
        }
    }

    public static synchronized UpdateSite load(URI location, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        if (location == null) {
            return null;
        }
        UpdateSite result = null;
        if (!PROTOCOL_FILE.equals(location.getScheme()) && siteCache.containsKey(location.toString())) {
            result = siteCache.get(location.toString()).get();
            if (result != null) {
                return result;
            }
            siteCache.remove(location.toString());
        }
        InputStream input = null;
        File siteFile = UpdateSite.loadActualSiteFile(location, UpdateSite.getSiteURI(location), transport, monitor);
        try {
            DefaultSiteParser siteParser = new DefaultSiteParser(location);
            CRC32 checksum = new CRC32();
            input = new CheckedInputStream(new BufferedInputStream(new FileInputStream(siteFile)), checksum);
            SiteModel siteModel = siteParser.parse(input);
            String checksumString = Long.toString(checksum.getValue());
            result = new UpdateSite(siteModel, UpdateSite.getSiteURI(location), transport, checksumString);
            if (!PROTOCOL_FILE.equals(location.getScheme())) {
                siteCache.put(location.toString(), new SoftReference<UpdateSite>(result));
            }
            UpdateSite updateSite = result;
            return updateSite;
        }
        catch (SAXException e) {
            String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (!PROTOCOL_FILE.equals(location.getScheme())) {
                siteFile.delete();
            }
        }
    }

    private static File loadActualSiteFile(URI location, URI actualLocation, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            File siteFile = null;
            IStatus transferResult = null;
            boolean deleteSiteFile = false;
            try {
                if (PROTOCOL_FILE.equals(actualLocation.getScheme())) {
                    siteFile = URIUtil.toFile((URI)actualLocation);
                    if (siteFile.exists()) {
                        transferResult = Status.OK_STATUS;
                    } else {
                        String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                        transferResult = new Status(4, Activator.ID, 1200, msg, (Throwable)new FileNotFoundException(siteFile.getAbsolutePath()));
                    }
                } else {
                    deleteSiteFile = true;
                    BufferedOutputStream destination = null;
                    try {
                        siteFile = File.createTempFile(SITE, DOT_XML);
                        destination = new BufferedOutputStream(new FileOutputStream(siteFile));
                    }
                    catch (IOException e) {
                        throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, "Can not create tempfile for site.xml", (Throwable)e));
                    }
                    try {
                        transferResult = transport.download(actualLocation, (OutputStream)destination, (IProgressMonitor)submonitor.newChild(999));
                    }
                    finally {
                        try {
                            ((OutputStream)destination).close();
                        }
                        catch (IOException e) {
                            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, "Failing to close tempfile for site.xml", (Throwable)e));
                        }
                    }
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (transferResult.isOK()) {
                    deleteSiteFile = false;
                    File file = siteFile;
                    return file;
                }
                Object ms = null;
                ms = transferResult.getException() instanceof FileNotFoundException ? new MultiStatus(Activator.ID, 1000, new IStatus[]{transferResult}, NLS.bind((String)Messages.ErrorReadingSite, (Object)location), null) : transferResult;
                throw new ProvisionException(ms);
            }
            finally {
                if (deleteSiteFile && siteFile != null) {
                    siteFile.delete();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Feature parseFeature(FeatureParser featureParser, URI featureURI, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlock(TryRewriter.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlocks(TryRewriter.java:147)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extendTryBlocks(Op03Rewriters.java:48)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:557)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private UpdateSite(SiteModel site, URI location, Transport transport, String checksum) {
        this.site = site;
        this.location = location;
        this.checksum = checksum;
        this.rootLocation = this.getRootLocation();
        this.transport = transport;
    }

    private URI getRootLocation() {
        String locationString = this.location.toString();
        int slashIndex = locationString.lastIndexOf(47);
        if (slashIndex == -1 || slashIndex == locationString.length() - 1) {
            return this.location;
        }
        return URI.create(locationString.substring(0, slashIndex + 1));
    }

    private URI getArchiveURI(URI base, String identifier) {
        URLEntry[] archives = this.site.getArchives();
        int i = 0;
        while (archives != null && i < archives.length) {
            URLEntry entry = archives[i];
            if (identifier.equals(entry.getAnnotation())) {
                return this.internalGetURI(base, entry.getURL());
            }
            ++i;
        }
        return null;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public URI getSiteFeatureURI(SiteFeature siteFeature) {
        URL url = siteFeature.getURL();
        try {
            if (url != null) {
                return URIUtil.toURI((URL)url);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        URI base = this.getBaseURI();
        String featureURIString = siteFeature.getURLString();
        return this.internalGetURI(base, featureURIString);
    }

    public URI getSiteBundleURI(SiteBundle siteBundle) {
        URL url = siteBundle.getURL();
        try {
            if (url != null) {
                return URIUtil.toURI((URL)url);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        URI base = this.getBaseURI();
        String bundleURIString = siteBundle.getURLString();
        return this.internalGetURI(base, bundleURIString);
    }

    public URI getFeatureURI(String id, String version) {
        SiteFeature[] entries;
        SiteFeature[] siteFeatureArray = entries = this.site.getFeatures();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SiteFeature entry = siteFeatureArray[n2];
            if (id.equals(entry.getFeatureIdentifier()) && version.equals(entry.getFeatureVersion())) {
                return this.getSiteFeatureURI(entry);
            }
            ++n2;
        }
        URI base = this.getBaseURI();
        URI url = this.getArchiveURI(base, FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION);
        if (url != null) {
            return url;
        }
        return URIUtil.append((URI)base, (String)(FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION));
    }

    public URI getBundleURI(String id, String version) {
        SiteBundle[] entries;
        SiteBundle[] siteBundleArray = entries = this.site.getBundles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SiteBundle entry = siteBundleArray[n2];
            if (id.equals(entry.getBundleIdentifier()) && version.equals(entry.getBundleVersion())) {
                return this.getSiteBundleURI(entry);
            }
            ++n2;
        }
        URI base = this.getBaseURI();
        URI url = this.getArchiveURI(base, FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION);
        if (url != null) {
            return url;
        }
        return URIUtil.append((URI)base, (String)(FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION));
    }

    public URI getLocation() {
        return this.location;
    }

    public String getMirrorsURI() {
        Object mirrors = this.site.getMirrorsURI();
        if (mirrors == null) {
            return null;
        }
        int index = ((String)mirrors).indexOf(SITE_FILE);
        if (index != -1) {
            mirrors = ((String)mirrors).substring(0, index) + ((String)mirrors).substring(index + SITE_FILE.length());
        }
        return mirrors;
    }

    public URI getPluginURI(FeatureEntry plugin) {
        String path;
        URI base = this.getBaseURI();
        URI url = this.getArchiveURI(base, path = PLUGIN_DIR + plugin.getId() + VERSION_SEPARATOR + plugin.getVersion() + JAR_EXTENSION);
        if (url != null) {
            return url;
        }
        return URIUtil.append((URI)base, (String)path);
    }

    private URI getBaseURI() {
        URI base = null;
        Object siteURIString = this.site.getLocationURIString();
        if (siteURIString != null) {
            if (!((String)siteURIString).endsWith("/")) {
                siteURIString = (String)siteURIString + "/";
            }
            base = this.internalGetURI(this.rootLocation, (String)siteURIString);
        }
        if (base == null) {
            base = this.rootLocation;
        }
        return base;
    }

    public SiteModel getSite() {
        return this.site;
    }

    private URI internalGetURI(URI base, String trailing) {
        if (trailing == null) {
            return null;
        }
        return URIUtil.makeAbsolute((URI)URI.create(trailing), (URI)base);
    }

    public synchronized Feature[] loadFeatures(IProgressMonitor monitor) throws ProvisionException {
        if (!this.featureCache.isEmpty()) {
            return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
        }
        Feature[] result = this.loadFeaturesFromDigest(monitor);
        return result == null ? this.loadFeaturesFromSite(monitor) : result;
    }

    public synchronized BundleDescription[] loadBundles(IProgressMonitor monitor) {
        if (!this.bundleCache.isEmpty()) {
            return this.bundleCache.values().toArray(new BundleDescription[this.bundleCache.size()]);
        }
        BundleDescription[] result = null;
        return result == null ? this.loadBundlesFromSite(monitor) : result;
    }

    /*
     * Exception decompiling
     */
    private Feature[] loadFeaturesFromDigest(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlock(TryRewriter.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlocks(TryRewriter.java:147)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extendTryBlocks(Op03Rewriters.java:48)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:557)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI getDigestURI() {
        URI digestBase = null;
        Object digestURIString = this.site.getDigestURIString();
        if (digestURIString != null) {
            if (!((String)digestURIString).endsWith("/")) {
                digestURIString = (String)digestURIString + "/";
            }
            digestBase = this.internalGetURI(this.rootLocation, (String)digestURIString);
        }
        if (digestBase == null) {
            digestBase = this.rootLocation;
        }
        return URIUtil.append((URI)digestBase, (String)"digest.zip");
    }

    private Feature[] loadFeaturesFromSite(IProgressMonitor monitor) throws ProvisionException {
        SiteFeature[] siteFeatures = this.site.getFeatures();
        FeatureParser featureParser = new FeatureParser();
        HashMap<String, Feature> tmpFeatureCache = new HashMap<String, Feature>(siteFeatures.length);
        SiteFeature[] siteFeatureArray = siteFeatures;
        int n = siteFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            SiteFeature siteFeature1 = siteFeatureArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SiteFeature siteFeature = siteFeature1;
            String key = null;
            if (siteFeature.getFeatureIdentifier() == null || siteFeature.getFeatureVersion() == null || !tmpFeatureCache.containsKey(key = siteFeature.getFeatureIdentifier() + VERSION_SEPARATOR + siteFeature.getFeatureVersion())) {
                URI featureURI = this.getSiteFeatureURI(siteFeature);
                Feature feature = this.parseFeature(featureParser, featureURI, (IProgressMonitor)new NullProgressMonitor());
                if (feature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)featureURI)));
                } else {
                    if (key == null) {
                        siteFeature.setFeatureIdentifier(feature.getId());
                        siteFeature.setFeatureVersion(feature.getVersion());
                        key = siteFeature.getFeatureIdentifier() + VERSION_SEPARATOR + siteFeature.getFeatureVersion();
                    }
                    tmpFeatureCache.put(key, feature);
                    this.loadIncludedFeatures(feature, featureParser, tmpFeatureCache, monitor);
                }
            }
            ++n2;
        }
        this.featureCache = tmpFeatureCache;
        return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
    }

    private void loadIncludedFeatures(Feature feature, FeatureParser featureParser, Map<String, Feature> features, IProgressMonitor monitor) throws ProvisionException {
        FeatureEntry[] featureEntries;
        FeatureEntry[] featureEntryArray = featureEntries = feature.getEntries();
        int n = featureEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            FeatureEntry featureEntry = featureEntryArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            FeatureEntry entry = featureEntry;
            if (!(entry.isRequires() || entry.isPlugin() || features.containsKey(key = entry.getId() + VERSION_SEPARATOR + entry.getVersion()))) {
                URI includedFeatureURI = this.getFeatureURI(entry.getId(), entry.getVersion());
                Feature includedFeature = this.parseFeature(featureParser, includedFeatureURI, monitor);
                if (includedFeature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)includedFeatureURI)));
                } else {
                    features.put(key, includedFeature);
                    this.loadIncludedFeatures(includedFeature, featureParser, features, monitor);
                }
            }
            ++n2;
        }
    }

    private BundleDescription[] loadBundlesFromSite(IProgressMonitor monitor) {
        SiteBundle[] siteBundles = this.site.getBundles();
        HashMap<String, BundleDescription> tmpBundleCache = new HashMap<String, BundleDescription>(siteBundles.length);
        SiteBundle[] siteBundleArray = siteBundles;
        int n = siteBundles.length;
        int n2 = 0;
        while (n2 < n) {
            SiteBundle siteBundle = siteBundleArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String key = null;
            if (siteBundle.getBundleIdentifier() == null || siteBundle.getBundleVersion() == null || !tmpBundleCache.containsKey(key = siteBundle.getBundleIdentifier() + VERSION_SEPARATOR + siteBundle.getBundleVersion())) {
                URI bundleURI = this.getSiteBundleURI(siteBundle);
                BundleDescription bundle = this.parseBundleDescription(bundleURI, monitor);
                if (bundle == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingBundle, (Object)bundleURI)));
                } else {
                    if (key == null) {
                        siteBundle.setBundleIdentifier(bundle.getSymbolicName());
                        siteBundle.setBundleVersion(bundle.getVersion().toString());
                        key = siteBundle.getBundleIdentifier() + VERSION_SEPARATOR + siteBundle.getBundleVersion().toString();
                    }
                    tmpBundleCache.put(key, bundle);
                }
            }
            ++n2;
        }
        this.bundleCache = tmpBundleCache;
        return this.bundleCache.values().toArray(new BundleDescription[this.bundleCache.size()]);
    }

    /*
     * Exception decompiling
     */
    private BundleDescription parseBundleDescription(URI bundleURI, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlock(TryRewriter.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlocks(TryRewriter.java:147)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extendTryBlocks(Op03Rewriters.java:48)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:557)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

