/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.equinox.http.servlet.internal.DefaultServletContextHelper;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;

public class HttpContextHolder {
    final HttpContext httpContext;
    final ServiceRegistration<? extends ServletContextHelper> registration;
    final String filter;
    final AtomicLong useCount = new AtomicLong(0L);

    public HttpContextHolder(HttpContext httpContext, ServiceRegistration<DefaultServletContextHelper> registration) {
        this.httpContext = httpContext;
        this.registration = registration;
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append('(');
        filterBuilder.append("service.id");
        filterBuilder.append('=');
        filterBuilder.append(registration.getReference().getProperty("service.id"));
        filterBuilder.append(')');
        this.filter = filterBuilder.toString();
    }

    public ServiceReference<? extends ServletContextHelper> getServiceReference() {
        try {
            return this.registration.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public long incrementUseCount() {
        return this.useCount.incrementAndGet();
    }

    public long decrementUseCount() {
        long result = this.useCount.decrementAndGet();
        if (result == 0L) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return result;
    }

    public Object getHttpContext() {
        return this.httpContext;
    }
}

