/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DiscoveryInstallOperation
implements IRunnableWithProgress {
    private final List<CatalogItem> installableConnectors;
    private final ProvisioningUI provisioningUI;
    private Set<URI> repositoryLocations;

    public DiscoveryInstallOperation(List<CatalogItem> installableConnectors) {
        if (installableConnectors == null || installableConnectors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.installableConnectors = new ArrayList<CatalogItem>(installableConnectors);
        this.provisioningUI = ProvisioningUI.getDefaultUI();
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.InstallConnectorsJob_task_configuring, (int)150);
            try {
                IInstallableUnit[] ius = this.computeInstallableUnits(monitor.newChild(50));
                this.checkCancelled((IProgressMonitor)monitor);
                InstallOperation installOperation = this.resolve((IProgressMonitor)monitor.newChild(50), ius, this.repositoryLocations.toArray(new URI[0]));
                this.checkCancelled((IProgressMonitor)monitor);
                if (installOperation.getResolutionResult().getSeverity() > 2) {
                    monitor.setTaskName(ProvUIMessages.ProvisioningOperationWizard_Remediation_Operation);
                    RemediationOperation remediationOperation = new RemediationOperation(this.provisioningUI.getSession(), installOperation.getProfileChangeRequest());
                    remediationOperation.resolveModal((IProgressMonitor)monitor.newChild(50));
                    Display.getDefault().asyncExec(() -> {
                        int n = this.provisioningUI.openInstallWizard(Arrays.asList(ius), installOperation, remediationOperation, null);
                    });
                } else {
                    Display.getDefault().asyncExec(() -> {
                        int n = this.provisioningUI.openInstallWizard(Arrays.asList(ius), installOperation, null);
                    });
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private InstallOperation resolve(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) {
        InstallOperation installOperation = this.provisioningUI.getInstallOperation(Arrays.asList(ius), repositories);
        installOperation.resolveModal((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)this.installableConnectors.size()));
        return installOperation;
    }

    public IInstallableUnit[] computeInstallableUnits(SubMonitor monitor) throws CoreException {
        try {
            monitor.setWorkRemaining(100);
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            List<IInstallableUnit> installableUnits = this.queryInstallableUnits(monitor.newChild(50), repositories);
            this.removeOldVersions(installableUnits);
            this.checkForUnavailable(installableUnits);
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.discovery", Messages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.discovery", Messages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void checkForUnavailable(List<IInstallableUnit> installableUnits) throws CoreException {
        HashSet<String> foundIds = new HashSet<String>();
        for (IInstallableUnit unit : installableUnits) {
            foundIds.add(unit.getId());
        }
        Object message = "";
        Object detailedMessage = "";
        for (CatalogItem descriptor : this.installableConnectors) {
            StringBuilder unavailableIds = null;
            for (String id : descriptor.getInstallableUnits()) {
                if (foundIds.contains(id)) continue;
                if (unavailableIds == null) {
                    unavailableIds = new StringBuilder();
                } else {
                    unavailableIds.append(Messages.InstallConnectorsJob_commaSeparator);
                }
                unavailableIds.append(id);
            }
            if (unavailableIds == null) continue;
            if (((String)message).length() > 0) {
                message = (String)message + Messages.InstallConnectorsJob_commaSeparator;
            }
            message = (String)message + descriptor.getName();
            if (((String)detailedMessage).length() > 0) {
                detailedMessage = (String)detailedMessage + Messages.InstallConnectorsJob_commaSeparator;
            }
            detailedMessage = (String)detailedMessage + NLS.bind((String)Messages.PrepareInstallProfileJob_notFoundDescriptorDetail, (Object[])new String[]{descriptor.getName(), unavailableIds.toString(), descriptor.getSiteUrl()});
        }
        if (((String)message).length() > 0) {
            boolean[] okayToProceed = new boolean[1];
            String finalMessage = message;
            Display.getDefault().syncExec(() -> {
                boolean bl = MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.InstallConnectorsJob_questionProceed, (String)NLS.bind((String)Messages.InstallConnectorsJob_questionProceed_long, (Object[])new Object[]{finalMessage}));
            });
            if (!okayToProceed[0]) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.discovery", NLS.bind((String)Messages.InstallConnectorsJob_connectorsNotAvailable, (Object)detailedMessage), null));
            }
        }
    }

    private void removeOldVersions(List<IInstallableUnit> installableUnits) {
        Version version;
        HashMap<String, Version> symbolicNameToVersion = new HashMap<String, Version>();
        for (IInstallableUnit unit : installableUnits) {
            version = (Version)symbolicNameToVersion.get(unit.getId());
            if (version != null && version.compareTo((Object)unit.getVersion()) >= 0) continue;
            symbolicNameToVersion.put(unit.getId(), unit.getVersion());
        }
        if (symbolicNameToVersion.size() != installableUnits.size()) {
            for (IInstallableUnit unit : new ArrayList<IInstallableUnit>(installableUnits)) {
                version = (Version)symbolicNameToVersion.get(unit.getId());
                if (version.equals(unit.getVersion())) continue;
                installableUnits.remove(unit);
            }
        }
    }

    private List<IInstallableUnit> queryInstallableUnits(SubMonitor monitor, List<IMetadataRepository> repositories) throws URISyntaxException {
        ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
        monitor.setWorkRemaining(repositories.size());
        for (IMetadataRepository repository : repositories) {
            this.checkCancelled((IProgressMonitor)monitor);
            Set<String> installableUnitIdsThisRepository = this.getDescriptorIds(repository);
            for (IInstallableUnit iu : repository.query(this.createInstalledIUsQuery(), (IProgressMonitor)monitor.newChild(1))) {
                String id = iu.getId();
                if (!installableUnitIdsThisRepository.contains(id)) continue;
                installableUnits.add(iu);
            }
        }
        return installableUnits;
    }

    protected IQuery<IInstallableUnit> createInstalledIUsQuery() {
        return QueryUtil.createIUGroupQuery();
    }

    private List<IMetadataRepository> addRepositories(SubMonitor monitor) throws MalformedURLException, URISyntaxException, ProvisionException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        this.repositoryLocations = new HashSet<URI>();
        monitor.setWorkRemaining(this.installableConnectors.size() * 5);
        for (CatalogItem descriptor : this.installableConnectors) {
            URI uri = new URL(descriptor.getSiteUrl()).toURI();
            if (this.repositoryLocations.add(uri)) {
                this.checkCancelled((IProgressMonitor)monitor);
                repositoryTracker.addRepository(uri, null, session);
            }
            monitor.worked(1);
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        monitor.setWorkRemaining(repositories.size());
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.class);
        for (URI uri : this.repositoryLocations) {
            this.checkCancelled((IProgressMonitor)monitor);
            IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
            repositories.add(repository);
        }
        return repositories;
    }

    private Set<String> getDescriptorIds(IMetadataRepository repository) throws URISyntaxException {
        HashSet<String> installableUnitIdsThisRepository = new HashSet<String>();
        for (CatalogItem descriptor : this.installableConnectors) {
            try {
                if (!repository.getLocation().equals(new URL(descriptor.getSiteUrl()).toURI())) continue;
                installableUnitIdsThisRepository.addAll(descriptor.getInstallableUnits());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return installableUnitIdsThisRepository;
    }
}

