/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoaderSources;
import org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.loader.buddy.PolicyHandler;
import org.eclipse.osgi.internal.loader.sources.MultiSourcePackage;
import org.eclipse.osgi.internal.loader.sources.NullPackageSource;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleLoader
extends ModuleLoader {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final ClassContext CLASS_CONTEXT = AccessController.doPrivileged(new PrivilegedAction<ClassContext>(){

        @Override
        public ClassContext run() {
            return new ClassContext();
        }
    });
    public static final ClassLoader FW_CLASSLOADER = BundleLoader.getClassLoader(EquinoxContainer.class);
    private static final int PRE_CLASS = 1;
    private static final int POST_CLASS = 2;
    private static final int PRE_RESOURCE = 3;
    private static final int POST_RESOURCE = 4;
    private static final int PRE_RESOURCES = 5;
    private static final int POST_RESOURCES = 6;
    private static final Pattern PACKAGENAME_FILTER = Pattern.compile("\\(osgi.wiring.package\\s*=\\s*([^)]+)\\)");
    private final ModuleWiring wiring;
    private final EquinoxContainer container;
    private final Debug debug;
    private final PolicyHandler policy;
    private final Collection<String> exportedPackages;
    private final BundleLoaderSources exportSources;
    private final KeyedHashSet requiredSources = new KeyedHashSet(false);
    private final KeyedHashSet importedSources = new KeyedHashSet(false);
    private final List<ModuleWire> requiredBundleWires;
    private boolean importsInitialized = false;
    private boolean dynamicAllPackages;
    private String[] dynamicImportPackageStems;
    private String[] dynamicImportPackages;
    private Object classLoaderMonitor = new Object();
    private ModuleClassLoader classloader;
    private final ClassLoader parent;
    private final AtomicBoolean triggerClassLoaded = new AtomicBoolean(false);

    public static final String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    public BundleLoader(ModuleWiring wiring, EquinoxContainer container, ClassLoader parent) {
        this.wiring = wiring;
        this.container = container;
        this.debug = container.getConfiguration().getDebug();
        this.parent = parent;
        this.exportSources = new BundleLoaderSources(this);
        ArrayList<ModuleCapability> exports = wiring.getModuleCapabilities("osgi.wiring.package");
        exports = exports == null ? new ArrayList<ModuleCapability>(0) : exports;
        this.exportedPackages = Collections.synchronizedCollection(exports.size() > 10 ? new HashSet(exports.size()) : new ArrayList(exports.size()));
        BundleLoader.initializeExports(exports, this.exportSources, this.exportedPackages);
        this.addDynamicImportPackage(wiring.getModuleRequirements("osgi.wiring.package"));
        List<ModuleWire> currentRequireBundleWires = wiring.getRequiredModuleWires("osgi.wiring.bundle");
        this.requiredBundleWires = currentRequireBundleWires == null || currentRequireBundleWires.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(currentRequireBundleWires);
        List<ModuleCapability> moduleDatas = wiring.getRevision().getModuleCapabilities("equinox.module.data");
        List buddyList = (List)(moduleDatas.isEmpty() ? null : moduleDatas.get(0).getAttributes().get("buddy.policy"));
        PolicyHandler policyHandler = this.policy = buddyList != null ? new PolicyHandler(this, buddyList, container.getPackageAdmin()) : null;
        if (this.policy != null) {
            Module systemModule = container.getStorage().getModuleContainer().getModule(0L);
            Bundle systemBundle = systemModule.getBundle();
            this.policy.open(systemBundle.getBundleContext());
        }
    }

    public ModuleWiring getWiring() {
        return this.wiring;
    }

    public void addFragmentExports(List<ModuleCapability> exports) {
        BundleLoader.initializeExports(exports, this.exportSources, this.exportedPackages);
    }

    private static void initializeExports(List<ModuleCapability> exports, BundleLoaderSources sources, Collection<String> exportNames) {
        if (exports != null) {
            for (ModuleCapability export : exports) {
                String name = (String)export.getAttributes().get("osgi.wiring.package");
                if (sources.forceSourceCreation(export) && !exportNames.contains(name)) {
                    sources.createPackageSource(export, true);
                }
                exportNames.add(name);
            }
        }
    }

    final PackageSource createExportPackageSource(ModuleWire importWire, Collection<BundleLoader> visited) {
        String name = (String)importWire.getCapability().getAttributes().get("osgi.wiring.package");
        BundleLoader providerLoader = (BundleLoader)importWire.getProviderWiring().getModuleLoader();
        if (providerLoader == null) {
            return BundleLoader.createMultiSource(name, new PackageSource[0]);
        }
        PackageSource requiredSource = providerLoader.findRequiredSource(name, visited);
        PackageSource exportSource = providerLoader.exportSources.createPackageSource(importWire.getCapability(), false);
        if (requiredSource == null) {
            return exportSource;
        }
        return BundleLoader.createMultiSource(name, new PackageSource[]{requiredSource, exportSource});
    }

    private static PackageSource createMultiSource(String packageName, PackageSource[] sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        ArrayList<SingleSourcePackage> sourceList = new ArrayList<SingleSourcePackage>(sources.length);
        int i = 0;
        while (i < sources.length) {
            SingleSourcePackage[] innerSources = sources[i].getSuppliers();
            int j = 0;
            while (j < innerSources.length) {
                if (!sourceList.contains(innerSources[j])) {
                    sourceList.add(innerSources[j]);
                }
                ++j;
            }
            ++i;
        }
        return new MultiSourcePackage(packageName, sourceList.toArray(new SingleSourcePackage[sourceList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleClassLoader getModuleClassLoader() {
        Object object = this.classLoaderMonitor;
        synchronized (object) {
            if (this.classloader == null) {
                final List<ClassLoaderHook> hooks = this.container.getConfiguration().getHookRegistry().getClassLoaderHooks();
                final BundleInfo.Generation generation = (BundleInfo.Generation)this.wiring.getRevision().getRevisionInfo();
                if (System.getSecurityManager() == null) {
                    this.classloader = BundleLoader.createClassLoaderPrivledged(this.parent, generation.getBundleInfo().getStorage().getConfiguration(), this, generation, hooks);
                } else {
                    final ClassLoader cl = this.parent;
                    this.classloader = AccessController.doPrivileged(new PrivilegedAction<ModuleClassLoader>(){

                        @Override
                        public ModuleClassLoader run() {
                            return BundleLoader.createClassLoaderPrivledged(cl, generation.getBundleInfo().getStorage().getConfiguration(), BundleLoader.this, generation, hooks);
                        }
                    });
                }
                for (ClassLoaderHook hook : hooks) {
                    hook.classLoaderCreated(this.classloader);
                }
            }
            return this.classloader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFragments(Collection<ModuleRevision> fragments) {
        Object object = this.classLoaderMonitor;
        synchronized (object) {
            this.addFragmentExports(this.wiring.getModuleCapabilities("osgi.wiring.package"));
            this.loadClassLoaderFragments(fragments);
        }
    }

    void loadClassLoaderFragments(Collection<ModuleRevision> fragments) {
        if (this.classloader != null) {
            this.classloader.loadFragments(fragments);
        }
    }

    static ModuleClassLoader createClassLoaderPrivledged(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation, List<ClassLoaderHook> hooks) {
        for (ClassLoaderHook hook : hooks) {
            ModuleClassLoader hookClassLoader = hook.createClassLoader(parent, configuration, delegate, generation);
            if (hookClassLoader == null) continue;
            return hookClassLoader;
        }
        return new EquinoxClassLoader(parent, configuration, delegate, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.classLoaderMonitor;
        synchronized (object) {
            if (this.classloader != null) {
                this.classloader.close();
            }
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.getModuleClassLoader();
    }

    public ClassLoader getParentClassLoader() {
        return this.parent;
    }

    final URL getResource(String name) {
        return this.getModuleClassLoader().getResource(name);
    }

    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class<?> clazz = this.getModuleClassLoader().findLocalClass(name);
            if (this.debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (e.getCause() instanceof BundleException) {
                throw e;
            }
            return null;
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    Class<?> findClass(String name, boolean checkParent) throws ClassNotFoundException {
        if (checkParent && this.parent != null && name.startsWith(JAVA_PACKAGE)) {
            return this.parent.loadClass(name);
        }
        return this.findClassInternal(name, checkParent);
    }

    private Class<?> findClassInternal(String name, boolean checkParent) throws ClassNotFoundException {
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findClassInternal(" + name + ")");
        }
        String pkgName = BundleLoader.getPackageName(name);
        boolean bootDelegation = false;
        if (checkParent && this.parent != null && this.container.isBootDelegationPackage(pkgName)) {
            try {
                return this.parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                bootDelegation = true;
            }
        }
        Class<?> result = null;
        try {
            result = (Class<?>)this.searchHooks(name, 1);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (result != null) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            if ((result = source.loadClass(name)) != null) {
                return result;
            }
            throw new ClassNotFoundException(String.valueOf(name) + " cannot be found by " + this);
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = source.loadClass(name);
        }
        if (result == null) {
            result = this.findLocalClass(name);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            result = source.loadClass(name);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(String.valueOf(name) + " cannot be found by " + this);
        }
        if (result == null) {
            try {
                result = (Class<?>)this.searchHooks(name, 2);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyClassLoading(name);
        }
        if (result != null) {
            return result;
        }
        if (this.parent != null && !bootDelegation && (checkParent && this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            try {
                return this.parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(String.valueOf(name) + " cannot be found by " + this);
    }

    private <E> E searchHooks(String name, int type) throws ClassNotFoundException, FileNotFoundException {
        List<ClassLoaderHook> loaderHooks = this.container.getConfiguration().getHookRegistry().getClassLoaderHooks();
        if (loaderHooks == null) {
            return null;
        }
        Enumeration<URL> result = null;
        for (ClassLoaderHook hook : loaderHooks) {
            switch (type) {
                case 1: {
                    result = hook.preFindClass(name, this.getModuleClassLoader());
                    break;
                }
                case 2: {
                    result = hook.postFindClass(name, this.getModuleClassLoader());
                    break;
                }
                case 3: {
                    result = hook.preFindResource(name, this.getModuleClassLoader());
                    break;
                }
                case 4: {
                    result = hook.postFindResource(name, this.getModuleClassLoader());
                    break;
                }
                case 5: {
                    result = hook.preFindResources(name, this.getModuleClassLoader());
                    break;
                }
                case 6: {
                    result = hook.postFindResources(name, this.getModuleClassLoader());
                }
            }
            if (result == null) continue;
            return (E)result;
        }
        return (E)result;
    }

    private boolean isRequestFromVM() {
        if (!this.container.getConfiguration().contextBootDelegation) {
            return false;
        }
        Class<?>[] context = CLASS_CONTEXT.getClassContext();
        if (context == null || context.length < 2) {
            return false;
        }
        int i = 1;
        while (i < context.length) {
            Class<?> clazz = context[i];
            if (clazz != BundleLoader.class && !ModuleClassLoader.class.isAssignableFrom(clazz) && clazz != ClassLoader.class && !clazz.getName().equals("java.lang.J9VMInternals")) {
                if (Class.class == clazz) {
                    return false;
                }
                if (Bundle.class.isAssignableFrom(clazz)) {
                    return false;
                }
                ClassLoader cl = BundleLoader.getClassLoader(clazz);
                if (cl != FW_CLASSLOADER) {
                    ClassLoader last = null;
                    while (cl != null && cl != last) {
                        last = cl;
                        if (cl instanceof ModuleClassLoader) {
                            return false;
                        }
                        cl = BundleLoader.getClassLoader(cl.getClass());
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public URL findResource(String name) {
        URL result;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findResource(" + name + ")");
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        boolean bootDelegation = false;
        if (this.parent != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResource(name);
            }
            if (this.container.isBootDelegationPackage(pkgName)) {
                result = this.parent.getResource(name);
                if (result != null) {
                    return result;
                }
                bootDelegation = true;
            }
        }
        result = null;
        try {
            result = (URL)this.searchHooks(name, 3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (result != null) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            return source.getResource(name);
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = source.getResource(name);
        }
        if (result == null) {
            result = this.findLocalResource(name);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            return source.getResource(name);
        }
        if (result == null) {
            try {
                result = (URL)this.searchHooks(name, 4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyResourceLoading(name);
        }
        if (result != null) {
            return result;
        }
        if (this.parent != null && !bootDelegation && (this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            return this.parent.getResource(name);
        }
        return result;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findResources(" + name + ")");
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        Enumeration<URL> result = Collections.enumeration(Collections.emptyList());
        boolean bootDelegation = false;
        if (this.parent != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResources(name);
            }
            if (this.container.isBootDelegationPackage(pkgName)) {
                result = BundleLoader.compoundEnumerations(result, this.parent.getResources(name));
                bootDelegation = true;
            }
        }
        try {
            Enumeration hookResources = (Enumeration)this.searchHooks(name, 5);
            if (hookResources != null) {
                return BundleLoader.compoundEnumerations(result, hookResources);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            return BundleLoader.compoundEnumerations(result, source.getResources(name));
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = BundleLoader.compoundEnumerations(result, source.getResources(name));
        }
        Enumeration<URL> localResults = this.findLocalResources(name);
        result = BundleLoader.compoundEnumerations(result, localResults);
        if (source == null && !result.hasMoreElements() && (source = this.findDynamicSource(pkgName)) != null) {
            return BundleLoader.compoundEnumerations(result, source.getResources(name));
        }
        if (!result.hasMoreElements()) {
            try {
                Enumeration hookResources = (Enumeration)this.searchHooks(name, 6);
                result = BundleLoader.compoundEnumerations(result, hookResources);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (this.policy != null) {
            Enumeration<URL> buddyResult = this.policy.doBuddyResourcesLoading(name);
            result = BundleLoader.compoundEnumerations(result, buddyResult);
        }
        if (!result.hasMoreElements() && this.parent != null && !bootDelegation && (this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            return this.parent.getResources(name);
        }
        return result;
    }

    private boolean isSubPackage(String parentPackage, String subPackage) {
        String prefix = parentPackage.length() == 0 || parentPackage.equals(DEFAULT_PACKAGE) ? "" : String.valueOf(parentPackage) + '.';
        return subPackage.startsWith(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> listResources(String path, String filePattern, int options) {
        KeyedElement[] imports;
        KeyedHashSet importSources;
        String pkgName = BundleLoader.getResourcePackageName(path.endsWith("/") ? path : String.valueOf(path) + '/');
        if (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        boolean subPackages = (options & 1) != 0;
        ArrayList<String> packages = new ArrayList<String>();
        KeyedHashSet keyedHashSet = importSources = this.getImportedSources(null);
        synchronized (keyedHashSet) {
            imports = importSources.elements();
        }
        KeyedElement[] keyedElementArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            KeyedElement keyedElement = keyedElementArray[n2];
            String id = ((PackageSource)keyedElement).getId();
            if (id.equals(pkgName) || subPackages && this.isSubPackage(pkgName, id)) {
                packages.add(id);
            }
            ++n2;
        }
        ArrayList<BundleLoader> visited = new ArrayList<BundleLoader>();
        visited.add(this);
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader = (BundleLoader)bundleWire.getProviderWiring().getModuleLoader();
            if (loader == null) continue;
            loader.addProvidedPackageNames(pkgName, packages, subPackages, visited);
        }
        boolean localSearch = (options & 2) != 0;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> importedPackages = new HashSet<String>(0);
        for (String name : packages) {
            PackageSource externalSource = this.findImportedSource(name, null);
            if (externalSource != null) {
                importedPackages.add(name);
            } else {
                externalSource = this.findRequiredSource(name, null);
            }
            if (externalSource == null || localSearch) continue;
            String packagePath = name.replace('.', '/');
            Collection<String> externalResources = externalSource.listResources(packagePath, filePattern);
            for (String resource : externalResources) {
                if (result.contains(resource)) continue;
                result.add(resource);
            }
        }
        Collection<String> localResources = this.getModuleClassLoader().listLocalResources(path, filePattern, options);
        for (String resource : localResources) {
            String resourcePkg = BundleLoader.getResourcePackageName(resource);
            if (importedPackages.contains(resourcePkg) || result.contains(resource)) continue;
            result.add(resource);
        }
        return result;
    }

    @Override
    protected List<URL> findEntries(String path, String filePattern, int options) {
        return this.getModuleClassLoader().findEntries(path, filePattern, options);
    }

    public static <E> Enumeration<E> compoundEnumerations(Enumeration<E> list1, Enumeration<E> list2) {
        if (list2 == null || !list2.hasMoreElements()) {
            return list1;
        }
        if (list1 == null || !list1.hasMoreElements()) {
            return list2;
        }
        ArrayList<E> compoundResults = new ArrayList<E>();
        while (list1.hasMoreElements()) {
            compoundResults.add(list1.nextElement());
        }
        while (list2.hasMoreElements()) {
            E item = list2.nextElement();
            if (compoundResults.contains(item)) continue;
            compoundResults.add(item);
        }
        return Collections.enumeration(compoundResults);
    }

    public URL findLocalResource(String name) {
        return this.getModuleClassLoader().findLocalResource(name);
    }

    public Enumeration<URL> findLocalResources(String name) {
        return this.getModuleClassLoader().findLocalResources(name);
    }

    public final String toString() {
        ModuleRevision revision = this.wiring.getRevision();
        String name = revision.getSymbolicName();
        if (name == null) {
            name = "unknown";
        }
        return String.valueOf(name) + '_' + revision.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean isDynamicallyImported(String pkgname) {
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (pkgname.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        KeyedHashSet keyedHashSet = this.importedSources;
        synchronized (keyedHashSet) {
            int i;
            if (this.dynamicAllPackages) {
                return true;
            }
            if (this.dynamicImportPackages != null) {
                i = 0;
                while (i < this.dynamicImportPackages.length) {
                    if (pkgname.equals(this.dynamicImportPackages[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.dynamicImportPackageStems == null) return false;
            i = 0;
            while (true) {
                if (i >= this.dynamicImportPackageStems.length) {
                    return false;
                }
                if (pkgname.startsWith(this.dynamicImportPackageStems[i])) {
                    return true;
                }
                ++i;
            }
        }
    }

    final void addExportedProvidersFor(String packageName, List<PackageSource> result, Collection<BundleLoader> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        PackageSource local = null;
        if (this.isExportedPackage(packageName)) {
            local = this.exportSources.getPackageSource(packageName);
        } else if (this.isSubstitutedExport(packageName)) {
            result.add(this.findImportedSource(packageName, visited));
            return;
        }
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader;
            if (local == null && !"reexport".equals(bundleWire.getRequirement().getDirectives().get("visibility")) || (loader = (BundleLoader)bundleWire.getProviderWiring().getModuleLoader()) == null) continue;
            loader.addExportedProvidersFor(packageName, result, visited);
        }
        if (local != null) {
            result.add(local);
        }
    }

    final void addProvidedPackageNames(String packageName, List<String> result, boolean subPackages, Collection<BundleLoader> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (String exported : this.exportedPackages) {
            if (!exported.equals(packageName) && (!subPackages || !this.isSubPackage(packageName, exported)) || result.contains(exported)) continue;
            result.add(exported);
        }
        for (String substituted : this.wiring.getSubstitutedNames()) {
            if (!substituted.equals(packageName) && (!subPackages || !this.isSubPackage(packageName, substituted)) || result.contains(substituted)) continue;
            result.add(substituted);
        }
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader;
            if (!"reexport".equals(bundleWire.getRequirement().getDirectives().get("visibility")) || (loader = (BundleLoader)bundleWire.getProviderWiring().getModuleLoader()) == null) continue;
            loader.addProvidedPackageNames(packageName, result, subPackages, visited);
        }
    }

    public final boolean isExportedPackage(String name) {
        return this.exportedPackages.contains(name);
    }

    final boolean isSubstitutedExport(String name) {
        return this.wiring.isSubstitutedPackage(name);
    }

    private void addDynamicImportPackage(List<ModuleRequirement> packageImports) {
        if (packageImports == null || packageImports.isEmpty()) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packageImports.size());
        for (ModuleRequirement packageImport : packageImports) {
            String dynamicName;
            Matcher matcher;
            if (!"dynamic".equals(packageImport.getDirectives().get("resolution")) || !(matcher = PACKAGENAME_FILTER.matcher(packageImport.getDirectives().get("filter"))).find() || (dynamicName = matcher.group(1)) == null) continue;
            dynamicImports.add(dynamicName);
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDynamicImportPackage(String[] packages) {
        if (packages == null) {
            return;
        }
        KeyedHashSet keyedHashSet = this.importedSources;
        synchronized (keyedHashSet) {
            int i;
            ArrayList<String> names;
            ArrayList<String> stems;
            int size = packages.length;
            if (this.dynamicImportPackageStems == null) {
                stems = new ArrayList<String>(size);
            } else {
                stems = new ArrayList(size + this.dynamicImportPackageStems.length);
                int i2 = 0;
                while (i2 < this.dynamicImportPackageStems.length) {
                    stems.add(this.dynamicImportPackageStems[i2]);
                    ++i2;
                }
            }
            if (this.dynamicImportPackages == null) {
                names = new ArrayList<String>(size);
            } else {
                names = new ArrayList(size + this.dynamicImportPackages.length);
                i = 0;
                while (i < this.dynamicImportPackages.length) {
                    names.add(this.dynamicImportPackages[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < size) {
                String name = packages[i];
                if (!this.isDynamicallyImported(name)) {
                    if (name.equals("*")) {
                        this.dynamicAllPackages = true;
                        return;
                    }
                    if (name.endsWith(".*")) {
                        stems.add(name.substring(0, name.length() - 1));
                    } else {
                        names.add(name);
                    }
                }
                ++i;
            }
            size = stems.size();
            if (size > 0) {
                this.dynamicImportPackageStems = stems.toArray(new String[size]);
            }
            if ((size = names.size()) > 0) {
                this.dynamicImportPackages = names.toArray(new String[size]);
            }
        }
    }

    public final void addDynamicImportPackage(ManifestElement[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        StringBuilder importSpec = new StringBuilder();
        ManifestElement[] manifestElementArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            ManifestElement dynamicImportElement = manifestElementArray[n2];
            String[] stringArray = names = dynamicImportElement.getValueComponents();
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                dynamicImports.add(name);
                ++n4;
            }
            if (importSpec.length() > 0) {
                importSpec.append(',');
            }
            importSpec.append(dynamicImportElement.toString());
            ++n2;
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
            HashMap<String, String> dynamicImportMap = new HashMap<String, String>();
            dynamicImportMap.put("DynamicImport-Package", importSpec.toString());
            try {
                ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(dynamicImportMap);
                this.wiring.addDynamicImports(builder);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    private PackageSource findSource(String pkgName) {
        if (pkgName == null) {
            return null;
        }
        PackageSource result = this.findImportedSource(pkgName, null);
        if (result != null) {
            return result;
        }
        return this.findRequiredSource(pkgName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findImportedSource(String pkgName, Collection<BundleLoader> visited) {
        KeyedHashSet imports;
        KeyedHashSet keyedHashSet = imports = this.getImportedSources(visited);
        synchronized (keyedHashSet) {
            return (PackageSource)imports.getByKey(pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyedHashSet getImportedSources(Collection<BundleLoader> visited) {
        KeyedHashSet keyedHashSet = this.importedSources;
        synchronized (keyedHashSet) {
            if (this.importsInitialized) {
                return this.importedSources;
            }
            List<ModuleWire> importWires = this.wiring.getRequiredModuleWires("osgi.wiring.package");
            if (importWires != null) {
                for (ModuleWire importWire : importWires) {
                    PackageSource source = this.createExportPackageSource(importWire, visited);
                    if (source == null) continue;
                    this.importedSources.add(source);
                }
            }
            this.importsInitialized = true;
            return this.importedSources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findDynamicSource(String pkgName) {
        if (!this.isExportedPackage(pkgName) && this.isDynamicallyImported(pkgName)) {
            ModuleRevision revision;
            ModuleWire dynamicWire;
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] attempting to resolve dynamic package: " + pkgName);
            }
            if ((dynamicWire = (revision = this.wiring.getRevision()).getRevisions().getModule().getContainer().resolveDynamic(pkgName, revision)) != null) {
                PackageSource source = this.createExportPackageSource(dynamicWire, null);
                if (this.debug.DEBUG_LOADER) {
                    Debug.println("BundleLoader[" + this + "] using dynamic import source: " + source);
                }
                KeyedHashSet keyedHashSet = this.importedSources;
                synchronized (keyedHashSet) {
                    this.importedSources.add(source);
                }
                return source;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findRequiredSource(String pkgName, Collection<BundleLoader> visited) {
        PackageSource source;
        KeyedHashSet keyedHashSet = this.requiredSources;
        synchronized (keyedHashSet) {
            PackageSource result = (PackageSource)this.requiredSources.getByKey(pkgName);
            if (result != null) {
                return result.isNullSource() ? null : result;
            }
        }
        if (visited == null) {
            visited = new ArrayList<BundleLoader>();
        }
        if (!visited.contains(this)) {
            visited.add(this);
        }
        ArrayList<PackageSource> result = new ArrayList<PackageSource>(3);
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader = (BundleLoader)bundleWire.getProviderWiring().getModuleLoader();
            if (loader == null) continue;
            loader.addExportedProvidersFor(pkgName, result, visited);
        }
        if (result.size() == 0) {
            source = NullPackageSource.getNullPackageSource(pkgName);
        } else if (result.size() == 1) {
            source = (PackageSource)result.get(0);
        } else {
            PackageSource[] srcs = result.toArray(new PackageSource[result.size()]);
            source = BundleLoader.createMultiSource(pkgName, srcs);
        }
        KeyedHashSet keyedHashSet2 = this.requiredSources;
        synchronized (keyedHashSet2) {
            this.requiredSources.add(source);
        }
        return source.isNullSource() ? null : source;
    }

    public final PackageSource getPackageSource(String pkgName) {
        PackageSource result = this.findSource(pkgName);
        if (!this.isExportedPackage(pkgName)) {
            return result;
        }
        PackageSource localSource = this.exportSources.getPackageSource(pkgName);
        if (result == null) {
            return localSource;
        }
        if (localSource == null) {
            return result;
        }
        return BundleLoader.createMultiSource(pkgName, new PackageSource[]{result, localSource});
    }

    @Override
    protected boolean getAndSetTrigger() {
        return this.triggerClassLoaded.getAndSet(true);
    }

    @Override
    public boolean isTriggerSet() {
        return this.triggerClassLoaded.get();
    }

    static final class ClassContext
    extends SecurityManager {
        ClassContext() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

