/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Map;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessShellFactory
implements Factory<Command> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessShellFactory.class);
    private String[] command;
    private EnumSet<TtyOptions> ttyOptions;

    public ProcessShellFactory() {
    }

    public ProcessShellFactory(String[] command) {
        this(command, EnumSet.noneOf(TtyOptions.class));
    }

    public ProcessShellFactory(String[] command, EnumSet<TtyOptions> ttyOptions) {
        this.command = command;
        this.ttyOptions = ttyOptions;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    @Override
    public Command create() {
        return new InvertedShellWrapper(new ProcessShell());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessShell
    implements InvertedShell {
        private Process process;
        private TtyFilterOutputStream in;
        private TtyFilterInputStream out;
        private TtyFilterInputStream err;

        @Override
        public void start(Map<String, String> env) throws IOException {
            String[] cmds = new String[ProcessShellFactory.this.command.length];
            for (int i = 0; i < cmds.length; ++i) {
                cmds[i] = "$USER".equals(ProcessShellFactory.this.command[i]) ? env.get("USER") : ProcessShellFactory.this.command[i];
            }
            ProcessBuilder builder = new ProcessBuilder(cmds);
            if (env != null) {
                try {
                    builder.environment().putAll(env);
                }
                catch (Exception e) {
                    LOG.info("Could not set environment for command", (Throwable)e);
                }
            }
            LOG.info("Starting shell with command: '{}' and env: {}", builder.command(), builder.environment());
            this.process = builder.start();
            this.out = new TtyFilterInputStream(this.process.getInputStream());
            this.err = new TtyFilterInputStream(this.process.getErrorStream());
            this.in = new TtyFilterOutputStream(this.process.getOutputStream(), this.err);
        }

        @Override
        public OutputStream getInputStream() {
            return this.in;
        }

        @Override
        public InputStream getOutputStream() {
            return this.out;
        }

        @Override
        public InputStream getErrorStream() {
            return this.err;
        }

        @Override
        public boolean isAlive() {
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        @Override
        public int exitValue() {
            return this.process.exitValue();
        }

        @Override
        public void destroy() {
            this.process.destroy();
        }

        protected class TtyFilterInputStream
        extends FilterInputStream {
            private Buffer buffer;
            private int lastChar;

            public TtyFilterInputStream(InputStream in) {
                super(in);
                this.buffer = new Buffer(32);
            }

            synchronized void write(int c) {
                this.buffer.putByte((byte)c);
            }

            synchronized void write(byte[] buf, int off, int len) {
                this.buffer.putBytes(buf, off, len);
            }

            public int available() throws IOException {
                return super.available() + this.buffer.available();
            }

            public synchronized int read() throws IOException {
                int c;
                if (this.buffer.available() > 0) {
                    c = this.buffer.getByte();
                    this.buffer.compact();
                } else {
                    c = super.read();
                }
                if (c == 10 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.ONlCr) && this.lastChar != 13) {
                    c = 13;
                    Buffer buf = new Buffer();
                    buf.putByte((byte)10);
                    buf.putBuffer(this.buffer);
                    this.buffer = buf;
                } else if (c == 13 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.OCrNl)) {
                    c = 10;
                }
                this.lastChar = c;
                return c;
            }

            public synchronized int read(byte[] b, int off, int len) throws IOException {
                int nb;
                if (this.buffer.available() == 0) {
                    nb = super.read(b, off, len);
                    this.buffer.putRawBytes(b, off, nb);
                }
                nb = 0;
                while (nb < len && this.buffer.available() > 0) {
                    b[off + nb++] = (byte)this.read();
                }
                return nb;
            }
        }

        protected class TtyFilterOutputStream
        extends FilterOutputStream {
            private TtyFilterInputStream echo;

            public TtyFilterOutputStream(OutputStream out, TtyFilterInputStream echo) {
                super(out);
                this.echo = echo;
            }

            public void write(int c) throws IOException {
                if (c == 10 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.INlCr)) {
                    c = 13;
                } else if (c == 13 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.ICrNl)) {
                    c = 10;
                }
                super.write(c);
                if (ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.Echo)) {
                    this.echo.write(c);
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TtyOptions {
        Echo,
        INlCr,
        ICrNl,
        ONlCr,
        OCrNl;

    }
}

