/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionStrategy
implements MinimizationStrategy {
    private static final long serialVersionUID = 1L;
    private boolean computationCanceled;

    @Override
    public void cancelExplanationComputation() {
        this.computationCanceled = true;
    }

    @Override
    public IVecInt explain(ISolver solver, Map<Integer, ?> constrs, IVecInt assumps) throws TimeoutException {
        this.computationCanceled = false;
        VecInt encodingAssumptions = new VecInt(constrs.size() + assumps.size());
        assumps.copyTo(encodingAssumptions);
        IVecInt firstExplanation = solver.unsatExplanation();
        VecInt results = new VecInt(firstExplanation.size());
        if (firstExplanation.size() == 1) {
            results.push(-firstExplanation.get(0));
            return results;
        }
        if (solver.isVerbose()) {
            System.out.print(String.valueOf(solver.getLogPrefix()) + "initial unsat core ");
            firstExplanation.sort();
            IteratorInt it = firstExplanation.iterator();
            while (it.hasNext()) {
                System.out.print(constrs.get(-it.next()));
                System.out.print(" ");
            }
            System.out.println();
            solver.printStat(new PrintWriter(System.out, true), "c ");
        }
        int i = 0;
        while (i < firstExplanation.size()) {
            if (assumps.contains(firstExplanation.get(i))) {
                firstExplanation.delete(i);
                continue;
            }
            ++i;
        }
        Set<Integer> constraintsVariables = constrs.keySet();
        VecInt remainingVariables = new VecInt(constraintsVariables.size());
        for (Integer v : constraintsVariables) {
            remainingVariables.push(v);
        }
        IteratorInt it = firstExplanation.iterator();
        while (it.hasNext()) {
            int p = it.next();
            if (p < 0) {
                p = -p;
            }
            remainingVariables.remove(p);
        }
        remainingVariables.copyTo(encodingAssumptions);
        int unsatcorebegin = encodingAssumptions.size();
        firstExplanation.copyTo(encodingAssumptions);
        assert (!solver.isSatisfiable(encodingAssumptions));
        int unsatcorelimit = encodingAssumptions.size() - 1;
        int i2 = unsatcorebegin;
        while (i2 < unsatcorelimit) {
            if (this.computationCanceled) {
                throw new TimeoutException();
            }
            encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
            if (solver.isVerbose()) {
                System.out.println(String.valueOf(solver.getLogPrefix()) + "checking " + constrs.get(encodingAssumptions.get(i2)) + " ...");
            }
            if (solver.isSatisfiable(encodingAssumptions)) {
                encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
                results.push(-encodingAssumptions.get(i2));
                if (solver.isVerbose()) {
                    System.out.println(String.valueOf(solver.getLogPrefix()) + "mandatory.");
                }
            } else if (solver.isVerbose()) {
                System.out.println(String.valueOf(solver.getLogPrefix()) + "not needed.");
            }
            ++i2;
        }
        if (results.size() == 0) {
            results.push(-encodingAssumptions.get(unsatcorelimit));
            if (solver.isVerbose()) {
                System.out.println(String.valueOf(solver.getLogPrefix()) + "skipping last test,the remaining element " + constrs.get(encodingAssumptions.get(unsatcorelimit)) + " is causing the inconsistency!");
            }
        } else {
            encodingAssumptions.set(unsatcorelimit, -encodingAssumptions.get(unsatcorelimit));
            if (solver.isVerbose()) {
                System.out.println(String.valueOf(solver.getLogPrefix()) + "checking " + constrs.get(encodingAssumptions.get(unsatcorelimit)) + " ...");
            }
            if (solver.isSatisfiable(encodingAssumptions)) {
                encodingAssumptions.set(unsatcorelimit, -encodingAssumptions.get(unsatcorelimit));
                results.push(-encodingAssumptions.get(unsatcorelimit));
                if (solver.isVerbose()) {
                    System.out.println(String.valueOf(solver.getLogPrefix()) + "mandatory.");
                }
            } else if (solver.isVerbose()) {
                System.out.println(String.valueOf(solver.getLogPrefix()) + "not needed.");
            }
        }
        return results;
    }

    public String toString() {
        return "Deletion based minimization strategy";
    }
}

