/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class ExtendedSite
extends Site {
    private boolean digestExist;
    private String[] availableLocals;
    private String digestURL;
    private LiteFeature[] liteFeatures;
    private LiteFeature[] allLiteFeatures;
    private IURLEntry[] associateSites;
    private boolean pack200 = false;

    public String getDigestURL() {
        return this.digestURL;
    }

    public void setDigestURL(String string) {
        this.digestURL = string;
    }

    public String[] getAvailableLocals() {
        return this.availableLocals;
    }

    public void setAvailableLocals(String[] stringArray) {
        this.availableLocals = stringArray;
    }

    public boolean isDigestExist() {
        return this.digestExist;
    }

    public void setDigestExist(boolean bl) {
        this.digestExist = bl;
    }

    public LiteFeature[] getLiteFeatures() {
        if (this.getCurrentConfiguredSite() != null) {
            return this.filterFeatures(this.getNonFilteredLiteFeatures());
        }
        return this.getNonFilteredLiteFeatures();
    }

    public void setLiteFeatures(LiteFeature[] liteFeatureArray) {
        if (liteFeatureArray == null || liteFeatureArray.length == 0) {
            return;
        }
        this.allLiteFeatures = liteFeatureArray;
        ArrayList<LiteFeature> arrayList = new ArrayList<LiteFeature>();
        int n = 0;
        while (n < this.allLiteFeatures.length) {
            if (this.getFeatureReference(this.allLiteFeatures[n]) != null) {
                arrayList.add(this.allLiteFeatures[n]);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            this.liteFeatures = arrayList.toArray(new LiteFeature[arrayList.size()]);
        }
    }

    public LiteFeature getLiteFeature(VersionedIdentifier versionedIdentifier) {
        if (this.allLiteFeatures == null) {
            return null;
        }
        int n = 0;
        while (n < this.allLiteFeatures.length) {
            if (versionedIdentifier.equals(this.allLiteFeatures[n].getVersionedIdentifier())) {
                return this.allLiteFeatures[n];
            }
            ++n;
        }
        return null;
    }

    public LiteFeature[] getNonFilteredLiteFeatures() {
        return this.liteFeatures;
    }

    public void setNonFilteredLiteFeatures(LiteFeature[] liteFeatureArray) {
        this.liteFeatures = liteFeatureArray;
    }

    public boolean supportsPack200() {
        return this.pack200;
    }

    public void setSupportsPack200(boolean bl) {
        this.pack200 = bl;
    }

    private LiteFeature[] filterFeatures(LiteFeature[] liteFeatureArray) {
        ArrayList<LiteFeature> arrayList = new ArrayList<LiteFeature>();
        if (liteFeatureArray != null) {
            int n = 0;
            while (n < liteFeatureArray.length) {
                LiteFeature liteFeature = liteFeatureArray[n];
                if (UpdateManagerUtils.isValidEnvironment(liteFeature)) {
                    arrayList.add(liteFeature);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + liteFeature);
                }
                ++n;
            }
        }
        LiteFeature[] liteFeatureArray2 = new LiteFeature[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(liteFeatureArray2);
        }
        return liteFeatureArray2;
    }

    public IURLEntry[] getAssociateSites() {
        return this.associateSites;
    }

    public void setAssociateSites(IURLEntry[] iURLEntryArray) {
        this.associateSites = iURLEntryArray;
    }
}

