/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class InstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private URL remoteSiteURL;
    private String featureId;
    private String version;

    public InstallCommand(String string, String string2, String string3, String string4, String string5) throws Exception {
        super(string5);
        try {
            int n;
            Object object;
            this.featureId = string;
            this.version = string2;
            this.remoteSiteURL = new URL(UpdateURLDecoder.decode((String)string3, (String)"UTF-8"));
            this.targetSite = this.getTargetSite(string4);
            if (this.targetSite == null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), string);
            }
            if (this.targetSite == null) {
                object = this.getConfiguration().getConfiguredSites();
                n = 0;
                while (n < ((IConfiguredSite[])object).length) {
                    if (object[n].isProductSite() && object[n].isUpdatable()) {
                        this.targetSite = object[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.targetSite == null) {
                object = this.getConfiguration().getConfiguredSites();
                n = 0;
                while (n < ((IConfiguredSite[])object).length) {
                    if (object[n].isUpdatable()) {
                        this.targetSite = object[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.targetSite == null) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.Standalone_cannotInstall, (Object[])new String[]{String.valueOf(string) + " " + string2}), null);
            }
            object = new UpdateSearchScope();
            ((UpdateSearchScope)object).addSearchSite(NLS.bind((String)Messages.InstallCommand_site, (Object)this.remoteSiteURL.toExternalForm()), this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), (UpdateSearchScope)object);
            VersionedIdentifier versionedIdentifier = new VersionedIdentifier(string, string2);
            this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{versionedIdentifier}));
            this.searchRequest.addFilter(new EnvironmentFilter());
            this.searchRequest.addFilter(new BackLevelFilter());
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (CoreException coreException) {
            throw coreException;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IProgressMonitor iProgressMonitor) {
        try {
            block12: {
                try {
                    iProgressMonitor.beginTask(Messages.Standalone_installing, 4);
                    this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    IInstallFeatureOperation[] iInstallFeatureOperationArray = this.collector.getOperations();
                    if (iInstallFeatureOperationArray == null || iInstallFeatureOperationArray.length == 0) {
                        throw Utilities.newCoreException(NLS.bind((String)Messages.Standalone_featureNotFound, (Object[])new String[]{String.valueOf(this.featureId) + " " + this.version, this.remoteSiteURL.toExternalForm()}), null);
                    }
                    ArrayList arrayList = DuplicateConflictsValidator.computeDuplicateConflicts(iInstallFeatureOperationArray, this.getConfiguration());
                    if (arrayList != null) {
                        throw Utilities.newCoreException(Messages.Standalone_duplicate, null);
                    }
                    if (this.isVerifyOnly()) {
                        if (iInstallFeatureOperationArray == null) break block12;
                        if (iInstallFeatureOperationArray.length == 0) {
                            break block12;
                        }
                        IStatus iStatus = OperationsManager.getValidator().validatePendingChanges(iInstallFeatureOperationArray);
                        if (iStatus != null && iStatus.getCode() == 4) {
                            throw new CoreException(iStatus);
                        }
                    } else {
                        IBatchOperation iBatchOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(iInstallFeatureOperationArray);
                        iBatchOperation.execute((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3), this);
                        System.out.println(NLS.bind((String)Messages.Standalone_featureIsInstalled, (Object[])new String[]{String.valueOf(this.featureId) + " " + this.version}));
                    }
                    Object var6_6 = null;
                    iProgressMonitor.done();
                    return true;
                    catch (Exception exception) {
                        throw Utilities.newCoreException(String.valueOf(Messages.Standalone_cannotInstall) + this.featureId + " " + this.version, exception);
                    }
                }
                catch (CoreException coreException) {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(coreException);
                }
            }
            Object var6_5 = null;
            iProgressMonitor.done();
            return false;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
    }

    private IConfiguredSite getTargetSite(String string) throws Exception {
        URL uRL;
        Object object;
        if (string == null) {
            return null;
        }
        IConfiguredSite[] iConfiguredSiteArray = this.getConfiguration().getConfiguredSites();
        File file = new File(string);
        File file2 = file.getName().equals("eclipse") ? null : new File(file, "eclipse");
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            object = iConfiguredSiteArray[n];
            if (object.getSite().getURL().sameFile(file.toURL())) {
                return object;
            }
            if (file2 != null && object.getSite().getURL().sameFile(file2.toURL())) {
                return object;
            }
            ++n;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((object = SiteManager.getSite(uRL = file.toURL(), null)) == null) {
            throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
        }
        IConfiguredSite iConfiguredSite = object.getCurrentConfiguredSite();
        if (iConfiguredSite == null) {
            iConfiguredSite = this.getConfiguration().createConfiguredSite(file);
            IStatus iStatus = iConfiguredSite.verifyUpdatableStatus();
            if (!iStatus.isOK()) {
                throw new CoreException(iStatus);
            }
            this.getConfiguration().addConfiguredSite(iConfiguredSite);
            return iConfiguredSite;
        }
        return iConfiguredSite;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature iFeature) {
            if (iFeature.getVersionedIdentifier().getIdentifier().equals(InstallCommand.this.featureId) && iFeature.getVersionedIdentifier().getVersion().toString().equals(InstallCommand.this.version)) {
                this.operations.add(OperationsManager.getOperationFactory().createInstallOperation(InstallCommand.this.targetSite, iFeature, null, null, null));
            }
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(iInstallFeatureOperationArray);
            return iInstallFeatureOperationArray;
        }
    }
}

