/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    TreeItem[] treeItems = new TreeItem[4];
    TreeItem[] children = new TreeItem[4];
    static int idCounter = 0;
    static boolean eventsRegistered = false;
    boolean isVirtual = false;
    private int itemCount = 0;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
        if ((style & 0x10000000) != 0) {
            this.isVirtual = true;
        }
    }

    void addChild(TreeItem item, int index) {
        if (this.isVirtual) {
            return;
        }
        int size = this.children.length;
        if (this.getNumChildren() == size) {
            TreeItem[] newItems = new TreeItem[size + 4];
            System.arraycopy(this.children, 0, newItems, 0, size);
            this.children = newItems;
        }
        if (index == -1) {
            int i = this.getNumChildren();
            this.children[i] = item;
        } else if (this.children[index] == null) {
            this.children[index] = item;
        } else {
            int num = this.getNumChildren();
            for (int i = num - 1; i >= index; --i) {
                this.children[i + 1] = this.children[i];
            }
            this.children[index] = item;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    static int checkStyle(int style) {
        if (com.ibm.ugl.eswt.expanded.OS.Tree_IncludeScrollbars()) {
            style |= 0x300;
        }
        style = Tree.checkBits(style, 4, 2, 0, 0, 0, 0);
        return style;
    }

    protected void internal_createHandle(int index) {
        if (!eventsRegistered) {
            Display d = this.getDisplay();
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(d.internal_handle, 17, "org/eclipse/swt/widgets/Tree", "treeCallback");
            eventsRegistered = true;
        }
        this.internal_handle = com.ibm.ugl.eswt.expanded.OS.Tree_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 4) != 0) {
            nativeStyle |= 0x400000;
        }
        if ((this.internal_style & 2) != 0) {
            nativeStyle |= 0x800000;
        }
        if ((this.internal_style & 0x20) != 0) {
            nativeStyle |= 0x20;
        }
        if ((this.internal_style & 0x10000000) != 0) {
            nativeStyle |= 0x10000000;
        }
        return nativeStyle;
    }

    boolean isSingleSelect() {
        return (this.internal_style & 4) != 0;
    }

    boolean isMultiSelect() {
        return (this.internal_style & 2) != 0;
    }

    public void deselectAll() {
        this.checkWidget();
        if (this.isSingleSelect()) {
            TreeItem[] items = this.getSelection();
            if (items.length == 0) {
                return;
            }
            com.ibm.ugl.eswt.expanded.OS.TreeItem_SetSelected(items[0].internal_handle, false);
        } else {
            com.ibm.ugl.eswt.expanded.OS.Tree_SetAllSelected(this.internal_handle, false);
        }
    }

    public TreeItem getItem(Point point) {
        int itemId;
        this.checkWidget();
        if (point == null) {
            Tree.error(4);
        }
        if ((itemId = com.ibm.ugl.eswt.expanded.OS.Tree_GetItemAt(this.internal_handle, point.x, point.y)) == -1) {
            return null;
        }
        return this.treeItems[itemId];
    }

    public int getItemCount() {
        return this.getNumChildren();
    }

    public int getItemHeight() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Tree_GetItemHeight(this.internal_handle);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int size = this.getNumChildren();
        if (size == 0) {
            return new TreeItem[0];
        }
        TreeItem[] items = new TreeItem[size];
        System.arraycopy(this.children, 0, items, 0, size);
        return items;
    }

    TreeItem[] getTreeItems() {
        TreeItem[] treeItemsCopy = new TreeItem[this.treeItems.length];
        System.arraycopy(this.treeItems, 0, treeItemsCopy, 0, this.treeItems.length);
        return treeItemsCopy;
    }

    int getNumChildren() {
        int size = 0;
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            ++size;
        }
        return size;
    }

    void assignId(TreeItem item) {
        int id;
        for (id = 0; id < this.treeItems.length && this.treeItems[id] != null; ++id) {
        }
        if (id == this.treeItems.length) {
            TreeItem[] newItems = new TreeItem[this.treeItems.length + 4];
            System.arraycopy(this.treeItems, 0, newItems, 0, this.treeItems.length);
            this.treeItems = newItems;
        }
        this.treeItems[id] = item;
        item.id = id;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        if (this.isSingleSelect()) {
            int itemId = com.ibm.ugl.eswt.expanded.OS.Tree_GetSelectedItem(this.internal_handle);
            if (itemId == -1) {
                return new TreeItem[0];
            }
            return new TreeItem[]{this.treeItems[itemId]};
        }
        Vector<TreeItem> selectedItems = new Vector<TreeItem>();
        for (int i = 0; i < this.treeItems.length; ++i) {
            if (this.treeItems[i] == null || !com.ibm.ugl.eswt.expanded.OS.TreeItem_IsSelected(this.treeItems[i].internal_handle)) continue;
            selectedItems.add(this.treeItems[i]);
        }
        return selectedItems.toArray(new TreeItem[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.isSingleSelect()) {
            TreeItem[] items = this.getSelection();
            return items.length;
        }
        int count = 0;
        for (int i = 0; i < this.treeItems.length; ++i) {
            if (this.treeItems[i] == null || !com.ibm.ugl.eswt.expanded.OS.TreeItem_IsSelected(this.treeItems[i].internal_handle)) continue;
            ++count;
        }
        return count;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int itemId = com.ibm.ugl.eswt.expanded.OS.Tree_GetTopItem(this.internal_handle);
        if (itemId == -1) {
            return null;
        }
        return this.treeItems[itemId];
    }

    void itemDeleted(TreeItem item) {
        this.treeItems[item.id] = null;
    }

    Point minimumSize() {
        int width = 0;
        int height = 0;
        int[] pointArray = OS.Control_GetMinimumSize(this.internal_handle);
        width = pointArray[0];
        height = pointArray[1];
        return new Point(width, height);
    }

    void releaseWidget() {
        for (int i = 0; i < this.treeItems.length; ++i) {
            TreeItem item = this.treeItems[i];
            if (item == null || item.isDisposed()) continue;
            item.remove();
        }
        super.releaseWidget();
    }

    public void removeAll() {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Tree_RemoveAll(this.internal_handle);
        for (int i = 0; i < this.treeItems.length; ++i) {
            TreeItem item = this.treeItems[i];
            if (item == null) continue;
            item.remove();
        }
        this.treeItems = new TreeItem[4];
        this.children = new TreeItem[4];
        idCounter = 0;
    }

    void removeChild(TreeItem item) {
        int childIndex = -1;
        int numChildren = this.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            if (this.children[i] != item) continue;
            childIndex = i;
            break;
        }
        if (childIndex == -1) {
            return;
        }
        int size = this.children.length;
        TreeItem[] newItems = new TreeItem[size];
        System.arraycopy(this.children, 0, newItems, 0, childIndex);
        System.arraycopy(this.children, childIndex + 1, newItems, childIndex, size - (childIndex + 1));
        this.children = newItems;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if (this.isSingleSelect()) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Tree_SetAllSelected(this.internal_handle, true);
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            Tree.error(4);
        }
        if (items.length == 0 || this.isSingleSelect() && items.length > 1) {
            this.deselectAll();
            return;
        }
        if (items.length > 0) {
            com.ibm.ugl.eswt.expanded.OS.Tree_SetFocusItem(this.internal_handle, items[0].internal_handle);
        }
        for (int i = 0; i < this.treeItems.length; ++i) {
            TreeItem currentItem = this.treeItems[i];
            if (currentItem == null) continue;
            boolean selectItem = false;
            for (int j = 0; j < items.length; ++j) {
                if (items[j] != currentItem) continue;
                selectItem = true;
                break;
            }
            boolean itemSelected = com.ibm.ugl.eswt.expanded.OS.TreeItem_IsSelected(currentItem.internal_handle);
            if (selectItem) {
                if (itemSelected) continue;
                com.ibm.ugl.eswt.expanded.OS.TreeItem_SetSelected(currentItem.internal_handle, true);
                continue;
            }
            if (!itemSelected) continue;
            com.ibm.ugl.eswt.expanded.OS.TreeItem_SetSelected(currentItem.internal_handle, false);
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        com.ibm.ugl.eswt.expanded.OS.Tree_SetTopItem(this.internal_handle, item.internal_handle);
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        com.ibm.ugl.eswt.expanded.OS.Tree_ShowItem(this.internal_handle, item.internal_handle);
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem itemToShow = null;
        if (this.isSingleSelect()) {
            TreeItem[] selected = this.getSelection();
            if (selected.length == 0) {
                return;
            }
            itemToShow = selected[0];
        } else {
            int id = com.ibm.ugl.eswt.expanded.OS.Tree_GetFocusItem(this.internal_handle);
            if (id != -1) {
                TreeItem item = this.treeItems[id];
                if (com.ibm.ugl.eswt.expanded.OS.TreeItem_IsSelected(item.internal_handle)) {
                    itemToShow = item;
                }
            }
            if (itemToShow == null) {
                TreeItem[] selected = this.getSelection();
                if (selected.length == 0) {
                    return;
                }
                itemToShow = selected[0];
            }
        }
        if (itemToShow != null) {
            this.showItem(itemToShow);
        }
    }

    public void setItemCount(int count) {
        int index;
        this.checkWidget();
        if (!this.isVirtual) {
            return;
        }
        int itemCount = this.itemCount;
        if (count == itemCount) {
            return;
        }
        for (index = count; index < itemCount; ++index) {
            TreeItem item = this.children[index];
            if (item == null || item.isDisposed()) continue;
            item.dispose();
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TreeItem[] newItems = new TreeItem[length];
        System.arraycopy(this.children, 0, newItems, 0, Math.min(count, itemCount));
        this.children = newItems;
        for (index = this.itemCount; index < count; ++index) {
            this.children[index] = new TreeItem(this, 2048);
        }
        this.itemCount = count;
    }

    int indexOf(TreeItem item) {
        int idx = -1;
        for (int i = 0; i < this.children.length && idx == -1; ++i) {
            if (this.children[i] == null) continue;
            TreeItem child = this.children[i];
            if (child.id == item.id) {
                return i;
            }
            idx = child.indexOf(item);
        }
        return idx;
    }

    private void treeCallback(int itemId, int detail, int type) {
        Event event = new Event();
        event.item = itemId != -1 ? this.treeItems[itemId] : null;
        switch (type) {
            case 1: {
                if (detail != 0) {
                    event.detail = 32;
                }
                this.postEvent(13, event);
                break;
            }
            case 2: {
                if (detail != 0) {
                    event.detail = 32;
                }
                this.postEvent(14, event);
                break;
            }
            case 3: {
                this.sendEvent(18, event);
                break;
            }
            case 4: {
                if (this.isVirtual && this.treeItems[itemId] != null) {
                    this.treeItems[itemId].createRemainItem();
                }
                this.sendEvent(17, event);
                break;
            }
            case 5: {
                if (this.treeItems[itemId].getText() != null && !this.treeItems[itemId].getText().equals("")) break;
                event.index = this.indexOf(this.treeItems[itemId]);
                if (event.index == -1) break;
                this.sendEvent(36, event);
            }
        }
    }

    boolean isTrueComposite() {
        return false;
    }

    private TreeItem getFirstRootTreeItem() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    private TreeItem getLastRootTreeItem() {
        for (int i = this.children.length - 1; i >= 0; --i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    private boolean isExpandedLastNode(TreeItem root, TreeItem focusItem) {
        if (root == null || focusItem == null) {
            return false;
        }
        TreeItem lastNode = root;
        while (lastNode.getExpanded()) {
            TreeItem item = null;
            TreeItem[] items = lastNode.getItems();
            for (int i = items.length - 1; i >= 0; --i) {
                if (items[i] == null) continue;
                item = items[i];
                break;
            }
            if (item == null) break;
            lastNode = item;
        }
        return lastNode == focusItem;
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: {
                int focus = com.ibm.ugl.eswt.expanded.OS.Tree_GetFocusItem(this.internal_handle);
                if (focus == -1) {
                    return true;
                }
                if (focus >= this.treeItems.length) {
                    return false;
                }
                TreeItem first = this.getFirstRootTreeItem();
                if (this.treeItems[focus] != null && this.treeItems[focus] != first) break;
                return true;
            }
            case 0x1000002: {
                int focus = com.ibm.ugl.eswt.expanded.OS.Tree_GetFocusItem(this.internal_handle);
                if (focus == -1) {
                    return this.getNumChildren() == 0;
                }
                if (focus >= this.treeItems.length) {
                    return false;
                }
                TreeItem last = this.getLastRootTreeItem();
                if (!this.isExpandedLastNode(last, this.treeItems[focus])) break;
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

