/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.BitSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.util.Util;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference {
    protected IWorkbenchPart part;
    private String id;
    protected PartPane pane;
    private String title;
    private String tooltip;
    private Image image;
    private ImageDescriptor imageDescriptor;
    private ListenerList propChangeListeners = new ListenerList(2);
    private String partName;
    private String contentDescription;
    private BitSet queuedEvents = new BitSet();
    private boolean queueEvents = false;
    private IPropertyListener propertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object object, int n) {
            WorkbenchPartReference.this.partPropertyChanged(object, n);
        }
    };

    private void deferEvents(boolean bl) {
        this.queueEvents = bl;
        if (!this.queueEvents) {
            int n = 0;
            while (n < this.queuedEvents.length()) {
                if (this.queuedEvents.get(n)) {
                    this.firePropertyChange(n);
                    this.queuedEvents.clear(n);
                }
                ++n;
            }
        }
    }

    protected void setTitle(String string) {
        if (Util.equals(this.title, string)) {
            return;
        }
        this.title = string;
        this.firePropertyChange(1);
    }

    protected void setPartName(String string) {
        if (Util.equals(this.partName, string)) {
            return;
        }
        this.partName = string;
        this.firePropertyChange(260);
    }

    protected void setContentDescription(String string) {
        if (Util.equals(this.contentDescription, string)) {
            return;
        }
        this.contentDescription = string;
        this.firePropertyChange(261);
    }

    protected void setToolTip(String string) {
        if (Util.equals(this.tooltip, string)) {
            return;
        }
        this.tooltip = string;
        this.firePropertyChange(1);
    }

    protected void partPropertyChanged(Object object, int n) {
        if (n == 261 || n == 260 || n == 1) {
            this.refreshFromPart();
        } else {
            this.firePropertyChange(n);
        }
    }

    protected void refreshFromPart() {
        this.deferEvents(true);
        this.setPartName(this.computePartName());
        this.setTitle(this.computeTitle());
        this.setContentDescription(this.computeContentDescription());
        this.setToolTip(this.getRawToolTip());
        if (!Util.equals(this.image, this.part.getTitleImage())) {
            this.firePropertyChange(1);
        }
        this.deferEvents(false);
    }

    public void init(String string, String string2, String string3, ImageDescriptor imageDescriptor, String string4, String string5) {
        this.id = string;
        this.title = string2;
        this.tooltip = string3;
        this.imageDescriptor = imageDescriptor;
        this.partName = string4;
        this.contentDescription = string5;
    }

    public void releaseReferences() {
        this.id = null;
        if (this.image != null && this.imageDescriptor != null) {
            if (this.part != null) {
                this.part.getTitleImage();
            }
            ReferenceCounter referenceCounter = WorkbenchImages.getImageCache();
            this.image = (Image)referenceCounter.get(this.imageDescriptor);
            if (this.image != null) {
                referenceCounter.removeRef(this.imageDescriptor);
            }
            this.image = null;
            this.imageDescriptor = null;
        }
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.propChangeListeners.add((Object)iPropertyListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.propChangeListeners.remove((Object)iPropertyListener);
    }

    public String getId() {
        IWorkbenchPartSite iWorkbenchPartSite;
        if (this.part != null && (iWorkbenchPartSite = this.part.getSite()) != null) {
            return iWorkbenchPartSite.getId();
        }
        return Util.safeString(this.id);
    }

    public String getTitleToolTip() {
        return Util.safeString(this.tooltip);
    }

    protected final String getRawToolTip() {
        return Util.safeString(this.part.getTitleToolTip());
    }

    public String getPartName() {
        return Util.safeString(this.partName);
    }

    protected final String getRawPartName() {
        String string = "";
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 iWorkbenchPart2 = (IWorkbenchPart2)this.part;
            string = Util.safeString(iWorkbenchPart2.getPartName());
        }
        return string;
    }

    protected String computePartName() {
        return this.getRawPartName();
    }

    public String getContentDescription() {
        return Util.safeString(this.contentDescription);
    }

    protected String computeContentDescription() {
        return this.getRawContentDescription();
    }

    protected final String getRawContentDescription() {
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 iWorkbenchPart2 = (IWorkbenchPart2)this.part;
            return iWorkbenchPart2.getContentDescription();
        }
        return "";
    }

    public boolean isDirty() {
        return false;
    }

    public String getTitle() {
        return Util.safeString(this.title);
    }

    protected String computeTitle() {
        return this.getRawTitle();
    }

    protected final String getRawTitle() {
        return Util.safeString(this.part.getTitle());
    }

    public Image getTitleImage() {
        if (this.part != null) {
            return this.part.getTitleImage();
        }
        if (this.image != null) {
            return this.image;
        }
        if (this.imageDescriptor == null) {
            return null;
        }
        ReferenceCounter referenceCounter = WorkbenchImages.getImageCache();
        this.image = (Image)referenceCounter.get(this.imageDescriptor);
        if (this.image != null) {
            referenceCounter.addRef(this.imageDescriptor);
            return this.image;
        }
        this.image = this.imageDescriptor.createImage();
        referenceCounter.put(this.imageDescriptor, this.image);
        return this.image;
    }

    private void firePropertyChange(int n) {
        if (this.queueEvents) {
            this.queuedEvents.set(n);
            return;
        }
        Object[] objectArray = this.propChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPropertyListener)objectArray[n2]).propertyChanged(this.part, n);
            ++n2;
        }
    }

    public void setPart(IWorkbenchPart iWorkbenchPart) {
        this.part = iWorkbenchPart;
        if (iWorkbenchPart == null) {
            return;
        }
        iWorkbenchPart.addPropertyListener(this.propertyChangeListener);
    }

    protected abstract PartPane createPane();

    public PartPane getPane() {
        if (this.pane == null) {
            this.pane = this.createPane();
        }
        return this.pane;
    }

    public void dispose() {
        this.propChangeListeners.clear();
        if (this.image != null && this.imageDescriptor != null) {
            int n;
            ReferenceCounter referenceCounter = WorkbenchImages.getImageCache();
            if (this.image != null && (n = referenceCounter.removeRef(this.imageDescriptor)) <= 0) {
                this.image.dispose();
            }
            this.imageDescriptor = null;
            this.image = null;
        }
        if (this.part != null) {
            this.part.removePropertyListener(this.propertyChangeListener);
            this.part.dispose();
        }
        this.part = null;
    }
}

