/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class VersionedIdentifier {
    private String id;
    private PluginVersionIdentifier version;
    private static final String SEPARATOR = "_";

    public VersionedIdentifier(String string, String string2) {
        if (string == null || (string = string.trim()).equals("")) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.VersionedIdentifier_IdOrVersionNull, (Object[])new String[]{string, string2}));
        }
        this.id = string;
        if (string2 != null) {
            try {
                this.version = new PluginVersionIdentifier(string2);
            }
            catch (RuntimeException runtimeException) {
                UpdateCore.warn("Invalid Version:" + string2, runtimeException);
            }
        }
        if (this.version == null) {
            this.version = new PluginVersionIdentifier(0, 0, 0);
        }
    }

    public String getIdentifier() {
        return this.id;
    }

    public PluginVersionIdentifier getVersion() {
        return this.version;
    }

    public String toString() {
        return this.id.equals("") ? "" : String.valueOf(this.id) + SEPARATOR + this.version.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof VersionedIdentifier)) {
            return false;
        }
        VersionedIdentifier versionedIdentifier = (VersionedIdentifier)object;
        if (!this.id.equals(versionedIdentifier.id)) {
            return false;
        }
        return this.version.equals((Object)versionedIdentifier.version);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

