/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.URLEntryModel;

public class CategoryModel
extends ModelObject {
    private String name;
    private String label;
    private String localizedLabel;
    private URLEntryModel description;
    private static Comparator comp;

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public void setLabel(String string) {
        this.assertIsWriteable();
        this.label = string;
        this.localizedLabel = null;
    }

    public void setName(String string) {
        this.assertIsWriteable();
        this.name = string;
    }

    public void setDescriptionModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.description = uRLEntryModel;
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.localizedLabel = this.resolveNLString(uRL2, this.label);
        this.resolveReference(this.getDescriptionModel(), uRL, uRL2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CategoryModel) {
            CategoryModel categoryModel = (CategoryModel)((Object)object);
            bl = this.getName().equalsIgnoreCase(categoryModel.getName());
        }
        return bl;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static Comparator getComparator() {
        if (comp == null) {
            comp = new Comparator(){

                public int compare(Object object, Object object2) {
                    CategoryModel categoryModel = (CategoryModel)((Object)object);
                    CategoryModel categoryModel2 = (CategoryModel)((Object)object2);
                    if (categoryModel.equals((Object)categoryModel2)) {
                        return 0;
                    }
                    return categoryModel.getName().compareTo(categoryModel2.getName());
                }
            };
        }
        return comp;
    }

    protected String getPropertyName() {
        return "site";
    }
}

