/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IRevertConfigurationOperation;
import org.eclipse.update.operations.OperationsManager;

public class RevertConfigurationOperation
extends Operation
implements IRevertConfigurationOperation {
    private IInstallConfiguration config;
    private IProblemHandler problemHandler;

    public RevertConfigurationOperation(IInstallConfiguration iInstallConfiguration, IProblemHandler iProblemHandler) {
        this.config = iInstallConfiguration;
        this.problemHandler = iProblemHandler;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException, InvocationTargetException {
        IStatus iStatus = OperationsManager.getValidator().validatePendingRevert(this.config);
        if (iStatus != null && iStatus.getCode() == 4) {
            throw new CoreException(iStatus);
        }
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            iLocalSite.revertTo(this.config, iProgressMonitor, this.problemHandler);
            iLocalSite.save();
            return true;
        }
        catch (CoreException coreException) {
            UpdateUtils.logException(coreException);
            throw coreException;
        }
    }
}

