/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.AndExpression;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.internal.expressions.EnablementExpression;
import org.eclipse.core.internal.expressions.EqualsExpression;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.OrExpression;
import org.eclipse.core.internal.expressions.ReferenceExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.internal.expressions.TestExpression;
import org.eclipse.core.internal.expressions.WithExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardElementHandler
extends ElementHandler {
    public Expression create(ExpressionConverter expressionConverter, IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getName();
        if ("instanceof".equals(string)) {
            return new InstanceofExpression(iConfigurationElement);
        }
        if ("test".equals(string)) {
            return new TestExpression(iConfigurationElement);
        }
        if ("or".equals(string)) {
            OrExpression orExpression = new OrExpression();
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)orExpression);
            return orExpression;
        }
        if ("and".equals(string)) {
            AndExpression andExpression = new AndExpression();
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)andExpression);
            return andExpression;
        }
        if ("not".equals(string)) {
            return new NotExpression(expressionConverter.perform(iConfigurationElement.getChildren()[0]));
        }
        if ("with".equals(string)) {
            WithExpression withExpression = new WithExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)withExpression);
            return withExpression;
        }
        if ("adapt".equals(string)) {
            AdaptExpression adaptExpression = new AdaptExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)adaptExpression);
            return adaptExpression;
        }
        if ("iterate".equals(string)) {
            IterateExpression iterateExpression = new IterateExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)iterateExpression);
            return iterateExpression;
        }
        if ("count".equals(string)) {
            return new CountExpression(iConfigurationElement);
        }
        if ("systemTest".equals(string)) {
            return new SystemTestExpression(iConfigurationElement);
        }
        if ("resolve".equals(string)) {
            ResolveExpression resolveExpression = new ResolveExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)resolveExpression);
            return resolveExpression;
        }
        if ("enablement".equals(string)) {
            EnablementExpression enablementExpression = new EnablementExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, (CompositeExpression)enablementExpression);
            return enablementExpression;
        }
        if ("equals".equals(string)) {
            return new EqualsExpression(iConfigurationElement);
        }
        if ("reference".equals(string)) {
            return new ReferenceExpression(iConfigurationElement);
        }
        return null;
    }

    public Expression create(ExpressionConverter expressionConverter, Element element) throws CoreException {
        String string = element.getNodeName();
        if ("instanceof".equals(string)) {
            return new InstanceofExpression(element);
        }
        if ("test".equals(string)) {
            return new TestExpression(element);
        }
        if ("or".equals(string)) {
            OrExpression orExpression = new OrExpression();
            this.processChildren(expressionConverter, element, (CompositeExpression)orExpression);
            return orExpression;
        }
        if ("and".equals(string)) {
            AndExpression andExpression = new AndExpression();
            this.processChildren(expressionConverter, element, (CompositeExpression)andExpression);
            return andExpression;
        }
        if ("not".equals(string)) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    return new NotExpression(expressionConverter.perform((Element)node));
                }
                node = node.getNextSibling();
            }
        } else {
            if ("with".equals(string)) {
                WithExpression withExpression = new WithExpression(element);
                this.processChildren(expressionConverter, element, (CompositeExpression)withExpression);
                return withExpression;
            }
            if ("adapt".equals(string)) {
                AdaptExpression adaptExpression = new AdaptExpression(element);
                this.processChildren(expressionConverter, element, (CompositeExpression)adaptExpression);
                return adaptExpression;
            }
            if ("iterate".equals(string)) {
                IterateExpression iterateExpression = new IterateExpression(element);
                this.processChildren(expressionConverter, element, (CompositeExpression)iterateExpression);
                return iterateExpression;
            }
            if ("count".equals(string)) {
                return new CountExpression(element);
            }
            if ("systemTest".equals(string)) {
                return new SystemTestExpression(element);
            }
            if ("resolve".equals(string)) {
                ResolveExpression resolveExpression = new ResolveExpression(element);
                this.processChildren(expressionConverter, element, (CompositeExpression)resolveExpression);
                return resolveExpression;
            }
            if ("enablement".equals(string)) {
                EnablementExpression enablementExpression = new EnablementExpression(element);
                this.processChildren(expressionConverter, element, (CompositeExpression)enablementExpression);
                return enablementExpression;
            }
            if ("equals".equals(string)) {
                return new EqualsExpression(element);
            }
            if ("reference".equals(string)) {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }
}

