/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PreferenceDialog
extends MultiPageDialog
implements IPreferencePageContainer {
    protected PreferenceManager preferenceManager;
    private Command okCommand = null;
    private Command cancelCommand = null;
    private boolean bDialogClose;
    private IPreferenceNode currentOpenNode = null;
    private static String lastPreferenceId = null;
    private IPreferenceStore preferenceStore;

    public PreferenceDialog(Shell parentShell) {
        super(parentShell, 131072);
    }

    public PreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, 131072);
        this.preferenceManager = manager;
    }

    protected void checkSubclass() {
    }

    protected Control createContents(PreferenceDialog parent) {
        Composite parentDialog = null;
        Iterator iterator = this.preferenceManager.getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceNode next = (IPreferenceNode)iterator.next();
            parentDialog = this.createPage(next);
        }
        return parentDialog;
    }

    protected Composite createSubPages(IPreferenceNode node) {
        Composite control = this.createPage(node);
        IPreferenceNode[] subnodes = node.getSubNodes();
        if (subnodes != null) {
            int i = 0;
            while (i < subnodes.length) {
                control = this.createSubPages(subnodes[i]);
                ++i;
            }
        }
        return control;
    }

    protected Composite createPage(IPreferenceNode node) {
        Composite control = null;
        this.currentOpenNode = node;
        PreferencePage page = (PreferencePage)node.getPage();
        if (page == null) {
            node.createPage();
            page = (PreferencePage)node.getPage();
        }
        if (page != null) {
            page.setContainer(this);
            Composite mpdPage = this.createPage(page.getTitle(), page.getImage());
            this.createPageControl(page, mpdPage);
            control = mpdPage.getParent();
        }
        return control;
    }

    protected void createPageControl(PreferencePage page, Composite parent) {
        page.createControl(parent);
    }

    public void open() {
        this.setText(JFaceResources.getString("PreferenceDialog.title"));
        Control c = this.createContents(this);
        this.createCommands(c);
        this.bDialogClose = true;
        super.open();
        if (this.bDialogClose) {
            this.okPressed();
        }
    }

    public void close() {
        if (this.okCommand != null) {
            this.okCommand.dispose();
            this.okCommand = null;
        }
        if (this.cancelCommand != null) {
            this.cancelCommand.dispose();
            this.cancelCommand = null;
        }
        if (!this.bDialogClose) {
            super.close();
        }
    }

    private void createCommands(Control c) {
        this.okCommand = new Command(c, 3, 1);
        this.okCommand.setText(JFaceResources.getString("ok"));
        this.okCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.okPressed();
            }
        });
        this.cancelCommand = new Command(c, 4, 1);
        this.cancelCommand.setText(JFaceResources.getString("cancel"));
        this.cancelCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.cancelPressed();
            }
        });
    }

    protected void okPressed() {
        SafeRunnable.run(new SafeRunnable(){
            private boolean errorOccurred;

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block15: {
                    block16: {
                        this.errorOccurred = false;
                        hasFailedOK = false;
                        try {
                            try {
                                page = (PreferencePage)PreferenceDialog.access$3(PreferenceDialog.this).getPage();
                                if (page == null || page.performOk()) break block15;
                                hasFailedOK = true;
                                var3_4 = null;
                                if (!hasFailedOK && !this.errorOccurred) {
                                    PreferenceDialog.this.handleSave();
                                }
                                if (hasFailedOK) {
                                    break block16;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception e) {
                                this.errorOccurred = true;
                                this.handleException(e);
                                break block15;
                            }
                        }
                        catch (Throwable var4_7) {
                            var3_5 = null;
                            if (!hasFailedOK && !this.errorOccurred) {
                                PreferenceDialog.this.handleSave();
                            }
                            if (!hasFailedOK || PreferenceDialog.access$1(PreferenceDialog.this)) {
                                PreferenceDialog.this.close();
                            } else {
                                PreferenceDialog.access$0(PreferenceDialog.this, true);
                            }
                            PreferenceDialog.access$2(PreferenceDialog.this, null);
                            throw var4_7;
                        }
                    }
                    if (PreferenceDialog.access$1(PreferenceDialog.this)) lbl-1000:
                    // 2 sources

                    {
                        PreferenceDialog.this.close();
                    } else {
                        PreferenceDialog.access$0(PreferenceDialog.this, true);
                    }
                    PreferenceDialog.access$2(PreferenceDialog.this, null);
                    return;
                }
                var3_6 = null;
                if (!hasFailedOK && !this.errorOccurred) {
                    PreferenceDialog.this.handleSave();
                }
                if (!hasFailedOK || PreferenceDialog.access$1(PreferenceDialog.this)) {
                    PreferenceDialog.this.close();
                } else {
                    PreferenceDialog.access$0(PreferenceDialog.this, true);
                }
                PreferenceDialog.access$2(PreferenceDialog.this, null);
            }
        });
    }

    protected void cancelPressed() {
        SafeRunnable.run(new SafeRunnable(){

            public void run() {
                PreferencePage page = (PreferencePage)PreferenceDialog.this.currentOpenNode.getPage();
                if (page != null && !page.performCancel()) {
                    return;
                }
                PreferenceDialog.this.close();
            }
        });
    }

    public void setPreferenceStore(IPreferenceStore store) {
        Assert.isNotNull(store);
        this.preferenceStore = store;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void updateButtons() {
        System.out.println("PreferenceDialog: updateButtons not impl");
    }

    public void updateMessage() {
        System.out.println("PreferenceDialog: updateMessage not impl");
    }

    public void updateTitle() {
        System.out.println("PreferenceDialog: updateTitle not impl");
    }

    protected void handleSave() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceStore store;
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (!(page instanceof PreferencePage) || (store = ((PreferencePage)page).getPreferenceStore()) == null || !store.needsSaving() || !(store instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                MessageBox mb = new MessageBox(null, 1);
                mb.setText(JFaceResources.getString("PreferenceDialog.saveErrorTitle"));
                mb.setMessage(JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{page.getTitle(), e.getMessage()}));
                mb.open();
            }
        }
    }

    public void setSelectedNode(String pageId) {
        lastPreferenceId = pageId;
    }

    static /* synthetic */ boolean access$1(PreferenceDialog preferenceDialog) {
        return preferenceDialog.bDialogClose;
    }

    static /* synthetic */ void access$2(PreferenceDialog preferenceDialog, IPreferenceNode iPreferenceNode) {
        preferenceDialog.currentOpenNode = iPreferenceNode;
    }
}

