/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class PartPane
extends LayoutPart
implements Listener {
    protected PresentablePart presentableAdapter = new PresentablePart(this);
    public static final String PROP_ZOOMED = "zoomed";
    private boolean isZoomed = false;
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected Composite control;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            LayoutPart parent;
            Control parentControl;
            ILayoutContainer container;
            if ((e.detail == 512 || e.detail == 256) && (container = PartPane.this.getContainer()) != null && container instanceof LayoutPart && (parentControl = (parent = (LayoutPart)((Object)container)).getControl()) != null && !parentControl.isDisposed()) {
                parentControl.traverse(e.detail);
                e.doit = false;
            }
        }
    };

    public PartPane(IWorkbenchPartReference partReference, WorkbenchPage workbenchPage) {
        super(partReference.getId());
        this.partReference = partReference;
        this.page = workbenchPage;
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null) {
            return;
        }
        this.control = new Composite(parent, 524288);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setVisible(false);
        this.createTitleBar();
        this.control.addListener(26, (Listener)this);
        this.control.addTraverseListener(this.traverseListener);
    }

    protected abstract void createTitleBar();

    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control.removeTraverseListener(this.traverseListener);
            this.control.dispose();
            this.control = null;
        }
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.isDocked()) {
            this.page.toggleZoom(this.partReference);
        }
    }

    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    public Control getControl() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void moveAbove(Control refControl) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(refControl);
        }
    }

    protected void requestActivation() {
        IWorkbenchPart part = this.partReference.getPart(true);
        this.page.requestActivation(part);
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible) {
            this.partReference.getPart(true);
        }
        super.setVisible(makeVisible);
    }

    public void setFocus() {
        this.requestActivation();
        IWorkbenchPart part = this.partReference.getPart(true);
        if (part != null) {
            part.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    public void setZoomed(boolean isZoomed) {
        if (this.isZoomed == isZoomed) {
            return;
        }
        super.setZoomed(isZoomed);
        this.isZoomed = isZoomed;
        Object[] listeners = this.getPropertyListeners().getListeners();
        if (listeners.length > 0) {
            Boolean oldValue = isZoomed ? Boolean.FALSE : Boolean.TRUE;
            Boolean zoomed = isZoomed ? Boolean.TRUE : Boolean.FALSE;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROP_ZOOMED, (Object)oldValue, (Object)zoomed);
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    public PartStack getStack() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartStack) {
            return (PartStack)container;
        }
        return null;
    }

    public void showPaneMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showSystemMenu();
        }
    }

    public void showViewMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showPaneMenu();
        }
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void doDock() {
    }

    public void setBusy(boolean isBusy) {
    }

    public void showHighlight() {
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
    }

    public abstract Control getToolBar();

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point location) {
    }

    public boolean isBusy() {
        return false;
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }

    public abstract boolean isCloseable();

    public static class Sashes {
        public Composite left;
        public Composite right;
        public Composite top;
        public Composite bottom;
    }
}

