/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private Map activationsBySubmission = null;
    private final IHandlerService handlerService;

    public WorkbenchCommandSupport(CommandManager commandManager, ContextManager contextManager, IHandlerService handlerService) {
        if (handlerService == null) {
            throw new NullPointerException("The handler service cannot be null");
        }
        this.handlerService = handlerService;
    }

    public final void addHandlerSubmission(HandlerSubmission handlerSubmission) {
    }

    public final void addHandlerSubmissions(Collection handlerSubmissions) {
        Iterator submissionItr = handlerSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.addHandlerSubmission((HandlerSubmission)submissionItr.next());
        }
    }

    public CommandManager getCommandManager() {
        return null;
    }

    public final void removeHandlerSubmission(HandlerSubmission handlerSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        Object value = this.activationsBySubmission.remove(handlerSubmission);
        if (value instanceof IHandlerActivation) {
            IHandlerActivation activation = (IHandlerActivation)value;
            this.handlerService.deactivateHandler(activation);
        }
    }

    public final void removeHandlerSubmissions(Collection handlerSubmissions) {
        Iterator submissionItr = handlerSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.removeHandlerSubmission((HandlerSubmission)submissionItr.next());
        }
    }
}

