/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Date;
import java.util.GregorianCalendar;

public class CalendarDataBaseEntry {
    private Date startdate;
    private Date enddate;
    private String location;
    private String description;
    private String notes;

    public CalendarDataBaseEntry(Date startdate, Date enddate, String description, String location, String notes) {
        this.startdate = startdate;
        this.enddate = enddate;
        this.description = description;
        this.location = location;
        this.notes = notes;
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (Throwable throwable) {}
        return new CalendarDataBaseEntry(this.startdate, this.enddate, this.description, this.location, this.notes);
    }

    public Date getStartDate() {
        if (this.startdate == null) {
            System.out.println("startdate is null, returning cur date");
            return new Date();
        }
        return this.startdate;
    }

    public Date getEndDate() {
        if (this.enddate == null) {
            System.out.println("enddate is null, returning cur date");
            return new Date();
        }
        return this.enddate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setStartDate(Date date) {
        this.startdate = date;
    }

    public void setEndDate(Date date) {
        this.enddate = date;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String toString() {
        String result = this.buildStartOfToString();
        result = String.valueOf(result) + this.buildEnfOfToString();
        return result;
    }

    private String buildStartOfToString() {
        String result = "";
        if (this.startdate != null) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(this.startdate);
            Integer h = new Integer(g.get(11));
            result = String.valueOf(result) + h.toString();
            result = String.valueOf(result) + ":";
            Integer m = new Integer(g.get(12));
            if (m < 10) {
                result = String.valueOf(result) + "0";
            }
            result = String.valueOf(result) + m.toString();
            if (this.enddate != null) {
                result = String.valueOf(result) + "-";
            }
        }
        return result;
    }

    private String buildEnfOfToString() {
        String result = "";
        if (this.description != null) {
            result = String.valueOf(result) + " " + this.description;
        }
        if (this.location != null) {
            result = String.valueOf(result) + " @(" + this.location + ")";
        }
        return result;
    }

    public String toStringLarge() {
        String result = this.buildStartOfToString();
        if (this.enddate != null) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(this.enddate);
            Integer h = new Integer(g.get(11));
            result = String.valueOf(result) + h.toString();
            result = String.valueOf(result) + ":";
            Integer m = new Integer(g.get(12));
            if (m < 10) {
                result = String.valueOf(result) + "0";
            }
            result = String.valueOf(result) + m.toString();
        }
        result = String.valueOf(result) + this.buildEnfOfToString();
        return result;
    }
}

