/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrolledComposite
extends Composite {
    private Control content;
    private Listener contentListener;
    private int minHeight = 0;
    private int minWidth = 0;
    private boolean expandHorizontal = false;
    private boolean expandVertical = false;
    private boolean alwaysShowScroll = false;
    private boolean inResize = false;
    private boolean autoScrollIsActive = false;
    FocusListener focusListenerToScroll = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (!ScrolledComposite.this.autoScrollIsActive) {
                return;
            }
            Control focusedControl = (Control)e.widget;
            while (focusedControl.getParent() != ScrolledComposite.this.content) {
                if ((focusedControl = focusedControl.getParent()) != null) continue;
                return;
            }
            Point controlPosition = ScrolledComposite.this.getContent().toDisplay(focusedControl.getLocation());
            controlPosition = ScrolledComposite.this.getContent().toControl(controlPosition);
            Rectangle viewArea = new Rectangle(-((ScrolledComposite)ScrolledComposite.this).content.getLocation().x, -((ScrolledComposite)ScrolledComposite.this).content.getLocation().y, ScrolledComposite.this.getClientArea().width, ScrolledComposite.this.getClientArea().height);
            Rectangle boundsFocusedControl = new Rectangle(controlPosition.x, controlPosition.y, focusedControl.getBounds().width, focusedControl.getBounds().height);
            if (!viewArea.intersection(boundsFocusedControl).equals((Object)boundsFocusedControl)) {
                ScrollBar hBar;
                Point movingNeed = ScrolledComposite.this.getNeedMoving(viewArea, boundsFocusedControl);
                Point location = new Point(((ScrolledComposite)ScrolledComposite.this).content.getLocation().x + movingNeed.x, ((ScrolledComposite)ScrolledComposite.this).content.getLocation().y + movingNeed.y);
                ScrollBar vBar = ScrolledComposite.this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(-location.y);
                }
                if ((hBar = ScrolledComposite.this.getHorizontalBar()) != null) {
                    hBar.setSelection(-location.x);
                }
                ScrolledComposite.this.content.setLocation(location.x, location.y);
                ScrolledComposite.this.redraw();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };
    static /* synthetic */ Class class$0;

    public ScrolledComposite(Composite parent, int style) {
        super(parent, ScrolledComposite.checkStyle(style));
        ScrollBar vBar;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setIncrement(50);
            hBar.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ScrolledComposite.this.hScroll();
                }
            });
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.setIncrement(50);
            vBar.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ScrolledComposite.this.vScroll();
                }
            });
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ScrolledComposite.this.resize();
            }
        });
        this.contentListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type != 11) {
                    return;
                }
                ScrolledComposite.this.resize();
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 0x6000B00;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.content == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        Point size = this.content.computeSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public boolean getAlwaysShowScrollBars() {
        return this.alwaysShowScroll;
    }

    public Control getContent() {
        return this.content;
    }

    void hScroll() {
        if (this.content == null) {
            return;
        }
        Point location = this.content.getLocation();
        ScrollBar hBar = this.getHorizontalBar();
        int hSelection = hBar.getSelection();
        this.content.setLocation(-hSelection, location.y);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.content == null) {
            return;
        }
        Rectangle contentRect = this.content.getBounds();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        boolean hVisible = false;
        boolean vVisible = false;
        if (!this.alwaysShowScroll) {
            hVisible = this.needHScroll(contentRect, false);
            vVisible = this.needVScroll(contentRect, hVisible);
            if (!hVisible && vVisible) {
                hVisible = this.needHScroll(contentRect, vVisible);
            }
            if (hBar != null) {
                hBar.setVisible(hVisible);
            }
            if (vBar != null) {
                vBar.setVisible(vVisible);
            }
        } else {
            hVisible = true;
            vVisible = true;
        }
        Rectangle hostRect = this.getHostRectangle(hVisible, vVisible);
        if (this.expandHorizontal) {
            contentRect.width = Math.max(this.minWidth, hostRect.width);
        }
        if (this.expandVertical) {
            contentRect.height = Math.max(this.minHeight, hostRect.height);
        }
        if (hBar != null) {
            hBar.setMaximum(contentRect.width);
            hBar.setThumb(Math.min(contentRect.width, hostRect.width));
            int hPage = contentRect.width - hostRect.width;
            int hSelection = hBar.getSelection();
            if (hSelection >= hPage) {
                if (hPage <= 0) {
                    hSelection = 0;
                    hBar.setSelection(0);
                }
                contentRect.x = -hSelection;
            }
        }
        if (vBar != null) {
            vBar.setMaximum(contentRect.height);
            vBar.setThumb(Math.min(contentRect.height, hostRect.height));
            int vPage = contentRect.height - hostRect.height;
            int vSelection = vBar.getSelection();
            if (vSelection >= vPage) {
                if (vPage <= 0) {
                    vSelection = 0;
                    vBar.setSelection(0);
                }
                contentRect.y = -vSelection;
            }
        }
        this.content.setBounds(contentRect);
    }

    private boolean needHScroll(Rectangle contentRect, boolean vVisible) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return false;
        }
        Rectangle hostRect = this.getHostRectangle(false, vVisible);
        if (!this.expandHorizontal && contentRect.width > hostRect.width) {
            return true;
        }
        return this.expandHorizontal && this.minWidth > hostRect.width;
    }

    private boolean needVScroll(Rectangle contentRect, boolean hVisible) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return false;
        }
        Rectangle hostRect = this.getHostRectangle(hVisible, false);
        if (!this.expandHorizontal && contentRect.height > hostRect.height) {
            return true;
        }
        return this.expandHorizontal && this.minHeight > hostRect.height;
    }

    private Rectangle getHostRectangle(boolean hVisible, boolean vVisible) {
        Rectangle hostRect = this.getBounds();
        int border = this.getBorderWidth();
        hostRect.height -= 2 * border;
        hostRect.width -= 2 * border;
        ScrollBar hBar = this.getHorizontalBar();
        if (hVisible && hBar != null) {
            hostRect.height -= hBar.getSize().y;
        }
        ScrollBar vBar = this.getVerticalBar();
        if (vVisible && vBar != null) {
            hostRect.width -= vBar.getSize().x;
        }
        return hostRect;
    }

    void resize() {
        if (this.inResize) {
            return;
        }
        this.inResize = true;
        this.layout();
        this.inResize = false;
    }

    public Point getOrigin() {
        this.checkWidget();
        if (this.content == null) {
            return new Point(0, 0);
        }
        Point location = this.content.getLocation();
        return new Point(-location.x, -location.y);
    }

    public void setOrigin(Point origin) {
        this.setOrigin(origin.x, origin.y);
    }

    public void setOrigin(int x, int y) {
        this.checkWidget();
        if (this.content == null) {
            return;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setSelection(x);
            x = -hBar.getSelection();
        } else {
            x = 0;
        }
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setSelection(y);
            y = -vBar.getSelection();
        } else {
            y = 0;
        }
        this.content.setLocation(x, y);
    }

    public void setAlwaysShowScrollBars(boolean show) {
        ScrollBar vBar;
        this.checkWidget();
        if (show == this.alwaysShowScroll) {
            return;
        }
        this.alwaysShowScroll = show;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null && this.alwaysShowScroll) {
            hBar.setVisible(true);
        }
        if ((vBar = this.getVerticalBar()) != null && this.alwaysShowScroll) {
            vBar.setVisible(true);
        }
        this.layout();
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeListener(11, this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = content;
        ScrollBar vBar = this.getVerticalBar();
        ScrollBar hBar = this.getHorizontalBar();
        if (this.content != null) {
            if (vBar != null) {
                vBar.setMaximum(0);
                vBar.setThumb(0);
                vBar.setSelection(0);
            }
            if (hBar != null) {
                hBar.setMaximum(0);
                hBar.setThumb(0);
                hBar.setSelection(0);
            }
            content.setLocation(0, 0);
            this.layout();
            this.content.addListener(11, this.contentListener);
        } else {
            if (hBar != null) {
                hBar.setVisible(this.alwaysShowScroll);
            }
            if (vBar != null) {
                vBar.setVisible(this.alwaysShowScroll);
            }
        }
    }

    public void setAutoScroll(boolean active) {
        this.autoScrollIsActive = active;
        if (this.autoScrollIsActive) {
            ScrolledComposite.addFocusListenerToAllChildren(this, this.focusListenerToScroll);
        }
    }

    boolean isAutoScrollActivate() {
        return this.autoScrollIsActive;
    }

    public void setExpandHorizontal(boolean expand) {
        this.checkWidget();
        if (expand == this.expandHorizontal) {
            return;
        }
        this.expandHorizontal = expand;
        this.layout();
    }

    public void setExpandVertical(boolean expand) {
        this.checkWidget();
        if (expand == this.expandVertical) {
            return;
        }
        this.expandVertical = expand;
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMinHeight(int height) {
        this.setMinSize(this.minWidth, height);
    }

    public void setMinSize(Point size) {
        if (size == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(size.x, size.y);
        }
    }

    public void setMinSize(int width, int height) {
        this.checkWidget();
        if (width == this.minWidth && height == this.minHeight) {
            return;
        }
        this.minWidth = Math.max(0, width);
        this.minHeight = Math.max(0, height);
        this.layout();
    }

    public void setMinWidth(int width) {
        this.setMinSize(width, this.minHeight);
    }

    void vScroll() {
        if (this.content == null) {
            return;
        }
        Point location = this.content.getLocation();
        ScrollBar vBar = this.getVerticalBar();
        int vSelection = vBar.getSelection();
        this.content.setLocation(location.x, -vSelection);
    }

    static void addFocusListenerToAllChildren(Composite parent, FocusListener listener) {
        if (parent != null) {
            parent.addFocusListener(listener);
            Control[] childrens = parent.getChildren();
            if (childrens == null) {
                return;
            }
            int i = 0;
            while (i < childrens.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(childrens[i].getClass())) {
                    ScrolledComposite.addFocusListenerToAllChildren((Composite)childrens[i], listener);
                } else {
                    childrens[i].addFocusListener(listener);
                }
                ++i;
            }
        }
    }

    private Point getNeedMoving(Rectangle viewArea, Rectangle controlRect) {
        Point needMoving = new Point(0, 0);
        if (controlRect.x < viewArea.x) {
            needMoving.x = viewArea.x - controlRect.x;
        }
        if (viewArea.x + viewArea.width < controlRect.x + controlRect.width) {
            needMoving.x += viewArea.x + viewArea.width - (controlRect.x + controlRect.width);
        }
        if (controlRect.y < viewArea.y) {
            needMoving.y = viewArea.y - controlRect.y;
        }
        if (viewArea.y + viewArea.height < controlRect.y + controlRect.height) {
            needMoving.y += viewArea.y + viewArea.height - (controlRect.y + controlRect.height);
        }
        return needMoving;
    }
}

