/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

import java.util.Hashtable;

public class CharDecoder {
    private Hashtable chars = new Hashtable();

    public String getCharValue(String string) {
        Object v = this.chars.get(string);
        if (v != null) {
            return (String)v;
        }
        try {
            if (string.charAt(0) == '#') {
                if (string.charAt(1) == 'x') {
                    int n = Integer.parseInt(string.substring(2), 16);
                    char[] cArray = new char[]{(char)n};
                    return new String(cArray, 0, 1);
                }
                int n = Integer.parseInt(string.substring(1), 10);
                char[] cArray = new char[]{(char)n};
                return new String(cArray, 0, 1);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public Hashtable getTable() {
        return this.chars;
    }

    public static CharDecoder forXml() {
        CharDecoder charDecoder = new CharDecoder();
        charDecoder.setCharValue("amp", "&");
        charDecoder.setCharValue("lt", "<");
        charDecoder.setCharValue("gt", ">");
        charDecoder.setCharValue("apos", "'");
        charDecoder.setCharValue("quot", "\"");
        return charDecoder;
    }

    public static CharDecoder htmlCharacters() {
        CharDecoder charDecoder = new CharDecoder();
        charDecoder.setCharValue("amp", "&");
        charDecoder.setCharValue("lt", "<");
        charDecoder.setCharValue("gt", ">");
        charDecoder.setCharValue("apos", "'");
        charDecoder.setCharValue("quot", "\"");
        charDecoder.setCharValue("nbsp", "\u00a0");
        return charDecoder;
    }

    public void setCharValue(String string, String string2) {
        this.chars.put(string, string2);
    }
}

