/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.common.NotDefinedException;

public final class ExecutionEvent {
    private final Object applicationContext;
    private final Command command;
    private final Map parameters;
    private final Object trigger;

    public ExecutionEvent() {
        this(null, Collections.EMPTY_MAP, null, null);
    }

    public ExecutionEvent(Map map, Object object, Object object2) {
        this(null, map, object, object2);
    }

    public ExecutionEvent(Command command, Map map, Object object, Object object2) {
        if (map == null) {
            throw new NullPointerException("An execution event must have a non-null map of parameters");
        }
        this.command = command;
        this.parameters = map;
        this.trigger = object;
        this.applicationContext = object2;
    }

    public final Object getApplicationContext() {
        return this.applicationContext;
    }

    public final Command getCommand() {
        return this.command;
    }

    public final Object getObjectParameterForExecution(String string) throws ExecutionException {
        if (this.command == null) {
            throw new ExecutionException("No command is associated with this execution event");
        }
        try {
            ParameterType parameterType = this.command.getParameterType(string);
            if (parameterType == null) {
                throw new ExecutionException("Command does not have a parameter type for the given parameter");
            }
            AbstractParameterValueConverter abstractParameterValueConverter = parameterType.getValueConverter();
            if (abstractParameterValueConverter == null) {
                throw new ExecutionException("Command does not have a value converter");
            }
            String string2 = this.getParameter(string);
            Object object = abstractParameterValueConverter.convertToObject(string2);
            return object;
        }
        catch (NotDefinedException notDefinedException) {
            throw new ExecutionException("Command is not defined", notDefinedException);
        }
        catch (ParameterValueConversionException parameterValueConversionException) {
            throw new ExecutionException("The parameter string could not be converted to an object", parameterValueConversionException);
        }
    }

    public final String getParameter(String string) {
        return (String)this.parameters.get(string);
    }

    public final Map getParameters() {
        return this.parameters;
    }

    public final Object getTrigger() {
        return this.trigger;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ExecutionEvent(");
        stringBuffer.append(this.command);
        stringBuffer.append(',');
        stringBuffer.append(this.parameters);
        stringBuffer.append(',');
        stringBuffer.append(this.trigger);
        stringBuffer.append(',');
        stringBuffer.append(this.applicationContext);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

