/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

public class RegistryIndexChildren {
    static final int[] EMPTY_ARRAY = new int[0];
    private int[] children;

    public RegistryIndexChildren() {
        this.children = EMPTY_ARRAY;
    }

    public RegistryIndexChildren(int[] nArray) {
        this.children = nArray;
    }

    public int[] getChildren() {
        return this.children;
    }

    public int findChild(int n) {
        int n2 = 0;
        while (n2 < this.children.length) {
            if (this.children[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean unlinkChild(int n) {
        int n2 = this.findChild(n);
        if (n2 == -1) {
            return false;
        }
        int[] nArray = new int[this.children.length - 1];
        System.arraycopy(this.children, 0, nArray, 0, n2);
        System.arraycopy(this.children, n2 + 1, nArray, n2, this.children.length - n2 - 1);
        this.children = nArray;
        return true;
    }

    public boolean linkChild(int n) {
        if (this.children.length == 0) {
            this.children = new int[]{n};
            return true;
        }
        int[] nArray = new int[this.children.length + 1];
        System.arraycopy(this.children, 0, nArray, 0, this.children.length);
        nArray[this.children.length] = n;
        this.children = nArray;
        return true;
    }

    public boolean linkChildren(int[] nArray) {
        if (this.children.length == 0) {
            this.children = nArray;
            return true;
        }
        int[] nArray2 = new int[this.children.length + nArray.length];
        System.arraycopy(this.children, 0, nArray2, 0, this.children.length);
        System.arraycopy(nArray, 0, nArray2, this.children.length, nArray.length);
        this.children = nArray2;
        return true;
    }

    public boolean unlinkChildren(int[] nArray) {
        int n;
        if (this.children.length == 0) {
            return nArray.length == 0;
        }
        int n2 = this.children.length;
        int n3 = 0;
        while (n3 < nArray.length) {
            n = this.findChild(nArray[n3]);
            if (n != -1) {
                this.children[n3] = -1;
                --n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            this.children = EMPTY_ARRAY;
            return true;
        }
        int[] nArray2 = new int[n2];
        n = 0;
        int n4 = 0;
        while (n4 < this.children.length) {
            if (this.children[n4] != -1) {
                nArray2[n] = this.children[n4];
                ++n;
            }
            ++n4;
        }
        return true;
    }
}

