/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.FeatureContentConsumer;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.NonPluginEntryContentConsumer;
import org.eclipse.update.internal.core.PluginEntryContentConsumer;
import org.eclipse.update.internal.core.SiteFile;

public class FeatureExecutableContentConsumer
extends FeatureContentConsumer {
    private IFeature feature;
    private boolean closed = false;
    private boolean aborted = false;
    private ISiteContentConsumer contentConsumer;
    private IFeatureContentConsumer parent = null;
    private List children;

    public IContentConsumer open(INonPluginEntry iNonPluginEntry) throws CoreException {
        NonPluginEntryContentConsumer nonPluginEntryContentConsumer = new NonPluginEntryContentConsumer(this.getContentConsumer().open(iNonPluginEntry));
        return nonPluginEntryContentConsumer;
    }

    public IContentConsumer open(IPluginEntry iPluginEntry) throws CoreException {
        PluginEntryContentConsumer pluginEntryContentConsumer = new PluginEntryContentConsumer(this.getContentConsumer().open(iPluginEntry));
        return pluginEntryContentConsumer;
    }

    public void addChild(IFeature iFeature) throws CoreException {
        IFeatureContentConsumer iFeatureContentConsumer = iFeature.getFeatureContentConsumer();
        iFeatureContentConsumer.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(iFeatureContentConsumer);
    }

    public void store(ContentReference contentReference, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getContentConsumer().store(contentReference, iProgressMonitor);
    }

    public IFeatureReference close() throws CoreException {
        if (!this.closed && this.getParent() != null) {
            this.closed = true;
            return null;
        }
        if (this.getParent() == null) {
            ErrorRecoveryLog.getLog().append("ALL_FEATURES_INSTALLED");
        }
        IFeatureReference iFeatureReference = null;
        if (this.contentConsumer != null) {
            iFeatureReference = this.contentConsumer.close();
        }
        IFeatureContentConsumer[] iFeatureContentConsumerArray = this.getChildren();
        int n = 0;
        while (n < iFeatureContentConsumerArray.length) {
            iFeatureContentConsumerArray[n].close();
            ++n;
        }
        return iFeatureReference;
    }

    public void setFeature(IFeature iFeature) {
        this.feature = iFeature;
    }

    public void setParent(IFeatureContentConsumer iFeatureContentConsumer) {
        this.parent = iFeatureContentConsumer;
    }

    private ISiteContentConsumer getContentConsumer() throws CoreException {
        if (this.contentConsumer == null) {
            if (this.feature.getSite() instanceof SiteFile) {
                SiteFile siteFile = (SiteFile)this.feature.getSite();
                this.contentConsumer = siteFile.createSiteContentConsumer(this.feature);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.contentConsumer;
    }

    public void abort() throws CoreException {
        if (this.aborted) {
            return;
        }
        IFeatureContentConsumer[] iFeatureContentConsumerArray = this.getChildren();
        int n = 0;
        while (n < iFeatureContentConsumerArray.length) {
            try {
                iFeatureContentConsumerArray[n].abort();
            }
            catch (Exception exception) {}
            ++n;
        }
        if (this.contentConsumer != null) {
            this.contentConsumer.abort();
        }
        this.aborted = true;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IFeatureContentConsumer getParent() {
        return this.parent;
    }

    public IFeatureContentConsumer[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return new IFeatureContentConsumer[0];
        }
        return (IFeatureContentConsumer[])this.children.toArray(this.arrayTypeFor(this.children));
    }
}

