/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.io.File;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.UIImage;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;
import org.eclipse.update.util.CategoryWrap;
import org.eclipse.update.util.FeatureWrap;
import org.eclipse.update.util.SiteWrap;

public class BookmarksScreen
extends AbsScreen {
    public static final String BOOKMARK_FILE = "bookmarks.xml";
    private Table siteList;
    private BookmarkSite selectedBookmark;
    private Vector bookmarks = new Vector();
    private Vector tableItems = new Vector();
    private String bookmarkLocation = null;
    private Label description;
    private TaskTip progress;
    private Command addCommand;
    private Command editCommand;
    private Command removeCommand;
    private StringBuffer accessLog;
    private UpdateMonitor accessSiteMonitor;
    private AccessSiteThread accessSiteThread;
    private boolean neverComeHere = true;
    private boolean isDuplicated = false;

    public BookmarksScreen(NormalView normalView) {
        super(normalView);
        URL uRL = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation();
        if (!"file".equals(uRL.getProtocol())) {
            IPath iPath = AppPlugin.getDefault().getStateLocation();
            iPath = iPath.append(BOOKMARK_FILE);
            this.bookmarkLocation = iPath.toOSString();
        } else {
            File file = new File(uRL.getFile());
            file = new File(file.getParentFile(), BOOKMARK_FILE);
            this.bookmarkLocation = file.getAbsolutePath();
        }
    }

    protected void createScreen() {
        this.init(UIMessages.SelectSites);
        this.siteList = new Table(this.screen, 544);
        this.siteList.setLayoutData((Object)new GridData(1808));
        this.siteList.addSelectionListener((SelectionListener)this);
        TableColumn tableColumn = new TableColumn(this.siteList, 0);
        tableColumn.setWidth(this.view.parent.getSize().x - 20);
        this.separator();
        this.description = new Label(this.screen, 0);
        this.description.setLayoutData((Object)new GridData(768));
        this.setButtons(1, 2, 3);
        this.addCommand = new Command((Control)this.screen, 1, 10);
        this.addCommand.setText(UIMessages.Add);
        this.addCommand.setLongLabel(UIMessages.AddBookmark);
        this.addCommand.addSelectionListener((SelectionListener)this);
        this.editCommand = new Command((Control)this.screen, 1, 9);
        this.editCommand.setText(UIMessages.Edit);
        this.editCommand.setLongLabel(UIMessages.EditBookmark);
        this.editCommand.addSelectionListener((SelectionListener)this);
        this.removeCommand = new Command((Control)this.screen, 1, 8);
        this.removeCommand.setText(UIMessages.Remove);
        this.removeCommand.setLongLabel(UIMessages.RemoveBookmark);
        this.removeCommand.addSelectionListener((SelectionListener)this);
        this.screen.layout();
    }

    protected void refresh() {
        this.addCommand.setEnabled(true);
        this.editCommand.setEnabled(false);
        this.removeCommand.setEnabled(false);
        this.backButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.description.setText("");
        this.view.bookmarkFile = this.bookmarkLocation;
        this.siteList.removeAll();
        this.tableItems.removeAllElements();
        BookmarkUtil.load(this.bookmarkLocation, this.bookmarks);
        int n = 0;
        while (n < this.bookmarks.size()) {
            TableItem tableItem = new TableItem(this.siteList, 0);
            BookmarkSite bookmarkSite = (BookmarkSite)this.bookmarks.elementAt(n);
            tableItem.setImage(UIImage.ICON_SITE.createImage());
            tableItem.setText(bookmarkSite.getName());
            tableItem.setChecked(bookmarkSite.getSelected());
            this.tableItems.add(tableItem);
            if (bookmarkSite.getSelected()) {
                this.nextButton.setEnabled(true);
            }
            ++n;
        }
    }

    public void action() {
        if (this.neverComeHere && this.bookmarks.size() == 0) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 34);
            messageBox.setText(UIMessages.Hints);
            if (this.view.isSoftKeySupported) {
                messageBox.setMessage(UIMessages.HintToNewBookmark2);
            } else {
                messageBox.setMessage(UIMessages.HintToNewBookmark);
            }
            messageBox.open();
        }
        this.neverComeHere = false;
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        if (this.nextButton.getEnabled()) {
            this.nextButton.setFocus();
        } else {
            this.siteList.setFocus();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.siteList) {
            if (selectionEvent.detail == 32 && selectionEvent.item != null) {
                int n = 0;
                int n2 = 0;
                while (n2 < this.tableItems.size()) {
                    if (((TableItem)selectionEvent.item).equals((TableItem)this.tableItems.elementAt(n2))) {
                        ((BookmarkSite)this.bookmarks.elementAt(n2)).setSelected(((TableItem)selectionEvent.item).getChecked());
                    }
                    if (((TableItem)this.tableItems.elementAt(n2)).getChecked()) {
                        ++n;
                    }
                    ++n2;
                }
                this.nextButton.setEnabled(n > 0);
            } else {
                int n = this.siteList.getSelectionCount();
                this.editCommand.setEnabled(n == 1);
                this.removeCommand.setEnabled(n == 1);
                if (n == 1) {
                    TableItem[] tableItemArray = this.siteList.getSelection();
                    int n3 = 0;
                    while (n3 < this.bookmarks.size()) {
                        this.selectedBookmark = (BookmarkSite)this.bookmarks.elementAt(n3);
                        if (tableItemArray[0].getText().equals(this.selectedBookmark.getName())) {
                            this.description.setText(this.selectedBookmark.getDescription());
                            this.view.currentName = this.selectedBookmark.getName();
                            break;
                        }
                        ++n3;
                    }
                }
            }
            return;
        }
        BookmarkUtil.store(this.bookmarkLocation, this.bookmarks);
        if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        } else if (selectionEvent.widget == this.cancelButton) {
            if (this.accessSiteMonitor != null) {
                this.accessSiteMonitor.setCanceled(true);
            }
        } else if (selectionEvent.widget == this.nextButton) {
            this.backButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.nextButton.setEnabled(false);
            this.processNextButton();
        } else if (selectionEvent.widget == this.addCommand) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(5, true);
        } else if (selectionEvent.widget == this.editCommand) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(8, true);
        } else if (selectionEvent.widget == this.removeCommand) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 196);
            messageBox.setText(UIMessages.RemoveBookmark);
            messageBox.setMessage(UIMessages.RemoveBookmarkQuery);
            if (messageBox.open() == 64) {
                this.bookmarks.remove(this.selectedBookmark);
                BookmarkUtil.store(this.bookmarkLocation, this.bookmarks);
                this.refresh();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.siteList) {
            this.widgetSelected(selectionEvent);
        }
    }

    private void processNextButton() {
        this.progress = new TaskTip(this.screen.getShell(), 2);
        this.progress.setText(UIMessages.SearchingSites);
        this.progress.setVisible(true);
        this.cancelButton.setFocus();
        this.accessSiteMonitor = new UpdateMonitor();
        this.accessLog = new StringBuffer();
        this.accessSiteThread = new AccessSiteThread("", this.bookmarks, this.view.viewedTree, this.view.availableFeatures, this.accessLog, this.accessSiteMonitor);
        this.accessSiteThread.start();
        Display.getCurrent().timerExec(700, new Runnable(){

            public void run() {
                int n = BookmarksScreen.this.accessSiteThread.getStatus();
                if (n == 1) {
                    Display.getCurrent().timerExec(500, (Runnable)this);
                } else if (!BookmarksScreen.this.accessSiteMonitor.isCanceled() && n == 2) {
                    BookmarksScreen.this.cancelButton.setEnabled(false);
                    BookmarksScreen.this.progress.setVisible(false);
                    if (BookmarksScreen.this.isDuplicated) {
                        return;
                    }
                    BookmarksScreen.this.isDuplicated = true;
                    if (BookmarksScreen.this.accessLog.length() > 0) {
                        MessageBox messageBox = new MessageBox(BookmarksScreen.this.screen.getShell(), 34);
                        messageBox.setText(UIMessages.UpdateSiteStatus);
                        messageBox.setMessage(BookmarksScreen.this.accessLog.toString());
                        messageBox.open();
                    }
                    BookmarksScreen.this.isDuplicated = false;
                    BookmarksScreen.this.progress.dispose();
                    BookmarksScreen.this.progress = null;
                    BookmarksScreen.this.accessSiteThread = null;
                    BookmarksScreen.this.backButton.setEnabled(true);
                    BookmarksScreen.this.nextButton.setEnabled(true);
                    BookmarksScreen.this.setVisible(false);
                    NormalView normalView = BookmarksScreen.this.view;
                    ((Object)((Object)BookmarksScreen.this.view)).getClass();
                    ((Object)((Object)BookmarksScreen.this.view)).getClass();
                    normalView.showScreen(2, true);
                } else {
                    BookmarksScreen.this.accessSiteThread = null;
                    BookmarksScreen.this.progress.setVisible(false);
                    BookmarksScreen.this.progress.dispose();
                    BookmarksScreen.this.progress = null;
                    BookmarksScreen.this.backButton.setEnabled(true);
                    BookmarksScreen.this.cancelButton.setEnabled(false);
                    BookmarksScreen.this.nextButton.setEnabled(true);
                }
            }
        });
    }

    public class AccessSiteThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int DONE = 2;
        public static final int CANCELED = 3;
        private Vector bookmarks;
        private Vector viewedTree;
        private Vector availableFeatures;
        private StringBuffer log;
        private IProgressMonitor monitor;
        private int currentStatus;

        public AccessSiteThread(String string, Vector vector, Vector vector2, Vector vector3, StringBuffer stringBuffer, IProgressMonitor iProgressMonitor) {
            super(string);
            this.bookmarks = vector;
            this.viewedTree = vector2;
            this.availableFeatures = vector3;
            this.log = stringBuffer;
            this.monitor = iProgressMonitor;
            this.currentStatus = 0;
        }

        public void run() {
            try {
                this.currentStatus = 1;
                this.viewedTree.removeAllElements();
                this.availableFeatures.removeAllElements();
                int n = 0;
                while (n < this.bookmarks.size()) {
                    block21: {
                        BookmarkSite bookmarkSite = (BookmarkSite)this.bookmarks.elementAt(n);
                        if (bookmarkSite.getSelected()) {
                            ISite iSite = null;
                            if (!this.monitor.isCanceled()) {
                                try {
                                    iSite = SiteManager.getSite((URL)bookmarkSite.getURL(), (IProgressMonitor)this.monitor);
                                }
                                catch (CoreException coreException) {
                                    this.log.append(NLS.bind((String)UIMessages.GotAccessError, (Object[])new String[]{bookmarkSite.getName(), coreException.getLocalizedMessage()})).append("\n");
                                    UpdateCore.log((Throwable)coreException);
                                    if (UpdateCore.DEBUG) {
                                        coreException.printStackTrace();
                                    }
                                    break block21;
                                }
                            }
                            if (this.monitor.isCanceled()) {
                                this.currentStatus = 3;
                                return;
                            }
                            boolean bl = Boolean.valueOf(System.getProperty("org.eclipse.ercp.update.enableSiteFilter"));
                            if (bl && !"org.eclipse.update.core.http".equalsIgnoreCase(iSite.getType()) && !"org.eclipse.update.core.file".equalsIgnoreCase(iSite.getType())) {
                                this.log.append(NLS.bind((String)UIMessages.NotSupportedSiteType, (Object[])new String[]{bookmarkSite.getName(), iSite.getType() == null ? "" : iSite.getType()})).append("\n");
                            } else {
                                SiteWrap siteWrap = new SiteWrap(bookmarkSite.getName());
                                siteWrap.setDescription(iSite.getDescription().getAnnotation());
                                bookmarkSite.setDescription(iSite.getDescription().getAnnotation());
                                CategoryWrap categoryWrap = null;
                                ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getRawFeatureReferences();
                                if (iSiteFeatureReferenceArray != null) {
                                    int n2 = 0;
                                    while (n2 < iSiteFeatureReferenceArray.length) {
                                        try {
                                            if (this.isNewFeature(iSiteFeatureReferenceArray[n2])) {
                                                FeatureWrap featureWrap = new FeatureWrap(iSiteFeatureReferenceArray[n2]);
                                                ICategory[] iCategoryArray = iSiteFeatureReferenceArray[n2].getCategories();
                                                if (iCategoryArray.length == 0) {
                                                    if (categoryWrap == null) {
                                                        categoryWrap = new CategoryWrap(UIMessages.Other);
                                                        siteWrap.addChild(categoryWrap);
                                                    }
                                                    categoryWrap.addChild(featureWrap);
                                                } else {
                                                    int n3 = 0;
                                                    while (n3 < iCategoryArray.length) {
                                                        CategoryWrap categoryWrap2 = this.getThisCategoryWrap(siteWrap, iCategoryArray[n3]);
                                                        if (categoryWrap2 != null) {
                                                            categoryWrap2.addChild(featureWrap);
                                                        }
                                                        ++n3;
                                                    }
                                                }
                                                this.availableFeatures.add(featureWrap);
                                            }
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                        ++n2;
                                    }
                                }
                                BookmarksScreen.this.view.viewedTree.add(siteWrap);
                            }
                        }
                    }
                    ++n;
                }
                this.currentStatus = this.monitor.isCanceled() ? 3 : 2;
            }
            catch (Exception exception) {
                this.currentStatus = 3;
                exception.printStackTrace();
            }
        }

        private CategoryWrap getThisCategoryWrap(SiteWrap siteWrap, ICategory iCategory) {
            if (siteWrap == null || iCategory == null) {
                return null;
            }
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n = 0;
            while (n < categoryWrapArray.length) {
                if (iCategory.getLabel().equals(categoryWrapArray[n].getLabel())) {
                    return categoryWrapArray[n];
                }
                ++n;
            }
            CategoryWrap categoryWrap = new CategoryWrap(iCategory.getLabel());
            IURLEntry iURLEntry = iCategory.getDescription();
            if (iURLEntry != null) {
                categoryWrap.setDescription(iURLEntry.getAnnotation());
            }
            siteWrap.addChild(categoryWrap);
            return categoryWrap;
        }

        private boolean isNewFeature(ISiteFeatureReference iSiteFeatureReference) {
            VersionedIdentifier versionedIdentifier;
            try {
                versionedIdentifier = iSiteFeatureReference.getVersionedIdentifier();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return false;
            }
            int n = 0;
            while (n < BookmarksScreen.this.view.installedFeatures.size()) {
                block6: {
                    VersionedIdentifier versionedIdentifier2;
                    try {
                        versionedIdentifier2 = ((IFeatureReference)BookmarksScreen.this.view.installedFeatures.get(n)).getVersionedIdentifier();
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                        break block6;
                    }
                    if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterOrEqualTo(versionedIdentifier.getVersion())) {
                        return false;
                    }
                }
                ++n;
            }
            return true;
        }

        public int getStatus() {
            return this.currentStatus;
        }
    }
}

