/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class ListFeaturesCommand
extends ScriptedCommand {
    private IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();

    public ListFeaturesCommand(String string) throws Exception {
        if (string != null) {
            File file = new File(string);
            if (!file.exists()) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
            }
            URL uRL = file.toURL();
            ISite iSite = SiteManager.getSite(uRL, null);
            if (iSite == null) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
            }
            IConfiguredSite iConfiguredSite = iSite.getCurrentConfiguredSite();
            if (iConfiguredSite == null) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noConfiguredSite, (Object[])new String[]{string}));
            }
            this.sites = new IConfiguredSite[]{iConfiguredSite};
        }
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        try {
            if (this.sites != null) {
                int n = 0;
                while (n < this.sites.length) {
                    System.out.println("Site: " + this.sites[n].getSite().getURL());
                    IFeatureReference[] iFeatureReferenceArray = this.sites[n].getFeatureReferences();
                    int n2 = 0;
                    while (n2 < iFeatureReferenceArray.length) {
                        boolean bl = this.sites[n].isConfigured(iFeatureReferenceArray[n2].getFeature(null));
                        System.out.println("  Feature: " + iFeatureReferenceArray[n2].getVersionedIdentifier().getIdentifier() + " " + iFeatureReferenceArray[n2].getVersionedIdentifier().getVersion() + "  " + (bl ? "enabled" : "disabled"));
                        ++n2;
                    }
                    ++n;
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(coreException);
            return false;
        }
    }
}

