/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.CompatibleWorkbenchPage;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageSelectionService;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;

public class WorkbenchPage
extends CompatibleWorkbenchPage
implements IWorkbenchPage {
    private WorkbenchWindow window;
    private IAdaptable input;
    private Composite composite;
    private IWorkbenchPart activePart;
    private ActivationList activationList = new ActivationList();
    private PartListenerList partListeners = new PartListenerList();
    private PartListenerList2 partListeners2 = new PartListenerList2();
    private ListenerList propertyChangeListeners = new ListenerList();
    private PageSelectionService selectionService = new PageSelectionService(this);
    private ViewFactory viewFactory;
    private PerspectiveList perspList = new PerspectiveList();
    private PerspectiveDescriptor deferredActivePersp;
    private HashMap stateMap = new HashMap();
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (!"PROP_VISIBILITY".equals(property)) return;
            WorkbenchPartReference ref = (WorkbenchPartReference)((PartPane)event.getSource()).getPartReference();
            IWorkbenchPart part = ref.getPart(Boolean.TRUE.equals(event.getNewValue()));
            if (ref == null) {
                return;
            }
            if (Boolean.TRUE.equals(event.getNewValue())) {
                String label = null;
                if (UIStats.isDebugging(9)) {
                    label = "visible::" + ref.getTitle();
                }
                try {
                    UIStats.start(9, label);
                    WorkbenchPage.this.partListeners2.firePartVisible(ref);
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    UIStats.end(9, part, label);
                    throw throwable;
                }
                {
                    Object var6_10 = null;
                    UIStats.end(9, part, label);
                    return;
                }
            }
            String label = null;
            if (UIStats.isDebugging(9)) {
                label = "hidden::" + ref.getTitle();
            }
            try {
                UIStats.start(9, label);
                WorkbenchPage.this.partListeners2.firePartHidden(ref);
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                UIStats.end(9, part, label);
                throw throwable;
            }
            {
                Object var6_12 = null;
            }
            UIStats.end(9, part, label);
        }
    };
    private ActionSwitcher actionSwitcher = new ActionSwitcher();
    private IExtensionTracker tracker;
    private IExtensionChangeHandler perspectiveChangeHandler = new IExtensionChangeHandler(){

        public void removeExtension(IExtension extension, Object[] objects) {
        }

        public void addExtension(IExtensionTracker tracker, IExtension extension) {
            if (WorkbenchPage.this != WorkbenchPage.this.getWorkbenchWindow().getActivePage()) {
                return;
            }
        }
    };

    private IExtensionPoint getPerspectiveExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
    }

    public WorkbenchPage(WorkbenchWindow w, String layoutID, IAdaptable input) throws WorkbenchException {
        if (layoutID == null) {
            throw new WorkbenchException(WorkbenchMessages.WorkbenchPage_UndefinedPerspective);
        }
        this.init(w, layoutID, input);
    }

    public WorkbenchPage(WorkbenchWindow w, IAdaptable input) throws WorkbenchException {
        this.init(w, null, input);
    }

    public void activate(IWorkbenchPart part) {
        if (!this.certifyPart(part)) {
            return;
        }
        if (this.window.isClosing()) {
            return;
        }
        this.zoomOutIfNecessary(part);
        if (this.window.getActivePage() == this) {
            this.bringToTop(part);
            this.setActivePart(part);
        } else {
            this.activationList.setActive(part);
            this.activePart = part;
        }
    }

    private void activatePart(final IWorkbenchPart part) {
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.WorkbenchPage_ErrorActivatingView){

            public void run() {
                if (part != null) {
                    part.setFocus();
                    PartSite site = (PartSite)part.getSite();
                    site.getPane().showFocus(true);
                    WorkbenchPage.this.updateTabList(part);
                }
            }
        });
    }

    public void addFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (persp.isFastView(ref)) {
            return;
        }
        persp.addFastView(ref);
        if (ref.getPart(false) == this.activePart) {
            this.activate(this.activationList.getActive());
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), ref, "fastViewAdd");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewAdd");
    }

    public void addPartListener(IPartListener l) {
        this.partListeners.addPartListener(l);
    }

    public void addPartListener(IPartListener2 l) {
        this.partListeners2.addPartListener(l);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.selectionService.addSelectionListener(listener);
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addSelectionListener(partId, listener);
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(listener);
    }

    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(partId, listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bringToTop(IWorkbenchPart part) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) return;
        if (!this.certifyPart(part)) {
            return;
        }
        if (this.isZoomed() && this.partChangeAffectsZoom(this.getReference(part))) {
            return;
        }
        String label = null;
        if (UIStats.isDebugging(8)) {
            label = part != null ? part.getTitle() : "none";
        }
        boolean broughtToTop = false;
        try {
            UIStats.start(8, label);
            if (part instanceof IViewPart) {
                IViewReference ref = (IViewReference)this.getReference(part);
                broughtToTop = persp.bringToTop(ref);
            }
            if (broughtToTop) {
                this.activationList.setActive(part);
                this.firePartBroughtToTop(part);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            UIStats.end(8, part, label);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        UIStats.end(8, part, label);
    }

    private void busyResetPerspective() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        Perspective oldPersp = this.getActivePerspective();
        IPerspectiveRegistry reg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        PerspectiveDescriptor desc = (PerspectiveDescriptor)reg.findPerspectiveWithId(oldPersp.getDesc().getId());
        if (desc == null) {
            desc = (PerspectiveDescriptor)reg.findPerspectiveWithId(((PerspectiveDescriptor)oldPersp.getDesc()).getOriginalId());
        }
        if (desc == null) {
            return;
        }
        this.window.firePerspectiveChanged(this, desc, "reset");
        Perspective newPersp = this.createPerspective(desc);
        if (newPersp == null) {
            this.window.firePerspectiveChanged(this, desc, "resetComplete");
            return;
        }
        this.perspList.swap(oldPersp, newPersp);
        this.setPerspective(newPersp);
        this.disposePerspective(oldPersp);
        this.window.firePerspectiveChanged(this, desc, "resetComplete");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void busySetPerspective(IPerspectiveDescriptor desc) {
        String label;
        block5: {
            block4: {
                label = desc.getId();
                Perspective newPersp = null;
                try {
                    UIStats.start(10, label);
                    PerspectiveDescriptor realDesc = (PerspectiveDescriptor)desc;
                    newPersp = this.findPerspective(realDesc);
                    if (newPersp == null && (newPersp = this.createPerspective(realDesc)) == null) {
                        Object var5_5 = null;
                        break block4;
                    }
                    this.setPerspective(newPersp);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    UIStats.end(10, desc.getId(), label);
                    throw throwable;
                }
            }
            UIStats.end(10, desc.getId(), label);
            return;
        }
        Object var5_7 = null;
        UIStats.end(10, desc.getId(), label);
    }

    private IViewPart busyShowView(String viewID, String secondaryID, int mode) throws PartInitException {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return null;
        }
        IViewReference ref = persp.findView(viewID, secondaryID);
        IViewPart view = null;
        if (ref != null) {
            view = ref.getView(true);
        }
        if (view != null) {
            this.busyShowView(view, mode);
            return view;
        }
        view = persp.showView(viewID, secondaryID);
        if (view != null) {
            this.busyShowView(view, mode);
            this.window.firePerspectiveChanged(this, this.getPerspective(), this.getReference(view), "viewShow");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
        }
        return view;
    }

    private void busyShowView(IViewPart part, int mode) {
        if (mode == 1) {
            this.activate(part);
        } else if (mode == 2) {
            IWorkbenchPartReference ref = this.getActivePartReference();
            if (ref == null || !(ref instanceof IViewReference)) {
                this.bringToTop(part);
            } else {
                IViewReference activeView = (IViewReference)ref;
                IViewReference[] viewStack = this.getViewReferenceStack(part);
                int i = 0;
                while (i < viewStack.length) {
                    if (viewStack[i].equals(activeView)) {
                        return;
                    }
                    ++i;
                }
                this.bringToTop(part);
            }
        }
    }

    private boolean certifyPart(IWorkbenchPart part) {
        if (part != null && !(part.getSite() instanceof PartSite)) {
            return false;
        }
        if (part instanceof IViewPart) {
            Perspective persp = this.getActivePerspective();
            return persp != null && persp.containsView((IViewPart)part);
        }
        return false;
    }

    public boolean close() {
        boolean[] ret = new boolean[]{this.window.closePage(this, true)};
        if (ret[0] && this.tracker != null) {
            this.tracker.close();
        }
        return ret[0];
    }

    public void closePerspective(IPerspectiveDescriptor desc, boolean saveEditors, boolean closePage) {
        Perspective persp = this.findPerspective(desc);
        if (persp != null) {
            this.closePerspective(persp, saveEditors, closePage);
        }
    }

    void closePerspective(Perspective persp, boolean saveEditors, boolean closePage) {
        boolean isActive;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        boolean bl = isActive = this.perspList.getActive() == persp;
        if (isActive) {
            this.setPerspective(this.perspList.getNextActive());
        }
        this.disposePerspective(persp);
        if (closePage && this.perspList.size() == 0) {
            this.close();
        }
    }

    public void closeAllPerspectives(boolean saveEditors, boolean closePage) {
        if (this.perspList.isEmpty()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        this.setPerspective((Perspective)null);
        PerspectiveList oldList = this.perspList;
        this.perspList = new PerspectiveList();
        Iterator itr = oldList.iterator();
        while (itr.hasNext()) {
            this.closePerspective((Perspective)itr.next(), false, false);
        }
        if (closePage) {
            this.close();
        }
    }

    private void createClientComposite() {
        Composite parent = this.window.getPageComposite();
        this.composite = new Composite(parent, 524288);
        this.composite.setVisible(false);
        parent.layout();
    }

    private Perspective createPerspective(PerspectiveDescriptor desc) {
        Perspective perspective;
        String label = desc.getId();
        try {
            UIStats.start(3, label);
            Perspective persp = new Perspective(desc, this);
            this.perspList.add(persp);
            this.window.firePerspectiveOpened(this, desc);
            IViewReference[] refs = persp.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                IViewReference ref = refs[i];
                if (ref != null) {
                    this.addPart(ref);
                }
                ++i;
            }
            perspective = persp;
            Object var7_8 = null;
        }
        catch (WorkbenchException workbenchException) {
            try {
                if (!((Workbench)this.window.getWorkbench()).isStarting()) {
                    ShowMessage.openError(this.window.getShell(), WorkbenchMessages.Error, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)desc.getId()));
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                UIStats.end(3, desc.getId(), label);
                throw throwable;
            }
            UIStats.end(3, desc.getId(), label);
            return null;
        }
        UIStats.end(3, desc.getId(), label);
        return perspective;
    }

    protected void addPart(IWorkbenchPartReference ref) {
        this.activationList.add(ref);
    }

    protected void removePart(IWorkbenchPartReference ref) {
        this.activationList.remove(ref);
    }

    private void deactivatePart(IWorkbenchPart part) {
        if (part != null) {
            PartSite site = (PartSite)part.getSite();
            site.getPane().showFocus(false);
        }
    }

    public void detachView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        PerspectiveHelper presentation = persp.getPresentation();
        if (persp == null) {
            return;
        }
        presentation.detachPart(ref);
    }

    public void attachView(IViewReference ref) {
        PerspectiveHelper presentation = this.getPerspectivePresentation();
        presentation.attachPart(ref);
    }

    private void disposePart(IWorkbenchPartReference ref) {
        final WorkbenchPartReference ref0 = (WorkbenchPartReference)ref;
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ref0.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void dispose() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        IViewReference[] refs = this.viewFactory.getViews();
        Iterator itr = this.perspList.iterator();
        while (itr.hasNext()) {
            Perspective perspective = (Perspective)itr.next();
            this.window.firePerspectiveClosed(this, perspective.getDesc());
            perspective.dispose();
        }
        this.perspList = new PerspectiveList();
        final int[] errors = new int[1];
        int i = 0;
        while (i < refs.length) {
            final WorkbenchPartReference ref = (WorkbenchPartReference)((Object)refs[i]);
            this.firePartClosed(refs[i]);
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ref.dispose();
                }

                public void handleException(Throwable e) {
                    errors[0] = errors[0] + 1;
                }
            });
            ++i;
        }
        this.activePart = null;
        this.activationList = new ActivationList();
        this.composite.dispose();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private void disposePerspective(Perspective persp) {
        IViewReference[] refs = persp.getViewReferences();
        this.perspList.remove(persp);
        this.window.firePerspectiveClosed(this, persp.getDesc());
        persp.dispose();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            boolean exists = this.viewFactory.hasView(ref);
            if (!exists) {
                this.firePartClosed(ref);
                this.activationList.remove(ref);
                this.disposePart(ref);
            }
            ++i;
        }
    }

    public Perspective findPerspective(IPerspectiveDescriptor desc) {
        Iterator itr = this.perspList.iterator();
        while (itr.hasNext()) {
            Perspective mgr = (Perspective)itr.next();
            if (!desc.getId().equals(mgr.getDesc().getId())) continue;
            return mgr;
        }
        return null;
    }

    public IViewPart findView(String id) {
        IViewReference ref = this.findViewReference(id);
        if (ref == null) {
            return null;
        }
        return ref.getView(true);
    }

    public IViewReference findViewReference(String viewId) {
        return this.findViewReference(viewId, null);
    }

    public IViewReference findViewReference(String viewId, String secondaryId) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return null;
        }
        return persp.findView(viewId, secondaryId);
    }

    private void firePartActivated(IWorkbenchPart part) {
        this.partListeners.firePartActivated(part);
        this.partListeners2.firePartActivated(this.getReference(part));
        this.selectionService.partActivated(part);
    }

    private void firePartBroughtToTop(IWorkbenchPart part) {
        this.partListeners.firePartBroughtToTop(part);
        this.partListeners2.firePartBroughtToTop(this.getReference(part));
        this.selectionService.partBroughtToTop(part);
    }

    private void firePartClosed(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.partListeners.firePartClosed(part);
            this.selectionService.partClosed(part);
        }
        this.partListeners2.firePartClosed(ref);
    }

    private void firePartDeactivated(IWorkbenchPart part) {
        this.partListeners.firePartDeactivated(part);
        this.partListeners2.firePartDeactivated(this.getReference(part));
        this.selectionService.partDeactivated(part);
    }

    public void firePartOpened(IWorkbenchPart part) {
        this.partListeners.firePartOpened(part);
        this.partListeners2.firePartOpened(this.getReference(part));
        this.selectionService.partOpened(part);
    }

    private void firePartInputChanged(IWorkbenchPart part) {
        this.partListeners2.firePartInputChanged(this.getReference(part));
        this.selectionService.partInputChanged(part);
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    public IWorkbenchPartReference getActivePartReference() {
        return this.getReference(this.activePart);
    }

    public Perspective getActivePerspective() {
        return this.perspList.getActive();
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    public PerspectiveHelper getPerspectivePresentation() {
        if (this.getActivePerspective() != null) {
            return this.getActivePerspective().getPresentation();
        }
        return null;
    }

    public IViewReference[] getFastViews() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getFastViews();
        }
        return new IViewReference[0];
    }

    public IAdaptable getInput() {
        return this.input;
    }

    public String getLabel() {
        String label = WorkbenchMessages.WorkbenchPage_UnknownLabel;
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            label = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)label, (Object)persp.getDesc().getLabel());
        } else if (this.deferredActivePersp != null) {
            label = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)label, (Object)this.deferredActivePersp.getLabel());
        }
        return label;
    }

    public IPerspectiveDescriptor getPerspective() {
        if (this.deferredActivePersp != null) {
            return this.deferredActivePersp;
        }
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getDesc();
        }
        return null;
    }

    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }

    public ISelection getSelection(String partId) {
        return this.selectionService.getSelection(partId);
    }

    public ArrayList getShowInPartIds() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getShowInPartIds();
        }
        return new ArrayList();
    }

    public void performedShowIn(String partId) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.performedShowIn(partId);
        }
    }

    public void sortShowInPartIds(ArrayList partIds) {
        final Perspective persp = this.getActivePerspective();
        if (persp != null) {
            Collections.sort(partIds, new Comparator(){

                public int compare(Object a, Object b) {
                    long tb;
                    long ta = persp.getShowInTime((String)a);
                    return ta == (tb = persp.getShowInTime((String)b)) ? 0 : (ta > tb ? -1 : 1);
                }
            });
        }
    }

    protected WorkbenchWindow getUnprotectedWindow() {
        return this.window;
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ViewFactory(this, WorkbenchPlugin.getDefault().getViewRegistry());
        }
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getViewReferences();
        }
        return new IViewReference[0];
    }

    public IViewPart[] getViews() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            IViewReference[] refs = persp.getViewReferences();
            ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>(refs.length);
            int i = 0;
            while (i < refs.length) {
                IWorkbenchPart part = refs[i].getPart(true);
                if (part != null) {
                    parts.add(part);
                }
                ++i;
            }
            IViewPart[] result = new IViewPart[parts.size()];
            return parts.toArray(result);
        }
        return new IViewPart[0];
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public void hideActionSet(String actionSetID) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.hideActionSet(actionSetID);
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetHide");
        }
    }

    public void hideView(IViewReference ref) {
        if (ref == null) {
            return;
        }
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.hideView((IViewPart)part);
        } else {
            this.hideView(this.getActivePerspective(), ref);
        }
    }

    void refreshActiveView() {
        IWorkbenchPart nextActive = this.activationList.getActive();
        if (nextActive != this.activePart) {
            if (nextActive != null) {
                this.activate(nextActive);
            } else {
                this.setActivePart(null);
            }
        }
    }

    public void hideView(IViewPart view) {
        Perspective persp = this.getActivePerspective();
        if (persp == null || !this.certifyPart(view)) {
            return;
        }
        IViewReference ref = (IViewReference)this.getReference(view);
        if (view == this.activePart) {
            IWorkbenchPart prevActive = this.activationList.getPreviouslyActive();
            if (prevActive != null) {
                this.activate(prevActive);
            } else {
                this.setActivePart(null);
            }
        }
        this.hideView(persp, ref);
    }

    private void hideView(Perspective persp, IViewReference ref) {
        this.window.firePerspectiveChanged(this, persp.getDesc(), ref, "viewHide");
        persp.hideView(ref);
        boolean exists = this.viewFactory.hasView(ref);
        if (!exists) {
            this.firePartClosed(ref);
            this.disposePart(ref);
            this.activationList.remove(ref);
            this.activePart = this.activationList.getActive();
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
    }

    private void init(WorkbenchWindow w, String layoutID, IAdaptable input) throws WorkbenchException {
        this.window = w;
        this.input = input;
        this.createClientComposite();
        if (layoutID != null) {
            PerspectiveDescriptor desc = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(layoutID);
            if (desc == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)layoutID));
            }
            Perspective persp = this.createPerspective(desc);
            if (persp == null) {
                return;
            }
            this.perspList.setActive(persp);
            this.window.firePerspectiveActivated(this, desc);
        }
        this.getExtensionTracker().registerHandler(this.perspectiveChangeHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getPerspectiveExtensionPoint()));
    }

    public boolean isPartVisible(IWorkbenchPart part) {
        return ((PartSite)part.getSite()).getPane().isVisible();
    }

    public boolean isEditorAreaVisible() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        return persp.isEditorAreaVisible();
    }

    public boolean isFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.isFastView(ref);
        }
        return false;
    }

    public boolean isFixedLayout() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.isFixedLayout();
        }
        return false;
    }

    public IViewReference getActiveFastView() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getActiveFastView();
        }
        return null;
    }

    public boolean isZoomed() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        if (persp.getPresentation() == null) {
            return false;
        }
        return persp.getPresentation().isZoomed();
    }

    protected void onActivate() {
        this.composite.setVisible(true);
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.onActivate();
            this.updateVisibility(null, persp);
        }
        if (this.activePart == null && persp != null) {
            IViewReference[] refs = persp.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                IViewReference ref = refs[i];
                if (ref != null) {
                    this.activePart = ref.getPart(false);
                    if (this.activePart != null) break;
                }
                ++i;
            }
        }
        if (this.activePart != null) {
            this.activationList.setActive(this.activePart);
            this.activatePart(this.activePart);
            this.actionSwitcher.updateActivePart(this.activePart);
            this.firePartActivated(this.activePart);
        } else {
            this.composite.setFocus();
        }
    }

    protected void onDeactivate() {
        if (this.activePart != null) {
            this.deactivatePart(this.activePart);
            this.actionSwitcher.updateActivePart(null);
            this.firePartDeactivated(this.activePart);
        }
        if (this.getActivePerspective() != null) {
            this.getActivePerspective().onDeactivate();
        }
        this.composite.setVisible(false);
    }

    private boolean partChangeAffectsZoom(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        return this.getActivePerspective().getPresentation().partChangeAffectsZoom(pane);
    }

    public void removeFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (!persp.isFastView(ref)) {
            return;
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), ref, "fastViewRemove");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewRemove");
    }

    public void removePartListener(IPartListener l) {
        this.partListeners.removePartListener(l);
    }

    public void removePartListener(IPartListener2 l) {
        this.partListeners2.removePartListener(l);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.selectionService.removeSelectionListener(listener);
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removeSelectionListener(partId, listener);
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(listener);
    }

    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(partId, listener);
    }

    public void requestActivation(IWorkbenchPart part) {
        if (!this.certifyPart(part)) {
            return;
        }
        this.setActivePart(part);
    }

    public void resetPerspective() {
        new Runnable(){

            public void run() {
                WorkbenchPage.this.busyResetPerspective();
            }
        };
        this.busyResetPerspective();
    }

    public IStatus restoreState(IMemento memento, IPerspectiveDescriptor activeDescriptor) {
        String blame2;
        MultiStatus multiStatus;
        String pageName = memento.getString("label");
        String label = null;
        if (UIStats.isDebugging(4)) {
            label = pageName == null ? "" : "::" + pageName;
        }
        try {
            UIStats.start(4, "WorkbenchPage" + label);
            if (pageName == null) {
                pageName = "";
            }
            MultiStatus result = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToRestorePerspective, (Object)pageName), null);
            memento.getString("workingSet");
            IMemento childMem = memento.getChild("views");
            if (childMem != null) {
                result.merge(this.getViewFactory().restoreState(childMem));
            }
            childMem = memento.getChild("perspectives");
            String activePartID = childMem.getString("activePart");
            String activePartSecondaryID = null;
            if (activePartID != null && (activePartSecondaryID = ViewFactory.extractSecondaryId(activePartID)) != null) {
                activePartID = ViewFactory.extractPrimaryId(activePartID);
            }
            String activePerspectiveID = childMem.getString("activePerspective");
            IMemento[] perspMems = childMem.getChildren("perspective");
            Perspective activePerspective = null;
            int i = 0;
            while (i < perspMems.length) {
                try {
                    Perspective persp = new Perspective(null, this);
                    result.merge(persp.restoreState(perspMems[i]));
                    IPerspectiveDescriptor desc = persp.getDesc();
                    if (desc.equals(activeDescriptor)) {
                        activePerspective = persp;
                    } else if (activePerspective == null && desc.getId().equals(activePerspectiveID)) {
                        activePerspective = persp;
                    }
                    this.perspList.add(persp);
                    this.window.firePerspectiveOpened(this, desc);
                }
                catch (WorkbenchException workbenchException) {}
                ++i;
            }
            boolean restoreActivePerspective = false;
            if (activeDescriptor == null) {
                restoreActivePerspective = true;
            } else if (activePerspective != null && activePerspective.getDesc().equals(activeDescriptor)) {
                restoreActivePerspective = true;
            } else {
                restoreActivePerspective = false;
                activePerspective = this.createPerspective((PerspectiveDescriptor)activeDescriptor);
                if (activePerspective == null) {
                    result.merge((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)activeDescriptor.getId()), null));
                }
            }
            this.perspList.setActive(activePerspective);
            activePerspective = this.perspList.getActive();
            if (activePerspective == null) {
                activePerspective = this.perspList.getNextActive();
                this.perspList.setActive(activePerspective);
                result.merge(activePerspective.restoreState());
            }
            if (activePerspective != null && restoreActivePerspective) {
                result.merge(activePerspective.restoreState());
            }
            if (activePerspective != null) {
                this.window.firePerspectiveActivated(this, activePerspective.getDesc());
                if (activePartID != null) {
                    IViewReference ref = activePerspective.findView(activePartID, activePartSecondaryID);
                    IViewPart view = null;
                    if (ref != null) {
                        view = ref.getView(true);
                    }
                    if (view != null) {
                        this.activePart = view;
                    }
                }
            }
            multiStatus = result;
            Object var15_16 = null;
            blame2 = activeDescriptor == null ? pageName : activeDescriptor.getId();
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            String blame2 = activeDescriptor == null ? pageName : activeDescriptor.getId();
            UIStats.end(4, blame2, "WorkbenchPage" + label);
            throw throwable;
        }
        UIStats.end(4, blame2, "WorkbenchPage" + label);
        return multiStatus;
    }

    public boolean saveAllEditors(boolean confirm) {
        return true;
    }

    public void savePerspective() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        persp.saveDesc();
    }

    public void savePerspectiveAs(IPerspectiveDescriptor newDesc) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        IPerspectiveDescriptor oldDesc = persp.getDesc();
        if (this.isZoomed()) {
            this.zoomOut();
        }
        persp.saveDescAs(newDesc);
        this.window.firePerspectiveSavedAs(this, oldDesc, newDesc);
    }

    public IStatus saveState(IMemento memento) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToSavePerspective, (Object)this.getLabel()), null);
        IMemento childMem = memento.createChild("views");
        result.merge(this.getViewFactory().saveState(childMem));
        childMem = memento.createChild("perspectives");
        if (this.getPerspective() != null) {
            childMem.putString("activePerspective", this.getPerspective().getId());
        }
        if (this.getActivePart() != null) {
            if (this.getActivePart() instanceof IViewPart) {
                IViewReference ref = (IViewReference)this.getReference(this.getActivePart());
                if (ref != null) {
                    childMem.putString("activePart", ViewFactory.getKey(ref));
                }
            } else {
                childMem.putString("activePart", this.getActivePart().getSite().getId());
            }
        }
        Iterator itr = this.perspList.iterator();
        while (itr.hasNext()) {
            Perspective persp = (Perspective)itr.next();
            IMemento gChildMem = childMem.createChild("perspective");
            result.merge(persp.saveState(gChildMem));
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setActivePart(IWorkbenchPart newPart) {
        Object blame2;
        if (this.activePart == newPart) {
            return;
        }
        String label = null;
        if (UIStats.isDebugging(7)) {
            label = newPart != null ? newPart.getTitle() : "none";
        }
        try {
            IWorkbenchPart oldPart;
            UIStats.start(7, label);
            Perspective persp = this.getActivePerspective();
            if (persp != null) {
                persp.partActivated(newPart);
            }
            if ((oldPart = this.activePart) != null) {
                this.deactivatePart(oldPart);
            }
            this.activePart = newPart;
            if (newPart != null) {
                this.activationList.setActive(newPart);
            }
            this.activatePart(this.activePart);
            if (oldPart != null) {
                this.firePartDeactivated(oldPart);
            }
            this.actionSwitcher.updateActivePart(newPart);
            if (newPart != null) {
                this.firePartActivated(newPart);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Object blame2 = newPart == null ? this : newPart;
            UIStats.end(7, blame2, label);
            throw throwable;
        }
        {
            Object var5_7 = null;
            blame2 = newPart == null ? this : newPart;
        }
        UIStats.end(7, blame2, label);
    }

    public void setEditorAreaVisible(boolean showEditorArea) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (showEditorArea == persp.isEditorAreaVisible()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (showEditorArea) {
            persp.showEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaShow");
        } else {
            persp.hideEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaHide");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPerspective(Perspective newPersp) {
        Perspective oldPersp = this.getActivePerspective();
        if (oldPersp == newPersp) {
            return;
        }
        this.window.largeUpdateStart();
        try {
            block17: {
                block18: {
                    IStatus status;
                    if (newPersp != null && (status = newPersp.restoreState()).getSeverity() != 0) {
                        String msg = WorkbenchMessages.WorkbenchPage_errorReadingState;
                        ShowMessage.printError(msg, status);
                    }
                    IWorkbenchPart oldActivePart = this.activePart;
                    this.setActivePart(null);
                    if (oldPersp != null) {
                        oldPersp.onDeactivate();
                        this.window.firePerspectiveDeactivated(this, oldPersp.getDesc());
                    }
                    this.perspList.setActive(newPersp);
                    if (newPersp != null) {
                        newPersp.onActivate();
                        this.window.firePerspectiveActivated(this, newPersp.getDesc());
                    } else {
                        oldActivePart = null;
                    }
                    this.updateVisibility(oldPersp, newPersp);
                    if (oldActivePart == null) break block18;
                    oldPersp.setOldPartRef(this.getReference(oldActivePart));
                    if (oldActivePart instanceof IViewPart) {
                        String secondaryId;
                        String id = oldActivePart.getSite().getId();
                        if (newPersp.findView(id, secondaryId = ((IViewPart)oldActivePart).getViewSite().getSecondaryId()) != null) {
                            this.activate(oldActivePart);
                            break block17;
                        } else {
                            this.activateOldPart(newPersp);
                        }
                        break block17;
                    } else {
                        this.activateOldPart(newPersp);
                    }
                    break block17;
                }
                this.activateOldPart(newPersp);
            }
            if (this.getActivePart() == null && this.activationList.getActive() != null) {
                this.activate(this.activationList.getActive());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.window.largeUpdateEnd();
            if (newPersp == null) {
                return;
            }
            IPerspectiveDescriptor desc = newPersp.getDesc();
            if (desc == null) {
                return;
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.window.largeUpdateEnd();
            if (newPersp == null) {
                return;
            }
            IPerspectiveDescriptor desc = newPersp.getDesc();
            if (desc == null) {
                return;
            }
            return;
        }
    }

    private void updateVisibility(Perspective oldPersp, Perspective newPersp) {
        PartPane pane;
        int i;
        IViewReference[] refs;
        HashSet<PartPane> set = new HashSet<PartPane>();
        if (oldPersp != null) {
            refs = oldPersp.getViewReferences();
            i = 0;
            while (i < refs.length) {
                pane = ((WorkbenchPartReference)((Object)refs[i])).getPane();
                if (pane != null) {
                    set.add(pane);
                }
                ++i;
            }
        }
        if (newPersp != null) {
            refs = newPersp.getViewReferences();
            i = 0;
            while (i < refs.length) {
                pane = ((WorkbenchPartReference)((Object)refs[i])).getPane();
                if (pane != null) {
                    set.add(pane);
                }
                ++i;
            }
            PerspectiveHelper pres = newPersp.getPresentation();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                PartPane pane2 = (PartPane)iter.next();
                IWorkbenchPartReference partRef = pane2.getPartReference();
                pane2.setVisible(pres.isPartVisible(partRef));
            }
        } else {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                pane = (PartPane)iter.next();
                pane.setVisible(false);
            }
        }
    }

    private void activateOldPart(Perspective newPersp) {
        if (this.window.isClosing()) {
            return;
        }
        if (newPersp != null) {
            IWorkbenchPartReference oldPartRef = newPersp.getOldPartRef();
            IWorkbenchPart prevOldPart = null;
            if (oldPartRef != null) {
                prevOldPart = oldPartRef.getPart(false);
            }
            if (prevOldPart != null) {
                this.activate(prevOldPart);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPerspective(final IPerspectiveDescriptor desc) {
        try {
            this.getClientComposite().setRedraw(false);
            new Runnable(){

                public void run() {
                    WorkbenchPage.this.busySetPerspective(desc);
                }
            };
            this.busySetPerspective(desc);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getClientComposite().setRedraw(true);
            IWorkbenchPart part = this.getActivePart();
            if (part == null) throw throwable;
            part.setFocus();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getClientComposite().setRedraw(true);
        IWorkbenchPart part = this.getActivePart();
        if (part == null) return;
        part.setFocus();
    }

    public void showActionSet(String actionSetID) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetShow");
        }
    }

    public IViewPart showView(String viewID) throws PartInitException {
        return this.showView(viewID, null, 1);
    }

    public IViewPart showView(String viewID, String secondaryID, int mode) throws PartInitException {
        if (secondaryID != null && (secondaryID.length() == 0 || secondaryID.indexOf(":") != -1)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
        }
        if (!this.certifyMode(mode)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
        }
        Object[] result = new Object[1];
        try {
            result[0] = this.busyShowView(viewID, secondaryID, mode);
        }
        catch (PartInitException e) {
            result[0] = e;
        }
        if (result[0] instanceof IViewPart) {
            return (IViewPart)result[0];
        }
        if (result[0] instanceof PartInitException) {
            throw (PartInitException)((Object)result[0]);
        }
        throw new PartInitException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private boolean certifyMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setState(IWorkbenchPartReference ref, int newState) {
        boolean isZoomed;
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        if (!pane.isDocked()) {
            pane.setZoomed(newState == 1);
            return;
        }
        boolean wasZoomed = this.isZoomed();
        boolean bl = isZoomed = newState == 1;
        if (wasZoomed && !isZoomed) {
            this.zoomOut();
        } else if (!wasZoomed && isZoomed) {
            persp.getPresentation().zoomIn(ref);
            this.activate(ref.getPart(true));
        }
        PartStack parent = (PartStack)pane.getContainer();
        if (parent != null) {
            parent.setMinimized(newState == 0);
        }
    }

    int getState(IWorkbenchPartReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return 2;
        }
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        PartStack parent = (PartStack)pane.getContainer();
        if (parent != null) {
            return parent.getState();
        }
        return 2;
    }

    public void toggleZoom(IWorkbenchPartReference ref) {
        int oldState = this.getState(ref);
        boolean shouldZoom = oldState != 1;
        int newState = shouldZoom ? 1 : 2;
        this.setState(ref, newState);
    }

    public void updateActionBars() {
        this.window.updateActionBars();
    }

    private void updateTabList(IWorkbenchPart part) {
        PartSite site = (PartSite)part.getSite();
        PartPane pane = site.getPane();
        if (pane instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)pane;
            Control[] tabList = viewPane.getTabList();
            if (!pane.isDocked()) {
                viewPane.getControl().getShell().setTabList(tabList);
            } else {
                this.getClientComposite().setTabList(tabList);
            }
        }
    }

    public void updateTitle(IViewReference ref) {
    }

    void zoomOut() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.getPresentation().zoomOut();
        }
    }

    private void zoomOutIfNecessary(IWorkbenchPart part) {
        if (this.isZoomed() && this.partChangeAffectsZoom(((PartSite)part.getSite()).getPartReference())) {
            this.zoomOut();
        }
    }

    public int getEditorReuseThreshold() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getInt("REUSE_OPEN_EDITORS");
    }

    public void setEditorReuseThreshold(int openEditors) {
    }

    public IPerspectiveDescriptor[] getOpenPerspectives() {
        Perspective[] opened = this.perspList.getOpenedPerspectives();
        IPerspectiveDescriptor[] result = new IPerspectiveDescriptor[opened.length];
        int i = 0;
        while (i < result.length) {
            result[i] = opened[i].getDesc();
            ++i;
        }
        return result;
    }

    public IPerspectiveDescriptor[] getSortedPerspectives() {
        Perspective[] sortedArray = this.perspList.getSortedPerspectives();
        IPerspectiveDescriptor[] result = new IPerspectiveDescriptor[sortedArray.length];
        int i = 0;
        while (i < result.length) {
            result[i] = sortedArray[i].getDesc();
            ++i;
        }
        return result;
    }

    public IWorkbenchPartReference[] getSortedParts() {
        return this.activationList.getParts();
    }

    public IWorkbenchPartReference getReference(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        PartPane pane = ((PartSite)part.getSite()).getPane();
        if (pane == null) {
            IViewReference[] refs = this.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getPart(false) == part) {
                    return refs[i];
                }
                ++i;
            }
            return null;
        }
        return pane.getPartReference();
    }

    protected HashMap getStateMap() {
        return this.stateMap;
    }

    protected void addPerspective(Perspective persp) {
        this.perspList.add(persp);
        this.window.firePerspectiveOpened(this, persp.getDesc());
    }

    private IViewReference[] getViewReferenceStack(IViewPart part) {
        Perspective persp = this.getActivePerspective();
        if (persp == null || !this.certifyPart(part)) {
            return null;
        }
        ILayoutContainer container = ((PartSite)part.getSite()).getPane().getContainer();
        if (container instanceof ViewStack) {
            ViewStack folder = (ViewStack)container;
            ArrayList<IViewReference> list = new ArrayList<IViewReference>(folder.getChildren().length);
            int i = 0;
            while (i < folder.getChildren().length) {
                IViewReference view;
                LayoutPart layoutPart = folder.getChildren()[i];
                if (layoutPart instanceof ViewPane && (view = ((ViewPane)layoutPart).getViewReference()) != null) {
                    list.add(view);
                }
                ++i;
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int pos1 = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)o1);
                    int pos2 = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)o2);
                    return pos1 - pos2;
                }
            });
            return list.toArray(new IViewReference[list.size()]);
        }
        return new IViewReference[]{(IViewReference)this.getReference(part)};
    }

    public IViewPart[] getViewStack(IViewPart part) {
        IViewReference[] refStack = this.getViewReferenceStack(part);
        if (refStack == null) {
            return null;
        }
        IViewPart[] stack = new IViewPart[refStack.length];
        int i = 0;
        while (i < refStack.length) {
            stack[i] = refStack[i].getView(true);
            ++i;
        }
        return stack;
    }

    IWorkbenchPartReference[] getAllParts() {
        IViewReference[] views = this.viewFactory.getViews();
        IWorkbenchPartReference[] result = new IWorkbenchPartReference[views.length];
        int resultIdx = 0;
        int i = 0;
        while (i < views.length) {
            result[resultIdx++] = views[i];
            ++i;
        }
        return result;
    }

    IWorkbenchPartReference[] getOpenParts() {
        IWorkbenchPartReference[] refs = this.getAllParts();
        ArrayList<IWorkbenchPartReference> result = new ArrayList<IWorkbenchPartReference>();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPartReference reference = refs[i];
            IWorkbenchPart part = reference.getPart(false);
            if (part != null) {
                result.add(reference);
            }
            ++i;
        }
        return result.toArray(new IWorkbenchPartReference[result.size()]);
    }

    public void testInvariants() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.testInvariants();
        }
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbenchWindow().getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    public String[] getNewWizardShortcuts() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return new String[0];
        }
        return persp.getNewWizardShortcuts();
    }

    public String[] getPerspectiveShortcuts() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return new String[0];
        }
        return persp.getPerspectiveShortcuts();
    }

    public String[] getShowViewShortcuts() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return new String[0];
        }
        return persp.getShowViewShortcuts();
    }

    private class ActionSwitcher {
        private IWorkbenchPart activePart;

        private ActionSwitcher() {
        }

        public void updateActivePart(IWorkbenchPart newPart) {
            if (this.activePart == newPart) {
                return;
            }
            this.activePart = newPart;
        }
    }

    private class ActivationList {
        List parts = new ArrayList();

        private ActivationList() {
        }

        void setActive(IWorkbenchPart part) {
            if (this.parts.size() <= 0) {
                return;
            }
            PartPane pane = ((PartSite)part.getSite()).getPane();
            IWorkbenchPartReference ref = WorkbenchPage.this.getReference(part);
            if (ref == this.parts.get(this.parts.size() - 1)) {
                return;
            }
            this.parts.remove(ref);
            this.parts.add(ref);
            pane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
        }

        void setActive(IWorkbenchPartReference ref) {
            this.setActive(ref.getPart(true));
        }

        void add(IWorkbenchPartReference ref) {
            if (this.parts.indexOf(ref) >= 0) {
                return;
            }
            PartPane pane = ((WorkbenchPartReference)ref).getPane();
            if (pane != null) {
                pane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            this.parts.add(0, ref);
        }

        IWorkbenchPart getActive() {
            if (this.parts.isEmpty()) {
                return null;
            }
            return this.getActive(this.parts.size() - 1);
        }

        IWorkbenchPart getPreviouslyActive() {
            if (this.parts.size() < 2) {
                return null;
            }
            return this.getActive(this.parts.size() - 2);
        }

        private IWorkbenchPart getActive(int start) {
            IWorkbenchPartReference ref = this.getActiveReference(start, false);
            if (ref == null) {
                return null;
            }
            return ref.getPart(true);
        }

        private IWorkbenchPartReference getActiveReference(int start, boolean editorsOnly) {
            IWorkbenchPartReference nonObscured = this.getActiveReference(start, editorsOnly, true);
            if (nonObscured != null) {
                return nonObscured;
            }
            return this.getActiveReference(start, editorsOnly, false);
        }

        private IWorkbenchPartReference getActiveReference(int start, boolean editorsOnly, boolean skipPartsObscuredByZoom) {
            IViewReference[] views = WorkbenchPage.this.getViewReferences();
            int i = start;
            while (i >= 0) {
                ILayoutContainer container;
                WorkbenchPartReference ref = (WorkbenchPartReference)this.parts.get(i);
                PartPane pane = ref.getPane();
                if (!(pane != null && ((container = pane.getContainer()) != null && !container.allowsAutoFocus() || skipPartsObscuredByZoom && pane.isObscuredByZoom()))) {
                    if (ref instanceof IViewReference) {
                        if (!((IViewReference)((Object)ref)).isFastView()) {
                            int j = 0;
                            while (j < views.length) {
                                if (views[j] == ref) {
                                    return ref;
                                }
                                ++j;
                            }
                        }
                    } else {
                        return ref;
                    }
                }
                --i;
            }
            return null;
        }

        int indexOf(IWorkbenchPart part) {
            return this.parts.indexOf(WorkbenchPage.this.getReference(part));
        }

        int indexOf(IWorkbenchPartReference ref) {
            return this.parts.indexOf(ref);
        }

        boolean remove(IWorkbenchPartReference ref) {
            PartPane pane = ((WorkbenchPartReference)ref).getPane();
            if (pane != null) {
                pane.removePropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            return this.parts.remove(ref);
        }

        private IWorkbenchPartReference[] getParts() {
            IViewReference[] views = WorkbenchPage.this.getViewReferences();
            ArrayList<IWorkbenchPartReference> resultList = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            Iterator iterator = this.parts.iterator();
            block0: while (iterator.hasNext()) {
                IWorkbenchPartReference ref = (IWorkbenchPartReference)iterator.next();
                if (ref instanceof IViewReference) {
                    int i = 0;
                    while (i < views.length) {
                        if (views[i] == ref) {
                            resultList.add(ref);
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                resultList.add(ref);
            }
            IWorkbenchPartReference[] result = new IWorkbenchPartReference[resultList.size()];
            return resultList.toArray(result);
        }
    }

    private class PerspectiveList {
        private List openedList = new ArrayList(15);
        private List usedList = new ArrayList(15);
        private Perspective active;

        public Perspective[] getSortedPerspectives() {
            Perspective[] result = new Perspective[this.usedList.size()];
            return this.usedList.toArray(result);
        }

        public boolean add(Perspective perspective) {
            this.openedList.add(perspective);
            this.usedList.add(0, perspective);
            return true;
        }

        public Iterator iterator() {
            return this.openedList.iterator();
        }

        public Perspective[] getOpenedPerspectives() {
            Perspective[] result = new Perspective[this.openedList.size()];
            return this.openedList.toArray(result);
        }

        public boolean remove(Perspective perspective) {
            if (this.active == perspective) {
                this.active = null;
            }
            this.usedList.remove(perspective);
            return this.openedList.remove(perspective);
        }

        public void swap(Perspective oldPerspective, Perspective newPerspective) {
            int oldIndex = this.openedList.indexOf(oldPerspective);
            int newIndex = this.openedList.indexOf(newPerspective);
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            this.openedList.set(oldIndex, newPerspective);
            this.openedList.set(newIndex, oldPerspective);
        }

        public boolean isEmpty() {
            return this.openedList.isEmpty();
        }

        public Perspective getActive() {
            return this.active;
        }

        public Perspective getNextActive() {
            if (this.active == null) {
                if (this.usedList.isEmpty()) {
                    return null;
                }
                return (Perspective)this.usedList.get(this.usedList.size() - 1);
            }
            if (this.usedList.size() < 2) {
                return null;
            }
            return (Perspective)this.usedList.get(this.usedList.size() - 2);
        }

        public int size() {
            return this.openedList.size();
        }

        public void setActive(Perspective perspective) {
            if (perspective == this.active) {
                return;
            }
            this.active = perspective;
            if (perspective != null) {
                this.usedList.remove(perspective);
                this.usedList.add(perspective);
            }
        }
    }
}

