/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser {
    protected SAXParser() {
    }

    public abstract void parse(InputSource var1, DefaultHandler var2) throws SAXException, IOException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract XMLReader getXMLReader() throws SAXException;

    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract Object getProperty(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    public void parse(File file, DefaultHandler dh) throws SAXException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "File"));
        }
        FileInputStream is = new FileInputStream(file);
        this.parse(is, dh);
        ((InputStream)is).close();
    }

    public void parse(InputStream is, DefaultHandler dh) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "InpuStream"));
        }
        this.parse(new InputSource(is), dh);
    }

    public void parse(InputStream is, DefaultHandler dh, String systemId) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "InpuStream"));
        }
        InputSource input = new InputSource(is);
        input.setSystemId(systemId);
        this.parse(input, dh);
    }

    public void parse(String uri, DefaultHandler dh) throws SAXException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "URI"));
        }
        this.parse(new InputSource(uri), dh);
    }

    public abstract Parser getParser() throws SAXException;
}

