/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.RGBColorDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class ResourceManager {
    private List disposeExecs = null;

    public abstract Device getDevice();

    public abstract Object create(DeviceResourceDescriptor var1) throws DeviceResourceException;

    public abstract void destroy(DeviceResourceDescriptor var1);

    public final Image createImage(ImageDescriptor imageDescriptor) throws DeviceResourceException {
        return (Image)this.create(imageDescriptor);
    }

    public final Image createImageWithDefault(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return this.getDefaultImage();
        }
        try {
            return (Image)this.create(imageDescriptor);
        }
        catch (DeviceResourceException deviceResourceException) {
            return this.getDefaultImage();
        }
    }

    protected abstract Image getDefaultImage();

    public final void destroyImage(ImageDescriptor imageDescriptor) {
        this.destroy(imageDescriptor);
    }

    public final Color createColor(ColorDescriptor colorDescriptor) throws DeviceResourceException {
        return (Color)this.create(colorDescriptor);
    }

    public final Color createColor(RGB rGB) throws DeviceResourceException {
        return this.createColor(new RGBColorDescriptor(rGB));
    }

    public final void destroyColor(RGB rGB) {
        this.destroyColor(new RGBColorDescriptor(rGB));
    }

    public final void destroyColor(ColorDescriptor colorDescriptor) {
        this.destroy(colorDescriptor);
    }

    public final Font createFont(FontDescriptor fontDescriptor) throws DeviceResourceException {
        return (Font)this.create(fontDescriptor);
    }

    public final void destroyFont(FontDescriptor fontDescriptor) {
        this.destroy(fontDescriptor);
    }

    public void dispose() {
        if (this.disposeExecs == null) {
            return;
        }
        RuntimeException runtimeException = null;
        Runnable[] runnableArray = this.disposeExecs.toArray(new Runnable[this.disposeExecs.size()]);
        int n = 0;
        while (n < runnableArray.length) {
            Runnable runnable = runnableArray[n];
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            ++n;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public abstract Object find(DeviceResourceDescriptor var1);

    public void disposeExec(Runnable runnable) {
        Assert.isNotNull(runnable);
        if (this.disposeExecs == null) {
            this.disposeExecs = new ArrayList();
        }
        this.disposeExecs.add(runnable);
    }

    public void cancelDisposeExec(Runnable runnable) {
        Assert.isNotNull(runnable);
        if (this.disposeExecs == null) {
            return;
        }
        this.disposeExecs.remove(runnable);
        if (this.disposeExecs.isEmpty()) {
            this.disposeExecs = null;
        }
    }
}

