/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.OptionalFeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;

public class InstallOperation
extends OptionalFeatureOperation
implements IInstallFeatureOperation {
    private IVerificationListener verifier;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof InstallOperation)) {
            return false;
        }
        InstallOperation installOperation = (InstallOperation)object;
        return installOperation.getFeature().getVersionedIdentifier().equals(this.getFeature().getVersionedIdentifier());
    }

    public int hashCode() {
        return super.getFeature().hashCode();
    }

    public InstallOperation(IConfiguredSite iConfiguredSite, IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IFeature[] iFeatureArray, IVerificationListener iVerificationListener) {
        super(iConfiguredSite, iFeature);
        IFeature[] iFeatureArray2 = UpdateUtils.getInstalledFeatures(iFeature);
        if (iFeatureArray2.length > 0) {
            this.oldFeature = iFeatureArray2[0];
        }
        this.unconfiguredOptionalFeatures = iFeatureArray;
        this.optionalFeatures = iFeatureReferenceArray;
        this.verifier = iVerificationListener;
    }

    public IFeatureReference[] getOptionalFeatures() {
        return this.optionalFeatures;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        boolean bl = false;
        if (this.oldFeature != null && this.feature.getVersionedIdentifier().equals(this.oldFeature.getVersionedIdentifier())) {
            bl = true;
        }
        this.setOptionalFeatures();
        if (this.optionalFeatures == null) {
            this.targetSite.install(this.feature, this.verifier, iProgressMonitor);
        } else {
            this.targetSite.install(this.feature, this.optionalFeatures, this.verifier, iProgressMonitor);
        }
        if (!bl && !this.isManagedOnly() && this.oldFeature != null) {
            IInstallConfiguration iInstallConfiguration;
            this.preserveOptionalState();
            boolean bl2 = InstallOperation.unconfigure(this.oldFeature, null);
            if (!bl2 && !UpdateUtils.isNestedChild(iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration(), this.oldFeature)) {
                String string = NLS.bind((String)Messages.OperationsManager_error_old, (Object[])new String[]{this.oldFeature.getLabel()});
                Status status = new Status(4, UpdateUtils.getPluginId(), 0, string, null);
                throw new CoreException((IStatus)status);
            }
        }
        return true;
    }
}

