/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.service.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class DefaultAuthorizationEngine
extends AuthorizationEngine {
    private static final String VERSION_PROP = "Version";
    private static final String VERSION_NUM = "1.0";
    private static final Version VERSION_MAX = new Version(2, 0, 0);
    private final State systemState;
    private final BundleContext bundleContext;
    public static final int ENFORCE_NONE = 0;
    public static final int ENFORCE_SIGNED = 1;
    public static final int ENFORCE_TRUSTED = 2;
    public static final int ENFORCE_VALIDITY = 4;
    private static final String STR_ENFORCE_NONE = "any";
    private static final String STR_ENFORCE_SIGNED = "signed";
    private static final String STR_ENFORCE_TRUSTED = "trusted";
    private static final String STR_ENFORCE_VALIDITY = "validity";
    private static final String POLICY_NAME = "org.eclipse.equinox.security";
    private static final String POLICY_PROP = "osgi.signedcontent.authorization.engine.policy";
    private static final String FILE_LOAD_POLICY = ".loadpolicy";
    private static int enforceFlags = 0;
    private static final File policyFile;

    static {
        File file = LocationManager.getOSGiConfigurationDir();
        policyFile = new File(String.valueOf(file.getPath()) + File.separatorChar + FILE_LOAD_POLICY);
        Properties properties = null;
        if (policyFile.exists()) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(policyFile));
            }
            catch (IOException iOException) {
                SignedBundleHook.log("Error loading policy file", 4, iOException);
            }
        }
        if (properties != null) {
            String string;
            Version version = new Version(0, 0, 0);
            String string2 = properties.getProperty(VERSION_PROP);
            if (string2 != null) {
                try {
                    version = new Version(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (VERSION_MAX.compareTo(version) > 0 && (string = properties.getProperty(POLICY_PROP)) != null) {
                try {
                    enforceFlags = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            String string = FrameworkProperties.getProperty(POLICY_PROP);
            if (string == null || STR_ENFORCE_NONE.equals(string)) {
                enforceFlags = 0;
            } else if (STR_ENFORCE_TRUSTED.equals(string)) {
                enforceFlags = 3;
            } else if (STR_ENFORCE_SIGNED.equals(string)) {
                enforceFlags = 1;
            } else if (STR_ENFORCE_VALIDITY.equals(string)) {
                enforceFlags = 7;
            }
        }
    }

    public DefaultAuthorizationEngine(BundleContext bundleContext, State state) {
        super(bundleContext);
        this.bundleContext = bundleContext;
        this.systemState = state;
    }

    protected AuthorizationEvent doAuthorize(SignedContent signedContent, Object object) {
        boolean bl = this.isEnabled(signedContent, object);
        AuthorizationEvent authorizationEvent = null;
        if (object instanceof Bundle) {
            BundleDescription bundleDescription = this.systemState.getBundle(((Bundle)object).getBundleId());
            if (!bl) {
                DisabledInfo disabledInfo = new DisabledInfo(POLICY_NAME, null, bundleDescription);
                this.systemState.addDisabledInfo(disabledInfo);
                authorizationEvent = new AuthorizationEvent(1, signedContent, object, 0);
            } else {
                DisabledInfo disabledInfo = this.systemState.getDisabledInfo(bundleDescription, POLICY_NAME);
                if (disabledInfo != null) {
                    this.systemState.removeDisabledInfo(disabledInfo);
                }
                authorizationEvent = new AuthorizationEvent(0, signedContent, object, 0);
            }
        }
        return authorizationEvent;
    }

    private boolean isEnabled(SignedContent signedContent, Object object) {
        Object[] objectArray;
        if (object instanceof Bundle && DevClassPathHelper.inDevelopmentMode() && (objectArray = DevClassPathHelper.getDevClassPath(((Bundle)object).getSymbolicName())) != null && objectArray.length > 0) {
            return true;
        }
        if (!((enforceFlags & 1) == 0 || signedContent != null && signedContent.isSigned())) {
            return false;
        }
        objectArray = signedContent == null ? new SignerInfo[]{} : signedContent.getSignerInfos();
        int n = 0;
        while (n < objectArray.length) {
            if ((enforceFlags & 2) != 0 && !objectArray[n].isTrusted()) {
                return false;
            }
            if ((enforceFlags & 4) != 0) {
                try {
                    signedContent.checkValidity((SignerInfo)objectArray[n]);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public int getStatus() {
        if (this.systemState.getDisabledBundles().length != 0) {
            return 1;
        }
        return 0;
    }

    public void processInstalledBundles() {
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = 0;
        while (n < bundleArray.length) {
            BaseData baseData = (BaseData)((AbstractBundle)bundleArray[n]).getBundleData();
            SignedStorageHook signedStorageHook = (SignedStorageHook)baseData.getStorageHook(SignedStorageHook.KEY);
            SignedContent signedContent = signedStorageHook != null ? signedStorageHook.getSignedContent() : null;
            this.authorize(signedContent, bundleArray[n]);
            ++n;
        }
    }

    public void setLoadPolicy(int n) {
        if ((n | 1 | 2 | 4) != 7) {
            throw new IllegalArgumentException("Invalid policy: " + n);
        }
        enforceFlags = n;
        Properties properties = new Properties();
        properties.setProperty(POLICY_PROP, Integer.toString(n));
        properties.setProperty(VERSION_PROP, VERSION_NUM);
        try {
            properties.store(new FileOutputStream(policyFile), null);
        }
        catch (IOException iOException) {
            SignedBundleHook.log("Error saving load policy file", 4, iOException);
        }
    }

    public int getLoadPolicy() {
        return enforceFlags;
    }
}

