/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPart
implements IWorkbenchPart2,
IExecutableExtension,
IWorkbenchPartOrientation {
    private String title = "";
    private ImageDescriptor imageDescriptor;
    private Image titleImage;
    private String toolTip = "";
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private ListenerList propChangeListeners = new ListenerList(2);
    private String partName = "";
    private String contentDescription = "";

    protected WorkbenchPart() {
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.propChangeListeners.add((Object)iPropertyListener);
    }

    public abstract void createPartControl(Composite var1);

    public void dispose() {
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
        }
        if (!this.propChangeListeners.isEmpty()) {
            this.propChangeListeners = new ListenerList(1);
        }
    }

    protected void firePropertyChange(final int n) {
        Object[] objectArray = this.propChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPropertyListener.propertyChanged(WorkbenchPart.this, n);
                }
            });
            ++n2;
        }
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    public String getTitleToolTip() {
        return this.toolTip;
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.propChangeListeners.remove((Object)iPropertyListener);
    }

    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
        this.title = this.partName = Util.safeString(iConfigurationElement.getAttribute("name"));
        String string2 = iConfigurationElement.getAttribute("icon");
        if (string2 == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getDeclaringExtension().getNamespace(), string2);
        if (this.imageDescriptor == null) {
            return;
        }
        this.titleImage = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
    }

    protected void setSite(IWorkbenchPartSite iWorkbenchPartSite) {
        this.checkSite(iWorkbenchPartSite);
        this.partSite = iWorkbenchPartSite;
    }

    protected void checkSite(IWorkbenchPartSite iWorkbenchPartSite) {
    }

    protected void setTitle(String string) {
        if (Util.equals(this.title, string = Util.safeString(string))) {
            return;
        }
        this.title = string;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image image) {
        Assert.isTrue(image == null || !image.isDisposed());
        if (this.titleImage == image) {
            return;
        }
        this.titleImage = image;
        this.firePropertyChange(1);
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
            this.imageDescriptor = null;
        }
    }

    protected void setTitleToolTip(String string) {
        if (Util.equals(this.toolTip, string = Util.safeString(string))) {
            return;
        }
        this.toolTip = string;
        this.firePropertyChange(1);
    }

    public void showBusy(boolean bl) {
    }

    public String getPartName() {
        return this.partName;
    }

    protected void setPartName(String string) {
        this.internalSetPartName(string);
        this.setDefaultTitle();
    }

    void setDefaultTitle() {
        String string;
        String string2 = this.getContentDescription();
        String string3 = string = this.getPartName();
        if (!Util.equals(string2, "")) {
            string3 = MessageFormat.format(WorkbenchMessages.WorkbenchPart_AutoTitleFormat, string, string2);
        }
        this.setTitle(string3);
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    protected void setContentDescription(String string) {
        this.internalSetContentDescription(string);
        this.setDefaultTitle();
    }

    void internalSetContentDescription(String string) {
        Assert.isNotNull(string);
        if (Util.equals(this.contentDescription, string)) {
            return;
        }
        this.contentDescription = string;
        this.firePropertyChange(261);
    }

    void internalSetPartName(String string) {
        string = Util.safeString(string);
        Assert.isNotNull(string);
        if (Util.equals(this.partName, string)) {
            return;
        }
        this.partName = string;
        this.firePropertyChange(260);
    }

    public int getOrientation() {
        return 0;
    }
}

