/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class ReplaceFeatureVersionOperation
extends FeatureOperation
implements IConfigFeatureOperation {
    private IFeature anotherFeature;

    public ReplaceFeatureVersionOperation(IFeature iFeature, IFeature iFeature2) {
        super(iFeature.getSite().getCurrentConfiguredSite(), iFeature);
        this.anotherFeature = iFeature2;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        IStatus iStatus = OperationsManager.getValidator().validatePendingReplaceVersion(this.feature, this.anotherFeature);
        if (iStatus != null) {
            throw new CoreException(iStatus);
        }
        PatchCleaner patchCleaner = new PatchCleaner(this.targetSite, this.feature);
        this.targetSite.unconfigure(this.feature);
        patchCleaner.dispose();
        this.targetSite.configure(this.anotherFeature);
        try {
            boolean bl = false;
            IFeatureOperation iFeatureOperation = OperationsManager.findPendingOperation(this.feature);
            if (iFeatureOperation instanceof IConfigFeatureOperation) {
                OperationsManager.removePendingOperation(iFeatureOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                bl = true;
            }
            iFeatureOperation = OperationsManager.findPendingOperation(this.anotherFeature);
            if (iFeatureOperation instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation(iFeatureOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                bl = true;
            }
            this.markProcessed();
            if (iOperationListener != null) {
                iOperationListener.afterExecute(this, null);
            }
            bl = SiteManager.getLocalSite().save() && bl;
            OperationsManager.fireObjectChanged(this.feature, null);
            return bl;
        }
        catch (CoreException coreException) {
            this.undo();
            UpdateUtils.logException(coreException);
            throw coreException;
        }
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.anotherFeature);
        this.targetSite.configure(this.feature);
    }
}

