/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FolderLayout;
import org.eclipse.ui.internal.LayoutHelper;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayout;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class PageLayout
implements IPageLayout {
    private ArrayList actionSets = new ArrayList(3);
    private IPerspectiveDescriptor descriptor;
    private LayoutPart editorFolder;
    private boolean editorVisible = true;
    private boolean fixed;
    private ArrayList fastViews = new ArrayList(3);
    private Map mapIDtoFolder = new HashMap(10);
    private Map mapIDtoPart = new HashMap(10);
    private Map mapIDtoViewLayoutRec = new HashMap(10);
    private ArrayList newWizardShortcuts = new ArrayList(3);
    private ArrayList perspectiveShortcuts = new ArrayList(3);
    private ViewSashContainer rootLayoutContainer;
    private ArrayList showInPartIds = new ArrayList(3);
    private ArrayList showViewShortcuts = new ArrayList(3);
    private ViewFactory viewFactory;

    public PageLayout() {
    }

    public PageLayout(ViewSashContainer viewSashContainer, ViewFactory viewFactory, LayoutPart layoutPart, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.viewFactory = viewFactory;
        this.rootLayoutContainer = viewSashContainer;
        this.editorFolder = layoutPart;
        this.descriptor = iPerspectiveDescriptor;
        this.prefill();
    }

    private void addEditorArea() {
        try {
            LayoutPart layoutPart = this.createView("org.eclipse.ui.editorss");
            if (layoutPart == null) {
                return;
            }
            this.setRefPart("org.eclipse.ui.editorss", layoutPart);
            this.rootLayoutContainer.add(layoutPart);
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "addEditorArea()", (Throwable)((Object)partInitException));
        }
    }

    public void addActionSet(String string) {
        if (!this.actionSets.contains(string)) {
            this.actionSets.add(string);
        }
    }

    public void addFastView(String string) {
        this.addFastView(string, -1.0f);
    }

    public void addFastView(String string, float f) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        if (string != null) {
            try {
                IViewReference iViewReference = this.viewFactory.createView(string);
                this.fastViews.add(iViewReference);
                ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
                if (f >= 0.05f && f <= 0.95f) {
                    viewLayoutRec.fastViewWidthRatio = f;
                }
            }
            catch (PartInitException partInitException) {
                WorkbenchPlugin.log(this.getClass(), "addFastView", (Throwable)((Object)partInitException));
            }
        }
    }

    private boolean isFastViewId(String string) {
        int n = 0;
        while (n < this.fastViews.size()) {
            if (((IViewReference)this.fastViews.get(n)).getId().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    ViewLayoutRec getViewLayoutRec(String string, boolean bl) {
        Assert.isTrue(this.getRefPart(string) != null || this.isFastViewId(string));
        ViewLayoutRec viewLayoutRec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(string);
        if (viewLayoutRec == null && bl) {
            viewLayoutRec = new ViewLayoutRec();
            if (this.isFixed()) {
                viewLayoutRec.isCloseable = false;
                viewLayoutRec.isMoveable = false;
            }
            this.mapIDtoViewLayoutRec.put(string, viewLayoutRec);
        }
        return viewLayoutRec;
    }

    public void addNewWizardShortcut(String string) {
        if (!this.newWizardShortcuts.contains(string)) {
            this.newWizardShortcuts.add(string);
        }
    }

    private void addPart(LayoutPart layoutPart, String string, int n, float f, String string2) {
        this.setRefPart(string, layoutPart);
        LayoutPart layoutPart2 = this.getFolderPart(string2);
        if (layoutPart2 == null) {
            layoutPart2 = this.getRefPart(string2);
        }
        if (layoutPart2 != null) {
            f = this.normalizeRatio(f);
            this.rootLayoutContainer.add(layoutPart, this.getPartSashConst(n), f, layoutPart2);
        } else {
            this.rootLayoutContainer.add(layoutPart);
        }
    }

    public void addPerspectiveShortcut(String string) {
        if (!this.perspectiveShortcuts.contains(string)) {
            this.perspectiveShortcuts.add(string);
        }
    }

    public void addPlaceholder(String string, int n, float f, String string2) {
        if (!this.checkValidPlaceholderId(string)) {
            return;
        }
        PartPlaceholder partPlaceholder = new PartPlaceholder(string);
        this.addPart(partPlaceholder, string, n, f, string2);
        this.getViewLayoutRec(string, true);
    }

    boolean checkValidPlaceholderId(String string) {
        IViewRegistry iViewRegistry;
        IViewDescriptor iViewDescriptor;
        if (this.checkPartInLayout(string)) {
            return false;
        }
        String string2 = ViewFactory.extractPrimaryId(string);
        if (!ViewFactory.hasWildcard(string2) && (iViewDescriptor = (iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry()).find(string2)) == null) {
            WorkbenchPlugin.log("Unable to find view with id: " + string2 + ", when creating perspective " + this.getDescriptor().getId());
            return false;
        }
        return true;
    }

    public void addShowInPart(String string) {
        if (!this.showInPartIds.contains(string)) {
            this.showInPartIds.add(string);
        }
    }

    public void addShowViewShortcut(String string) {
        if (!this.showViewShortcuts.contains(string)) {
            this.showViewShortcuts.add(string);
        }
    }

    public void addView(String string, int n, float f, String string2) {
        this.addView(string, n, f, string2, false, true);
    }

    private void addView(String string, int n, float f, String string2, boolean bl, boolean bl2) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        try {
            LayoutPart layoutPart = this.createView(string);
            if (layoutPart == null) {
                this.addPlaceholder(string, n, f, string2);
            } else {
                ViewStack viewStack = new ViewStack(this.rootLayoutContainer.page, true, 2);
                viewStack.add(layoutPart);
                this.setFolderPart(string, viewStack);
                this.addPart(viewStack, string, n, f, string2);
                this.getViewLayoutRec(string, true);
            }
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "addView", (Throwable)((Object)partInitException));
        }
    }

    boolean checkPartInLayout(String string) {
        if (this.getRefPart(string) != null || this.isFastViewId(string)) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_duplicateRefPart, (Object)string));
            return true;
        }
        return false;
    }

    public IFolderLayout createFolder(String string, int n, float f, String string2) {
        if (this.checkPartInLayout(string)) {
            return new FolderLayout(this, (ViewStack)this.getRefPart(string), this.viewFactory);
        }
        ViewStack viewStack = new ViewStack(this.rootLayoutContainer.page);
        viewStack.setID(string);
        this.addPart(viewStack, string, n, f, string2);
        return new FolderLayout(this, viewStack, this.viewFactory);
    }

    public IPlaceholderFolderLayout createPlaceholderFolder(String string, int n, float f, String string2) {
        ContainerPlaceholder containerPlaceholder = new ContainerPlaceholder(null);
        containerPlaceholder.setContainer(this.rootLayoutContainer);
        containerPlaceholder.setRealContainer(new ViewStack(this.rootLayoutContainer.page));
        containerPlaceholder.setID(string);
        this.addPart(containerPlaceholder, string, n, f, string2);
        return null;
    }

    private LayoutPart createView(String string) throws PartInitException {
        if (string.equals("org.eclipse.ui.editorss")) {
            return this.editorFolder;
        }
        return LayoutHelper.createView(this.getViewFactory(), string);
    }

    public ArrayList getActionSets() {
        return this.actionSets;
    }

    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    public int getEditorReuseThreshold() {
        return -1;
    }

    public ArrayList getFastViews() {
        return this.fastViews;
    }

    private ViewStack getFolderPart(String string) {
        return (ViewStack)this.mapIDtoFolder.get(string);
    }

    public ArrayList getNewWizardShortcuts() {
        return this.newWizardShortcuts;
    }

    private int getPartSashConst(int n) {
        return n;
    }

    public ArrayList getPerspectiveShortcuts() {
        return this.perspectiveShortcuts;
    }

    LayoutPart getRefPart(String string) {
        return (LayoutPart)this.mapIDtoPart.get(string);
    }

    public ViewSashContainer getRootLayoutContainer() {
        return this.rootLayoutContainer;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public ArrayList getShowViewShortcuts() {
        return this.showViewShortcuts;
    }

    ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public boolean isEditorAreaVisible() {
        return this.editorVisible;
    }

    private float normalizeRatio(float f) {
        if (f < 0.05f) {
            f = 0.05f;
        }
        if (f > 0.95f) {
            f = 0.95f;
        }
        return f;
    }

    private void prefill() {
    }

    public void setEditorAreaVisible(boolean bl) {
        this.editorVisible = bl;
    }

    public void setEditorReuseThreshold(int n) {
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    void setFolderPart(String string, ContainerPlaceholder containerPlaceholder) {
        LayoutPart layoutPart = containerPlaceholder.getRealContainer();
        this.mapIDtoFolder.put(string, layoutPart);
    }

    void setFolderPart(String string, ViewStack viewStack) {
        this.mapIDtoFolder.put(string, viewStack);
    }

    void setRefPart(String string, LayoutPart layoutPart) {
        this.mapIDtoPart.put(string, layoutPart);
    }

    private void stackPart(LayoutPart layoutPart, String string, String string2) {
        this.setRefPart(string, layoutPart);
        this.getViewLayoutRec(string, true);
        ViewStack viewStack = this.getFolderPart(string2);
        if (viewStack != null) {
            viewStack.add(layoutPart);
            this.setFolderPart(string, viewStack);
            return;
        }
        LayoutPart layoutPart2 = this.getRefPart(string2);
        if (layoutPart2 != null) {
            ViewStack viewStack2 = new ViewStack(this.rootLayoutContainer.page);
            this.rootLayoutContainer.replace(layoutPart2, viewStack2);
            viewStack2.add(layoutPart2);
            viewStack2.add(layoutPart);
            this.setFolderPart(string2, viewStack2);
            this.setFolderPart(string, viewStack2);
            return;
        }
        WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_missingRefPart, (Object)string2));
        this.rootLayoutContainer.add(layoutPart);
    }

    public void stackPlaceholder(String string, String string2) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        PartPlaceholder partPlaceholder = new PartPlaceholder(string);
        LayoutPart layoutPart = this.getRefPart(string2);
        if (layoutPart != null) {
            partPlaceholder.setContainer(layoutPart.getContainer());
        }
        this.stackPart(partPlaceholder, string, string2);
    }

    public void stackView(String string, String string2) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        try {
            LayoutPart layoutPart = this.createView(string);
            if (layoutPart == null) {
                this.stackPlaceholder(string, string2);
            } else {
                this.stackPart(layoutPart, string, string2);
            }
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "stackView", (Throwable)((Object)partInitException));
        }
    }

    public static int swtConstantToLayoutPosition(int n) {
        switch (n) {
            case 128: {
                return 3;
            }
            case 1024: {
                return 4;
            }
            case 131072: {
                return 2;
            }
            case 16384: {
                return 1;
            }
        }
        return -1;
    }

    public void addStandaloneView(String string, boolean bl, int n, float f, String string2) {
        this.addView(string, n, f, string2, true, bl);
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
        viewLayoutRec.isStandalone = true;
        viewLayoutRec.showTitle = bl;
    }

    public IViewLayout getViewLayout(String string) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
        if (viewLayoutRec == null) {
            return null;
        }
        return new ViewLayout(this, viewLayoutRec);
    }

    public Map getIDtoViewLayoutRecMap() {
        return this.mapIDtoViewLayoutRec;
    }
}

