/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

class ViewFactory
implements IExtensionChangeHandler {
    private ReferenceCounter counter;
    private HashMap mementoTable = new HashMap();
    private WorkbenchPage page;
    private IViewRegistry viewReg;
    static final String ID_SEP = ":";
    static /* synthetic */ Class class$0;

    static String getKey(String string, String string2) {
        return string2 == null ? string : String.valueOf(string) + ID_SEP + string2;
    }

    static String getKey(IViewReference iViewReference) {
        return ViewFactory.getKey(iViewReference.getId(), iViewReference.getSecondaryId());
    }

    static String extractPrimaryId(String string) {
        int n = string.lastIndexOf(ID_SEP);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String extractSecondaryId(String string) {
        int n = string.lastIndexOf(ID_SEP);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    static boolean hasWildcard(String string) {
        return string.indexOf(PartPlaceholder.WILD_CARD) >= 0;
    }

    public ViewFactory(WorkbenchPage workbenchPage, IViewRegistry iViewRegistry) {
        this.page = workbenchPage;
        this.viewReg = iViewRegistry;
        this.counter = new ReferenceCounter();
        workbenchPage.getExtensionTracker().registerHandler((IExtensionChangeHandler)this, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus busyRestoreView(IViewReference iViewReference) {
        ViewReference viewReference = (ViewReference)iViewReference;
        IStatus iStatus = Status.OK_STATUS;
        if (viewReference.getPart(false) != null) {
            return Status.OK_STATUS;
        }
        if (viewReference.creationInProgress) {
            IStatus iStatus2 = WorkbenchPlugin.getStatus((Throwable)((Object)new PartInitException(NLS.bind((String)"Warning: Detected attempt by view {0} to create itself recursively (this is probably, but not necessarily, a bug)", (Object)viewReference.getId()))));
            WorkbenchPlugin.log(iStatus2);
            return iStatus2;
        }
        try {
            viewReference.creationInProgress = true;
            iStatus = this.busyRestoreViewHelper(viewReference);
            if (viewReference.getPart(false) == null) {
                StatusUtil.newStatus(iStatus, NLS.bind((String)WorkbenchMessages.ViewFactory_initException, (Object)iStatus.getMessage()));
                IStatus iStatus3 = StatusUtil.newStatus(iStatus, NLS.bind((String)"Unable to create view ID {0}: {1}", (Object)viewReference.getId(), (Object)iStatus.getMessage()));
                WorkbenchPlugin.log(iStatus3);
                String string = iViewReference.getId();
                IViewDescriptor iViewDescriptor = this.viewReg.find(viewReference.getId());
                if (iViewDescriptor != null) {
                    string = iViewDescriptor.getLabel();
                }
                PartPane partPane = viewReference.getPane();
                new ViewSite(viewReference, null, this.page, iViewReference.getId(), "org.eclipse.ui", string);
                Composite composite = (Composite)partPane.getControl();
                Composite composite2 = new Composite(composite, 524288);
                composite2.setLayout((Layout)new FillLayout());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            viewReference.creationInProgress = false;
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        viewReference.creationInProgress = false;
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus busyRestoreViewHelper(ViewReference viewReference) {
        IStatus iStatus = Status.OK_STATUS;
        if (iStatus.getSeverity() != 0) {
            return iStatus;
        }
        String string = ViewFactory.getKey(viewReference);
        IMemento iMemento = this.getViewState(string);
        IViewDescriptor iViewDescriptor = this.viewReg.find(viewReference.getId());
        if (iViewDescriptor == null) {
            return new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_couldNotCreate, null);
        }
        PartPane partPane = viewReference.getPane();
        partPane.createControl(this.page.getClientComposite());
        String string2 = iViewDescriptor.getLabel();
        Composite composite = null;
        IWorkbenchPart iWorkbenchPart = null;
        PartSite partSite = null;
        try {
            Object var12_17;
            IViewPart iViewPart = null;
            try {
                UIStats.start(0, string2);
                iViewPart = iViewDescriptor.createView();
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                UIStats.end(0, iViewPart, string2);
                throw throwable;
            }
            {
                var12_17 = null;
            }
            UIStats.end(0, iViewPart, string2);
            partSite = new ViewSite(viewReference, iViewPart, this.page, iViewDescriptor);
            try {
                UIStats.start(2, string2);
                iViewPart.init((IViewSite)((Object)partSite), iMemento);
                iWorkbenchPart = iViewPart;
            }
            catch (Throwable throwable) {
                var12_17 = null;
                UIStats.end(2, iViewPart, string2);
                throw throwable;
            }
            {
                var12_17 = null;
            }
            UIStats.end(2, iViewPart, string2);
            if (iViewPart.getSite() != partSite) {
                return WorkbenchPlugin.getStatus(WorkbenchMessages.ViewFactory_siteException, null);
            }
            int n = 0;
            if (iViewPart instanceof WorkbenchPart) {
                n = ((WorkbenchPart)((Object)iViewPart)).getOrientation();
            }
            Composite composite2 = (Composite)partPane.getControl();
            composite = new Composite(composite2, n | 0x80000);
            composite.setLayout((Layout)new FillLayout());
            try {
                UIStats.start(1, string2);
                iViewPart.createPartControl(composite);
                composite2.layout(true);
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                UIStats.end(1, iViewPart, string2);
                throw throwable;
            }
            {
                Object var14_25 = null;
            }
            UIStats.end(1, iViewPart, string2);
            viewReference.setPart(iViewPart);
            viewReference.refreshFromPart();
            viewReference.releaseReferences();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            if ((composite2 = (IConfigurationElement)iViewDescriptor.getAdapter(clazz)) != null) {
                this.page.getExtensionTracker().registerObject(composite2.getDeclaringExtension(), (Object)iViewPart, 2);
            }
            this.page.addPart(viewReference);
            this.page.firePartOpened(iViewPart);
            return iStatus;
        }
        catch (Exception exception) {
            if (composite != null) {
                try {
                    composite.dispose();
                }
                catch (RuntimeException runtimeException) {
                    WorkbenchPlugin.log(runtimeException);
                }
            }
            if (iWorkbenchPart != null) {
                try {
                    iWorkbenchPart.dispose();
                }
                catch (RuntimeException runtimeException) {
                    WorkbenchPlugin.log(runtimeException);
                }
            }
            if (partSite == null) return WorkbenchPlugin.getStatus(exception);
            try {
                partSite.dispose();
                return WorkbenchPlugin.getStatus(exception);
            }
            catch (RuntimeException runtimeException) {
                WorkbenchPlugin.log(runtimeException);
            }
            return WorkbenchPlugin.getStatus(exception);
        }
    }

    public IViewReference createView(String string) throws PartInitException {
        return this.createView(string, null);
    }

    public IViewReference createView(String string, String string2) throws PartInitException {
        IViewDescriptor iViewDescriptor = this.viewReg.find(string);
        if (iViewDescriptor == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)string));
        }
        if (string2 != null && !iViewDescriptor.getAllowMultiple()) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_noMultiple, (Object)string));
        }
        String string3 = ViewFactory.getKey(string, string2);
        IViewReference iViewReference = (IViewReference)this.counter.get(string3);
        if (iViewReference == null) {
            IMemento iMemento = (IMemento)this.mementoTable.get(string3);
            iViewReference = new ViewReference(string, string2, iMemento);
            this.counter.put(string3, iViewReference);
        } else {
            this.counter.addRef(string3);
        }
        return iViewReference;
    }

    private void destroyView(IViewPart iViewPart) {
        PartSite partSite = (PartSite)iViewPart.getSite();
        PartPane partPane = partSite.getPane();
        partPane.dispose();
        partSite.dispose();
    }

    public IViewReference getView(String string) {
        return this.getView(string, null);
    }

    public IViewReference getView(String string, String string2) {
        String string3 = ViewFactory.getKey(string, string2);
        return (IViewReference)this.counter.get(string3);
    }

    public IViewRegistry getViewRegistry() {
        return this.viewReg;
    }

    public IViewReference[] getViews() {
        List list = this.counter.values();
        IViewReference[] iViewReferenceArray = new IViewReference[list.size()];
        list.toArray(iViewReferenceArray);
        return iViewReferenceArray;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public boolean hasView(IViewReference iViewReference) {
        return this.hasView(iViewReference.getId(), iViewReference.getSecondaryId());
    }

    public boolean hasView(String string) {
        return this.hasView(string, null);
    }

    public boolean hasView(String string, String string2) {
        return this.getView(string, string2) != null;
    }

    public void releaseView(IViewReference iViewReference) {
        IViewPart iViewPart;
        String string = ViewFactory.getKey(iViewReference);
        IViewReference iViewReference2 = (IViewReference)this.counter.get(string);
        if (iViewReference2 == null) {
            return;
        }
        int n = this.counter.removeRef(string);
        if (n <= 0 && (iViewPart = (IViewPart)iViewReference2.getPart(false)) != null) {
            this.destroyView(iViewPart);
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("view");
        int n = 0;
        while (n < iMementoArray.length) {
            this.restoreViewState(iMementoArray[n]);
            ++n;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus restoreView(IViewReference iViewReference) {
        IStatus[] iStatusArray = new IStatus[]{this.busyRestoreView(iViewReference)};
        return iStatusArray[0];
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_problemsSavingViews, null);
        IViewReference[] iViewReferenceArray = this.getViews();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            this.saveViewState(iMemento, iViewReferenceArray[n], multiStatus);
            ++n;
        }
        return multiStatus;
    }

    public IMemento saveViewState(IMemento iMemento, IViewReference iViewReference, MultiStatus multiStatus) {
        final MultiStatus multiStatus2 = multiStatus;
        final IMemento iMemento2 = iMemento.createChild("view");
        iMemento2.putString("id", ViewFactory.getKey(iViewReference));
        if (iViewReference instanceof ViewReference) {
            iMemento2.putString("partName", ((ViewReference)iViewReference).getPartName());
        }
        final IViewReference iViewReference2 = iViewReference;
        final IViewPart iViewPart = (IViewPart)iViewReference.getPart(false);
        if (iViewPart != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iViewPart.saveState(iMemento2.createChild("viewState"));
                }

                public void handleException(Throwable throwable) {
                    multiStatus2.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotSave, (Object)iViewReference2.getTitle()), throwable));
                }
            });
        } else {
            IMemento iMemento3 = this.getViewState(ViewFactory.getKey(iViewReference));
            if (iMemento3 != null) {
                IMemento iMemento4 = iMemento2.createChild("viewState");
                iMemento4.putMemento(iMemento3);
            }
        }
        return iMemento2;
    }

    public void restoreViewState(IMemento iMemento) {
        String string = iMemento.getString("id");
        this.mementoTable.put(string, iMemento);
    }

    private IMemento getViewState(String string) {
        IMemento iMemento = (IMemento)this.mementoTable.get(string);
        if (iMemento == null) {
            return null;
        }
        return iMemento.getChild("viewState");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IViewPart) {
                IViewPart iViewPart = (IViewPart)objectArray[n];
                this.page.hideView(iViewPart);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }

    private class ViewReference
    extends WorkbenchPartReference
    implements IViewReference {
        private String secondaryId;
        private boolean create = true;
        private boolean creationInProgress = false;

        public ViewReference(String string, IMemento iMemento) {
            this(string, null, iMemento);
        }

        public ViewReference(String string, String string2, IMemento iMemento) {
            ViewDescriptor viewDescriptor = (ViewDescriptor)ViewFactory.this.viewReg.find(string);
            ImageDescriptor imageDescriptor = null;
            String string3 = null;
            if (viewDescriptor != null) {
                imageDescriptor = viewDescriptor.getImageDescriptor();
                string3 = viewDescriptor.getLabel();
            }
            String string4 = null;
            if (iMemento != null) {
                string4 = iMemento.getString("partName");
            }
            if (string4 == null) {
                string4 = string3;
            }
            this.init(string, string3, null, imageDescriptor, string4, null);
            this.secondaryId = string2;
        }

        protected PartPane createPane() {
            return new ViewPane(this, ViewFactory.this.page);
        }

        public void dispose() {
            super.dispose();
            this.create = false;
        }

        public IWorkbenchPage getPage() {
            return ViewFactory.this.page;
        }

        public IWorkbenchPart getPart(boolean bl) {
            if (this.part != null) {
                return this.part;
            }
            if (!this.create) {
                return null;
            }
            if (bl) {
                ViewFactory.this.restoreView(this);
            }
            return this.part;
        }

        public String getRegisteredName() {
            if (this.part != null && this.part.getSite() != null) {
                return this.part.getSite().getRegisteredName();
            }
            IViewRegistry iViewRegistry = ViewFactory.this.viewReg;
            IViewDescriptor iViewDescriptor = iViewRegistry.find(this.getId());
            if (iViewDescriptor != null) {
                return iViewDescriptor.getLabel();
            }
            return this.getTitle();
        }

        protected String computePartName() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computePartName();
            }
            return this.getRegisteredName();
        }

        protected String computeContentDescription() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computeContentDescription();
            }
            String string = this.getRawTitle();
            if (!Util.equals(string, this.getRegisteredName())) {
                return string;
            }
            return "";
        }

        public String getSecondaryId() {
            return this.secondaryId;
        }

        public IViewPart getView(boolean bl) {
            return (IViewPart)this.getPart(bl);
        }

        public boolean isFastView() {
            return ViewFactory.this.page.isFastView(this);
        }
    }
}

