/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.CommandHandle;
import org.eclipse.ercp.swt.mobile.CommandListener;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Command
extends Item {
    Control control;
    int type;
    int priority;
    int accelerator;
    boolean enabled;
    boolean defaultCommand;
    String label;
    Vector listeners = null;
    private static CommandHandle cmdHandle = new CommandHandle();
    private boolean dispose = false;
    private static boolean hasHandleFocusIn = false;
    int selectionListenerCount = 0;
    public static final int GENERAL = 1;
    public static final int SELECT = 2;
    public static final int COMMANDGROUP = 10;
    public static final int OK = 3;
    public static final int CANCEL = 4;
    public static final int DELETE = 5;
    public static final int BACK = 6;
    public static final int EXIT = 7;
    public static final int STOP = 8;
    public static final int HELP = 9;

    boolean isValidSubclass() {
        return this.isValidClass(this.getClass());
    }

    boolean isValidClass(Class clazz) {
        int index;
        String name = clazz.getName();
        return name.substring(0, (index = name.lastIndexOf(46)) + 1).equals("org.eclipse.ercp.swt.mobile.");
    }

    public Command(Command command, int type, int priority) {
        super(cmdHandle.findControl(command), 0);
        Control control;
        if (command == null) {
            SWT.error(4);
        }
        if (priority < 0 || command.type != 10) {
            SWT.error(5);
        }
        if (type < 0 || type > 10) {
            SWT.error(5);
        }
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        final Command c = this;
        command.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                c.internal_sendEvent(12);
            }
        });
        this.control = control = cmdHandle.findControl(command);
        this.type = type;
        this.priority = priority;
        this.accelerator = 0;
        this.enabled = true;
        cmdHandle.add(command, this);
    }

    public Command(Control control, int type, int priority) {
        super(control, 0);
        if (control == null) {
            SWT.error(4);
        }
        if (type < 0 || type > 10) {
            SWT.error(5);
        }
        if (priority < 0) {
            SWT.error(5);
        }
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        final Command c = this;
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                c.internal_sendEvent(12);
                c.dispose();
            }
        });
        if (!hasHandleFocusIn) {
            control.getDisplay().addFilter(15, cmdHandle);
            control.getDisplay().addFilter(16, cmdHandle);
            hasHandleFocusIn = true;
        }
        this.control = control;
        this.type = type;
        this.priority = priority;
        this.accelerator = 0;
        this.enabled = true;
        cmdHandle.add(control, this);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
        ++this.selectionListenerCount;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public String getLongLabel() {
        this.checkWidget();
        return this.label;
    }

    public int getPriority() {
        this.checkWidget();
        return this.priority;
    }

    public boolean isDefaultCommand() {
        this.checkWidget();
        return this.defaultCommand;
    }

    public boolean isEnabled() {
        this.checkWidget();
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        return cmdHandle.isEnabled(this) && this.control.isEnabled();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
        --this.selectionListenerCount;
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        boolean remakemenu = false;
        if (this.accelerator != accelerator && this.isFocusControl()) {
            remakemenu = true;
        }
        this.accelerator = accelerator;
        if (remakemenu) {
            cmdHandle.makeMenu(this);
        }
    }

    public void setDefaultCommand() {
        this.checkWidget();
        this.defaultCommand = true;
        cmdHandle.setDefaultCommand(this);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        boolean remakemenu = false;
        if (this.enabled != enabled && this.isFocusControl()) {
            remakemenu = true;
        }
        this.enabled = enabled;
        if (remakemenu) {
            cmdHandle.makeMenu(this);
        }
    }

    public void setLongLabel(String label) {
        this.checkWidget();
        boolean remakemenu = false;
        if (this.isFocusControl()) {
            if (this.label == null) {
                if (label != null) {
                    remakemenu = true;
                }
            } else if (label == null) {
                remakemenu = true;
            } else if (!this.label.equals(label)) {
                remakemenu = true;
            }
        }
        this.label = label;
        if (remakemenu) {
            cmdHandle.makeMenu(this);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        boolean remakemenu = false;
        if (!super.getText().equals(string) && this.isFocusControl()) {
            remakemenu = true;
        }
        super.setText(string);
        if (remakemenu) {
            cmdHandle.makeMenu(this);
        }
    }

    public void dispose() {
        if (this.listeners != null) {
            CommandHandle.CommandNode node = cmdHandle.findCommandNode(this);
            Enumeration elements = this.listeners.elements();
            while (elements.hasMoreElements()) {
                CommandListener cmdListener = (CommandListener)elements.nextElement();
                if (node != null && !node.isDispose() && node.item != null && !node.item.isDisposed()) {
                    node.item.removeListener(cmdListener.getEventType(), cmdListener);
                }
                Object var3_3 = null;
            }
            this.listeners.clear();
        }
        this.listeners = null;
        cmdHandle.removeCommand(this);
        this.dispose = true;
    }

    public boolean isDisposed() {
        return this.dispose;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        CommandListener commandListener = new CommandListener(this, eventType, listener);
        CommandHandle.CommandNode node = cmdHandle.findCommandNode(this);
        if (node != null && !node.isDispose() && node.item != null && !node.item.isDisposed()) {
            node.item.addListener(eventType, commandListener);
        }
        Enumeration elements = this.listeners.elements();
        while (elements.hasMoreElements()) {
            CommandListener cmdListener = (CommandListener)elements.nextElement();
            if (cmdListener.getEventType() != eventType || cmdListener.getListener() != listener) continue;
            return;
        }
        this.listeners.add(commandListener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.listeners == null) {
            return;
        }
        Enumeration elements = this.listeners.elements();
        while (elements.hasMoreElements()) {
            CommandListener cmdListener = (CommandListener)elements.nextElement();
            if (cmdListener.getEventType() != eventType || cmdListener.getListener() != listener) continue;
            CommandHandle.CommandNode node = cmdHandle.findCommandNode(this);
            if (node != null && !node.isDispose() && node.item != null && !node.item.isDisposed()) {
                node.item.removeListener(eventType, cmdListener);
            }
            this.listeners.remove(cmdListener);
            cmdListener = null;
            break;
        }
    }

    public void Command_SendEvent(int event) {
        this.internal_sendEvent(event);
    }

    public String toString() {
        return "Command {label:" + this.getText() + ", long label:" + this.label + ", type:" + this.type + ", priority:" + this.priority + "}";
    }

    private boolean isFocusControl() {
        if (this.control.isFocusControl() || this.control instanceof Shell && this.control.getDisplay().getActiveShell() == this.control) {
            return true;
        }
        if (this.control instanceof Composite) {
            return this.isChildFocusControl((Composite)this.control);
        }
        return false;
    }

    private boolean isChildFocusControl(Composite c) {
        if (c == null) {
            return false;
        }
        Control[] children = c.getChildren();
        if (children == null) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            Control child;
            if (children[i] == null) continue;
            if (children[i].isFocusControl()) {
                return true;
            }
            if ((children[i] instanceof Canvas || children[i] instanceof CaptionedControl || children[i] instanceof Composite) && this.isChildFocusControl((Composite)children[i])) {
                return true;
            }
            if (!(children[i] instanceof SortedList) || !(child = ((SortedList)children[i]).getchild()).isFocusControl()) continue;
            return true;
        }
        return false;
    }
}

