/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class DeadlockDetector {
    private static int NO_STATE = 0;
    private static int WAITING_FOR_LOCK = -1;
    private static final int[][] EMPTY_MATRIX = new int[0][0];
    private int[][] graph = EMPTY_MATRIX;
    private final ArrayList locks = new ArrayList();
    private final ArrayList lockThreads = new ArrayList();
    private boolean resize = false;

    DeadlockDetector() {
    }

    private boolean addCycleThreads(ArrayList arrayList, Thread thread) {
        Thread[] threadArray = this.blockingThreads(thread);
        if (threadArray.length == 0) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < threadArray.length) {
            if (arrayList.contains(threadArray[n])) {
                bl = true;
            } else {
                arrayList.add(threadArray[n]);
                if (this.addCycleThreads(arrayList, threadArray[n])) {
                    bl = true;
                } else {
                    arrayList.remove(threadArray[n]);
                }
            }
            ++n;
        }
        return bl;
    }

    private Thread[] blockingThreads(Thread thread) {
        ISchedulingRule iSchedulingRule = (ISchedulingRule)this.getWaitingLock(thread);
        return this.getThreadsOwningLock(iSchedulingRule);
    }

    private boolean checkWaitCycles(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < this.graph.length) {
            if (this.graph[n2][n] > NO_STATE) {
                if (nArray[n2] > NO_STATE) {
                    return true;
                }
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                int n4 = 0;
                while (n4 < this.graph[n2].length) {
                    if (this.graph[n2][n4] == WAITING_FOR_LOCK && this.checkWaitCycles(nArray, n4)) {
                        return true;
                    }
                    ++n4;
                }
                int n5 = n2;
                nArray[n5] = nArray[n5] - 1;
            }
            ++n2;
        }
        return false;
    }

    boolean contains(Thread thread) {
        return this.lockThreads.contains(thread);
    }

    private void fillPresentEntries(ISchedulingRule iSchedulingRule, int n) {
        int n2;
        int n3 = 0;
        while (n3 < this.locks.size()) {
            if (n3 != n && iSchedulingRule.isConflicting((ISchedulingRule)this.locks.get(n3))) {
                n2 = 0;
                while (n2 < this.graph.length) {
                    if (this.graph[n2][n3] > NO_STATE && this.graph[n2][n] == NO_STATE) {
                        this.graph[n2][n] = this.graph[n2][n3];
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.locks.size()) {
            if (n3 != n && iSchedulingRule.isConflicting((ISchedulingRule)this.locks.get(n3))) {
                n2 = 0;
                while (n2 < this.graph.length) {
                    if (this.graph[n2][n] > NO_STATE && this.graph[n2][n3] == NO_STATE) {
                        this.graph[n2][n3] = this.graph[n2][n];
                    }
                    ++n2;
                }
            }
            ++n3;
        }
    }

    private Object[] getOwnedLocks(Thread thread) {
        ArrayList arrayList = new ArrayList(1);
        int n = this.indexOf(thread, false);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            if (this.graph[n][n2] > NO_STATE) {
                arrayList.add(this.locks.get(n2));
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            Assert.isLegal((boolean)false, (String)"A thread with no locks is part of a deadlock.");
        }
        return arrayList.toArray();
    }

    private Thread[] getThreadsInDeadlock(Thread thread) {
        ArrayList<Thread> arrayList = new ArrayList<Thread>(2);
        if (this.ownsLocks(thread)) {
            arrayList.add(thread);
        }
        this.addCycleThreads(arrayList, thread);
        return arrayList.toArray(new Thread[arrayList.size()]);
    }

    private Thread[] getThreadsOwningLock(ISchedulingRule iSchedulingRule) {
        if (iSchedulingRule == null) {
            return new Thread[0];
        }
        int n = this.indexOf(iSchedulingRule, false);
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < this.graph.length) {
            if (this.graph[n2][n] > NO_STATE) {
                arrayList.add(this.lockThreads.get(n2));
            }
            ++n2;
        }
        if (arrayList.size() == 0 && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + iSchedulingRule + " is involved in deadlock but is not owned by any thread.");
        }
        if (arrayList.size() > 1 && iSchedulingRule instanceof ILock && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + iSchedulingRule + " is owned by more than 1 thread, but it is not a rule.");
        }
        return arrayList.toArray(new Thread[arrayList.size()]);
    }

    private Object getWaitingLock(Thread thread) {
        int n = this.indexOf(thread, false);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            if (this.graph[n][n2] == WAITING_FOR_LOCK) {
                return this.locks.get(n2);
            }
            ++n2;
        }
        return null;
    }

    private int indexOf(ISchedulingRule iSchedulingRule, boolean bl) {
        int n = this.locks.indexOf(iSchedulingRule);
        if (n < 0 && bl) {
            this.locks.add(iSchedulingRule);
            this.resize = true;
            n = this.locks.size() - 1;
        }
        return n;
    }

    private int indexOf(Thread thread, boolean bl) {
        int n = this.lockThreads.indexOf(thread);
        if (n < 0 && bl) {
            this.lockThreads.add(thread);
            this.resize = true;
            n = this.lockThreads.size() - 1;
        }
        return n;
    }

    boolean isEmpty() {
        return this.locks.size() == 0 && this.lockThreads.size() == 0 && this.graph.length == 0;
    }

    void lockAcquired(Thread thread, ISchedulingRule iSchedulingRule) {
        int n = this.indexOf(iSchedulingRule, true);
        int n2 = this.indexOf(thread, true);
        if (this.resize) {
            this.resizeGraph();
        }
        if (this.graph[n2][n] == WAITING_FOR_LOCK) {
            this.graph[n2][n] = NO_STATE;
        }
        ArrayList<ISchedulingRule> arrayList = new ArrayList<ISchedulingRule>(1);
        int n3 = 2;
        arrayList.add(iSchedulingRule);
        int[] nArray = this.graph[n2];
        int n4 = n;
        nArray[n4] = nArray[n4] + 1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < arrayList.size()) {
                ISchedulingRule iSchedulingRule2 = (ISchedulingRule)arrayList.get(n6);
                int n7 = 0;
                while (n7 < this.locks.size()) {
                    ISchedulingRule iSchedulingRule3 = (ISchedulingRule)this.locks.get(n7);
                    if (iSchedulingRule2.isConflicting(iSchedulingRule3) && !arrayList.contains(iSchedulingRule3)) {
                        arrayList.add(iSchedulingRule3);
                        int[] nArray2 = this.graph[n2];
                        int n8 = n7;
                        nArray2[n8] = nArray2[n8] + 1;
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    void lockReleased(Thread thread, ISchedulingRule iSchedulingRule) {
        int n = this.indexOf(iSchedulingRule, false);
        int n2 = this.indexOf(thread, false);
        if (n2 < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Lock " + iSchedulingRule + " was already released by thread " + thread.getName());
            }
            return;
        }
        if (n < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Thread " + thread.getName() + " already released lock " + iSchedulingRule);
            }
            return;
        }
        if (iSchedulingRule instanceof ILock && this.graph[n2][n] == WAITING_FOR_LOCK) {
            this.graph[n2][n] = NO_STATE;
            return;
        }
        int n3 = 0;
        while (n3 < this.graph[n2].length) {
            if (iSchedulingRule.isConflicting((ISchedulingRule)this.locks.get(n3)) || !(iSchedulingRule instanceof ILock) && !(this.locks.get(n3) instanceof ILock) && this.graph[n2][n3] > NO_STATE) {
                if (this.graph[n2][n3] == NO_STATE) {
                    if (JobManager.DEBUG_LOCKS) {
                        System.out.println("[lockReleased] More releases than acquires for thread " + thread.getName() + " and lock " + iSchedulingRule);
                    }
                } else {
                    int[] nArray = this.graph[n2];
                    int n4 = n3;
                    nArray[n4] = nArray[n4] - 1;
                }
            }
            ++n3;
        }
        if (this.graph[n2][n] == NO_STATE) {
            this.reduceGraph(n2, iSchedulingRule);
        }
    }

    void lockReleasedCompletely(Thread thread, ISchedulingRule iSchedulingRule) {
        int n = this.indexOf(iSchedulingRule, false);
        int n2 = this.indexOf(thread, false);
        if (n2 < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Lock " + iSchedulingRule + " was already released by thread " + thread.getName());
            }
            return;
        }
        if (n < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Thread " + thread.getName() + " already released lock " + iSchedulingRule);
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.graph[n2].length) {
            if (!(this.locks.get(n3) instanceof ILock) && this.graph[n2][n3] > NO_STATE) {
                this.graph[n2][n3] = NO_STATE;
            }
            ++n3;
        }
        this.reduceGraph(n2, iSchedulingRule);
    }

    Deadlock lockWaitStart(Thread thread, ISchedulingRule iSchedulingRule) {
        this.setToWait(thread, iSchedulingRule, false);
        int n = this.indexOf(iSchedulingRule, false);
        int[] nArray = new int[this.lockThreads.size()];
        if (!this.checkWaitCycles(nArray, n)) {
            return null;
        }
        Thread[] threadArray = this.getThreadsInDeadlock(thread);
        Thread thread2 = this.resolutionCandidate(threadArray);
        ISchedulingRule[] iSchedulingRuleArray = this.realLocksForThread(thread2);
        Deadlock deadlock = new Deadlock(threadArray, iSchedulingRuleArray, thread2);
        if (JobManager.DEBUG_LOCKS) {
            this.reportDeadlock(deadlock);
        }
        if (JobManager.DEBUG_DEADLOCK) {
            throw new IllegalStateException("Deadlock detected. Caused by thread " + thread.getName() + '.');
        }
        int n2 = 0;
        while (n2 < iSchedulingRuleArray.length) {
            this.setToWait(deadlock.getCandidate(), iSchedulingRuleArray[n2], true);
            ++n2;
        }
        return deadlock;
    }

    void lockWaitStop(Thread thread, ISchedulingRule iSchedulingRule) {
        int n = this.indexOf(iSchedulingRule, false);
        int n2 = this.indexOf(thread, false);
        if (n2 < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Thread " + thread.getName() + " was already removed.");
            }
            return;
        }
        if (n < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Lock " + iSchedulingRule + " was already removed.");
            }
            return;
        }
        if (this.graph[n2][n] != WAITING_FOR_LOCK) {
            Assert.isTrue((boolean)false, (String)("Thread " + thread.getName() + " was not waiting for lock " + iSchedulingRule.toString() + " so it could not time out."));
        }
        this.graph[n2][n] = NO_STATE;
        this.reduceGraph(n2, iSchedulingRule);
    }

    private boolean ownsLocks(Thread thread) {
        int n = this.indexOf(thread, false);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            if (this.graph[n][n2] > NO_STATE) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean ownsRealLocks(Thread thread) {
        int n = this.indexOf(thread, false);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            Object e;
            if (this.graph[n][n2] > NO_STATE && (e = this.locks.get(n2)) instanceof ILock) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean ownsRuleLocks(Thread thread) {
        int n = this.indexOf(thread, false);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            Object e;
            if (this.graph[n][n2] > NO_STATE && !((e = this.locks.get(n2)) instanceof ILock)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ISchedulingRule[] realLocksForThread(Thread thread) {
        int n = this.indexOf(thread, false);
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < this.graph[n].length) {
            if (this.graph[n][n2] > NO_STATE && this.locks.get(n2) instanceof ILock) {
                arrayList.add(this.locks.get(n2));
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            Assert.isLegal((boolean)false, (String)"A thread with no real locks was chosen to resolve deadlock.");
        }
        return arrayList.toArray(new ISchedulingRule[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void reduceGraph(int var1_1, ISchedulingRule var2_2) {
        var3_3 = this.locks.size();
        var4_4 = new boolean[var3_3];
        var5_5 = 0;
        while (var5_5 < var3_3) {
            if (var2_2.isConflicting((ISchedulingRule)this.locks.get(var5_5)) || !(this.locks.get(var5_5) instanceof ILock)) {
                var4_4[var5_5] = true;
            }
            ++var5_5;
        }
        var5_5 = 1;
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < this.graph[var1_1].length) {
            if (this.graph[var1_1][var7_7] != DeadlockDetector.NO_STATE) {
                var5_5 = 0;
                break;
            }
            ++var7_7;
        }
        var7_7 = var4_4.length - 1;
        while (var7_7 >= 0) {
            var8_8 = 0;
            while (var8_8 < this.graph.length) {
                if (var4_4[var7_7] && this.graph[var8_8][var7_7] != DeadlockDetector.NO_STATE) {
                    var4_4[var7_7] = false;
                    break;
                }
                ++var8_8;
            }
            if (var4_4[var7_7]) {
                this.locks.remove(var7_7);
                ++var6_6;
            }
            --var7_7;
        }
        if (var6_6 == 0 && var5_5 == 0) {
            return;
        }
        if (var5_5 != 0) {
            this.lockThreads.remove(var1_1);
        }
        var7_7 = this.lockThreads.size();
        var3_3 = this.locks.size();
        if (var7_7 == 0 && var3_3 == 0) {
            this.graph = DeadlockDetector.EMPTY_MATRIX;
            return;
        }
        var8_9 = new int[var7_7][var3_3];
        var9_10 = 0;
        var10_11 = 0;
        while (var10_11 < this.graph.length - var9_10) {
            block15: {
                block14: {
                    if (var10_11 == var1_1 && var5_5 != 0 && var10_11 >= this.graph.length - ++var9_10) break;
                    var11_12 = 0;
                    var12_13 = 0;
                    break block14;
                    while (var12_13 < this.graph[var10_11].length - ++var11_12) lbl-1000:
                    // 2 sources

                    {
                        ** while (!var4_4[var12_13 + var11_12])
lbl53:
                        // 1 sources

                    }
lbl54:
                    // 2 sources

                    if (var12_13 >= this.graph[var10_11].length - var11_12) break block15;
                    var8_9[var10_11][var12_13] = this.graph[var10_11 + var9_10][var12_13 + var11_12];
                    ++var12_13;
                }
                if (var12_13 < this.graph[var10_11].length - var11_12) ** GOTO lbl-1000
            }
            ++var10_11;
        }
        this.graph = var8_9;
        Assert.isTrue((boolean)(var7_7 == this.graph.length), (String)"Rows and threads don't match.");
        Assert.isTrue((boolean)(var3_3 == (this.graph.length > 0 ? this.graph[0].length : 0)), (String)"Columns and locks don't match.");
    }

    private void reportDeadlock(Deadlock deadlock) {
        String string = "Deadlock detected. All locks owned by thread " + deadlock.getCandidate().getName() + " will be suspended.";
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.jobs", 2, string, (Throwable)new IllegalStateException());
        Thread[] threadArray = deadlock.getThreads();
        int n = 0;
        while (n < threadArray.length) {
            Object[] objectArray = this.getOwnedLocks(threadArray[n]);
            Object object = this.getWaitingLock(threadArray[n]);
            StringBuffer stringBuffer = new StringBuffer("Thread ");
            stringBuffer.append(threadArray[n].getName());
            stringBuffer.append(" has locks: ");
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append(objectArray[n2]);
                stringBuffer.append(n2 < objectArray.length - 1 ? ", " : " ");
                ++n2;
            }
            stringBuffer.append("and is waiting for lock ");
            stringBuffer.append(object);
            Status status = new Status(4, "org.eclipse.core.jobs", 2, stringBuffer.toString(), null);
            multiStatus.add((IStatus)status);
            ++n;
        }
        RuntimeLog.log((IStatus)multiStatus);
    }

    private void resizeGraph() {
        int n = this.lockThreads.size();
        int n2 = this.locks.size();
        if (n == 0 && n2 == 0) {
            this.graph = EMPTY_MATRIX;
            return;
        }
        int[][] nArray = new int[n][n2];
        int n3 = 0;
        while (n3 < this.graph.length) {
            System.arraycopy(this.graph[n3], 0, nArray[n3], 0, this.graph[n3].length);
            ++n3;
        }
        this.graph = nArray;
        this.resize = false;
    }

    private Thread resolutionCandidate(Thread[] threadArray) {
        int n = 0;
        while (n < threadArray.length) {
            if (!this.ownsRuleLocks(threadArray[n])) {
                return threadArray[n];
            }
            ++n;
        }
        n = 0;
        while (n < threadArray.length) {
            if (this.ownsRealLocks(threadArray[n])) {
                return threadArray[n];
            }
            ++n;
        }
        return threadArray[0];
    }

    private void setToWait(Thread thread, ISchedulingRule iSchedulingRule, boolean bl) {
        boolean bl2 = false;
        if (!bl && !(iSchedulingRule instanceof ILock)) {
            bl2 = true;
        }
        int n = this.indexOf(iSchedulingRule, !bl);
        int n2 = this.indexOf(thread, !bl);
        if (this.resize) {
            this.resizeGraph();
        }
        this.graph[n2][n] = WAITING_FOR_LOCK;
        if (bl2) {
            this.fillPresentEntries(iSchedulingRule, n);
        }
    }

    public String toDebugString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println(" :: ");
        int n = 0;
        while (n < this.locks.size()) {
            printWriter.print(" " + this.locks.get(n) + ',');
            ++n;
        }
        printWriter.println();
        n = 0;
        while (n < this.graph.length) {
            printWriter.print(" " + ((Thread)this.lockThreads.get(n)).getName() + " : ");
            int n2 = 0;
            while (n2 < this.graph[n].length) {
                printWriter.print(" " + this.graph[n][n2] + ',');
                ++n2;
            }
            printWriter.println();
            ++n;
        }
        printWriter.println("-------");
        return stringWriter.toString();
    }
}

