/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.Semaphore;

public class UILockListener
extends LockListener {
    protected Display display;
    protected final Queue pendingWork = new Queue();
    protected Semaphore currentWork = null;
    protected Thread ui;

    public UILockListener(Display display) {
        this.display = display;
    }

    public void aboutToRelease() {
        if (this.isUI()) {
            this.ui = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean aboutToWait(Thread thread) {
        if (!this.isUI()) return false;
        if (this.currentWork != null && this.currentWork.getOperationThread() == thread) {
            return true;
        }
        this.ui = Thread.currentThread();
        try {
            this.doPendingWork();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.ui = Thread.currentThread();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.ui = Thread.currentThread();
        return false;
    }

    void addPendingWork(Semaphore semaphore) {
        this.pendingWork.add(semaphore);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doPendingWork() {
        Semaphore semaphore;
        while ((semaphore = this.pendingWork.remove()) != null) {
            Object var4_4;
            Semaphore semaphore2 = this.currentWork;
            try {
                this.currentWork = semaphore;
                Runnable runnable = semaphore.getRunnable();
                if (runnable != null) {
                    runnable.run();
                }
            }
            catch (Throwable throwable) {
                var4_4 = null;
                this.currentWork = semaphore2;
                semaphore.release();
                throw throwable;
            }
            {
                var4_4 = null;
                this.currentWork = semaphore2;
                semaphore.release();
                continue;
            }
            break;
        }
        return;
    }

    void interruptUI() {
        this.display.getThread().interrupt();
    }

    boolean isLockOwner() {
        return this.isLockOwnerThread();
    }

    boolean isUI() {
        return !this.display.isDisposed() && this.display.getThread() == Thread.currentThread();
    }

    boolean isUIWaiting() {
        return this.ui != null && Thread.currentThread() != this.ui;
    }

    public class Queue {
        private static final int BASE_SIZE = 8;
        protected Semaphore[] elements = new Semaphore[8];
        protected int head = 0;
        protected int tail = 0;

        public synchronized void add(Semaphore semaphore) {
            int n = this.increment(this.tail);
            if (n == this.head) {
                this.grow();
                n = this.tail + 1;
            }
            this.elements[this.tail] = semaphore;
            this.tail = n;
        }

        private void grow() {
            int n = this.elements.length * 2;
            Semaphore[] semaphoreArray = new Semaphore[n];
            if (this.tail >= this.head) {
                System.arraycopy(this.elements, this.head, semaphoreArray, this.head, this.size());
            } else {
                int n2 = n - (this.elements.length - this.head);
                System.arraycopy(this.elements, 0, semaphoreArray, 0, this.tail + 1);
                System.arraycopy(this.elements, this.head, semaphoreArray, n2, n - n2);
                this.head = n2;
            }
            this.elements = semaphoreArray;
        }

        private int increment(int n) {
            return n == this.elements.length - 1 ? 0 : n + 1;
        }

        public synchronized Semaphore remove() {
            if (this.tail == this.head) {
                return null;
            }
            Semaphore semaphore = this.elements[this.head];
            this.elements[this.head] = null;
            this.head = this.increment(this.head);
            if (this.tail == this.head && this.elements.length > 8) {
                this.elements = new Semaphore[8];
                this.head = 0;
                this.tail = 0;
            }
            return semaphore;
        }

        private int size() {
            return this.tail > this.head ? this.tail - this.head : this.elements.length - this.head + this.tail;
        }
    }
}

